/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.other;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.Grave;
import eu.pb4.graves.other.GraveUtils;
import eu.pb4.graves.other.Location;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1306;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public record VisualGraveData(GameProfile gameProfile, byte visualSkinModelLayers, class_1306 mainArm, class_2561 deathCause, long creationTime, Location location, int minecraftDay) {
    public static final VisualGraveData DEFAULT = new VisualGraveData(Grave.DEFAULT_GAME_PROFILE, -1, class_1306.field_6183, Grave.DEFAULT_DEATH_CAUSE, 0L, new Location(new class_2960("the_void"), class_2338.field_10980), -1);

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("GameProfile", (class_2520)class_2512.method_10684((class_2487)new class_2487(), (GameProfile)this.gameProfile));
        nbt.method_10582("DeathCause", class_2561.class_2562.method_10867((class_2561)this.deathCause));
        nbt.method_10544("CreationTime", this.creationTime);
        nbt.method_10569("MinecraftDay", this.minecraftDay);
        nbt.method_10567("SkinModelParts", this.visualSkinModelLayers);
        nbt.method_10567("MainArm", (byte)this.mainArm.method_7362());
        this.location.writeNbt(nbt);
        return nbt;
    }

    public Map<String, class_2561> getPlaceholders(MinecraftServer server) {
        Config config = ConfigManager.getConfig();
        HashMap<String, class_2561> values = new HashMap<String, class_2561>();
        values.put("player", (class_2561)class_2561.method_43470((String)(this.gameProfile != null && this.gameProfile.getName() != null ? this.gameProfile.getName() : "<No player!>")));
        values.put("protection_time", (class_2561)class_2561.method_43470((String)(config.protection.protectionTime > -1 ? config.getFormattedTime(0L) : config.texts.infinityText)));
        values.put("break_time", (class_2561)class_2561.method_43470((String)(config.protection.breakingTime > -1 ? config.getFormattedTime(0L) : config.texts.infinityText)));
        values.put("xp", (class_2561)class_2561.method_43470((String)"0"));
        values.put("item_count", (class_2561)class_2561.method_43470((String)"0"));
        values.put("position", (class_2561)class_2561.method_43470((String)this.location.blockPos().method_23854()));
        values.put("world", GraveUtils.toWorldName(this.location.world()));
        values.put("death_cause", this.deathCause);
        values.put("minecraft_day", (class_2561)class_2561.method_43470((String)("" + this.minecraftDay)));
        values.put("creation_date", (class_2561)class_2561.method_43470((String)config.texts.fullDateFormat.format().format(new Date(this.creationTime * 1000L))));
        values.put("since_creation", (class_2561)class_2561.method_43470((String)config.getFormattedTime(System.currentTimeMillis() / 1000L - this.creationTime)));
        values.put("id", (class_2561)class_2561.method_43470((String)"<no id>"));
        return values;
    }

    public static VisualGraveData fromNbt(class_2487 nbt) {
        return new VisualGraveData(class_2512.method_10683((class_2487)nbt.method_10562("GameProfile")), nbt.method_10573("SkinModelParts", 1) ? (byte)nbt.method_10571("SkinModelParts") : (byte)-1, nbt.method_10573("MainArm", 1) ? (nbt.method_10571("MainArm") == class_1306.field_6182.method_7362() ? class_1306.field_6182 : class_1306.field_6183) : class_1306.field_6183, (class_2561)class_2561.class_2562.method_10877((String)nbt.method_10558("DeathCause")), nbt.method_10537("CreationTime"), Location.fromNbt(nbt), nbt.method_10550("MinecraftDay"));
    }
}

