/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.ui;

import eu.pb4.graves.GraveTextures;
import eu.pb4.graves.ui.GuiSlot;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;

public abstract class PagedGui
extends SimpleGui {
    public static final int PAGE_SIZE = 36;
    protected int page = 0;

    public PagedGui(class_3222 player) {
        super(class_3917.field_18667, player, false);
    }

    public void setTitle(class_2561 title) {
        super.setTitle(GraveTextures.get(this.getPlayer(), title));
    }

    protected void nextPage() {
        this.page = Math.min(this.getPageAmount() - 1, this.page + 1);
        this.updateDisplay();
    }

    protected boolean canNextPage() {
        return this.getPageAmount() > this.page + 1;
    }

    protected void previousPage() {
        this.page = Math.max(0, this.page - 1);
        this.updateDisplay();
    }

    protected boolean canPreviousPage() {
        return this.page - 1 >= 0;
    }

    protected void updateDisplay() {
        int i;
        int offset = this.page * 36;
        for (i = 0; i < 36; ++i) {
            GuiSlot element = this.getElement(offset + i);
            if (element == null) {
                element = GuiSlot.empty();
            }
            if (element.element() != null) {
                this.setSlot(i, element.element());
                continue;
            }
            if (element.slot() == null) continue;
            this.setSlotRedirect(i, element.slot());
        }
        for (i = 0; i < 9; ++i) {
            GuiSlot navElement = this.getNavElement(i);
            if (navElement == null) {
                navElement = GuiSlot.empty();
            }
            if (navElement.element() != null) {
                this.setSlot(i + 36, navElement.element());
                continue;
            }
            if (navElement.slot() == null) continue;
            this.setSlotRedirect(i + 36, navElement.slot());
        }
    }

    protected int getPage() {
        return this.page;
    }

    protected abstract int getPageAmount();

    protected abstract GuiSlot getElement(int var1);

    protected abstract GuiSlot getNavElement(int var1);

    public static final void playClickSound(class_3222 player) {
        player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
    }

    public static final void playClickSound(class_3222 player, class_3414 soundEvent) {
        player.method_17356(soundEvent, class_3419.field_15250, 1.0f, 1.0f);
    }
}

