/*
 * Decompiled with CFR 0.152.
 */
package pyzpre.createbicyclesbitterballen.compat.rei;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.rei.category.CreateRecipeCategory;
import com.simibubi.create.compat.rei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.compat.rei.display.CreateDisplay;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.apache.commons.lang3.mutable.MutableInt;
import pyzpre.createbicyclesbitterballen.block.mechanicalfryer.DeepFryingRecipe;
import pyzpre.createbicyclesbitterballen.compat.rei.animations.AnimatedFryer;

@ParametersAreNonnullByDefault
public class FryingCategory
extends CreateRecipeCategory<DeepFryingRecipe> {
    private final AnimatedFryer fryer = new AnimatedFryer();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    FryingType type;

    public static FryingCategory standard(CreateRecipeCategory.Info<DeepFryingRecipe> info) {
        return new FryingCategory(info, FryingType.FRYING);
    }

    protected FryingCategory(CreateRecipeCategory.Info<DeepFryingRecipe> info, FryingType type) {
        super(info);
        this.type = type;
    }

    public void addWidgets(CreateDisplay<DeepFryingRecipe> display, List<Widget> widgets, Point origin, Rectangle bounds) {
        int j;
        int i;
        DeepFryingRecipe recipe = (DeepFryingRecipe)display.getRecipe();
        class_2371 fluidIngredients = recipe.getFluidIngredients();
        List ingredients = ItemHelper.condenseIngredients((class_2371)recipe.method_8117());
        List itemOutputs = recipe.getRollableResults();
        List results = ((DeepFryingRecipe)display.getRecipe()).getRollableResults();
        class_2371 fluidOutputs = recipe.getFluidResults();
        int size = ingredients.size() + fluidIngredients.size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int yOffset = 0;
        Point inputSlotPoint = new Point(origin.x + 26, origin.y + 51);
        widgets.add(Widgets.createSlotBackground((Point)inputSlotPoint));
        Point inputFluidSlotPoint = new Point(origin.x + 45, origin.y + 51);
        widgets.add(Widgets.createSlotBackground((Point)inputFluidSlotPoint));
        Point outputSlotPoint = new Point(origin.x + 142, origin.y + 51);
        widgets.add(Widgets.createSlotBackground((Point)outputSlotPoint));
        for (i = 0; i < ingredients.size(); ++i) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            Pair pair = (Pair)ingredients.get(i);
            class_1856 ingredient = (class_1856)pair.getFirst();
            MutableInt amount = (MutableInt)pair.getSecond();
            for (class_1799 itemStack : ingredient.method_8105()) {
                class_1799 stack = itemStack.method_7972();
                stack.method_7939(amount.getValue().intValue());
                stacks.add(stack);
            }
            widgets.add((Widget)FryingCategory.basicSlot((int)(origin.x + 17 + xOffset + i % 3 * 19), (int)(origin.y + 51 - i / 3 * 19 + yOffset)).markInput().entries((Collection)EntryIngredients.ofItemStacks(stacks)));
        }
        for (j = 0; j < fluidIngredients.size(); ++j) {
            int i2 = i + j;
            List stacks = ((FluidIngredient)fluidIngredients.get(j)).getMatchingFluidStacks();
            Slot fluidSlot = FryingCategory.basicSlot((int)(origin.x + 17 + xOffset + i2 % 3 * 19), (int)(origin.y + 51 - i2 / 3 * 19 + yOffset)).markInput().entries((Collection)EntryIngredients.of((FluidStack)CreateRecipeCategory.convertToREIFluid((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)stacks.get(0)))));
            CreateRecipeCategory.setFluidRenderRatio((Slot)fluidSlot);
            widgets.add((Widget)fluidSlot);
        }
        int outSize = fluidOutputs.size() + itemOutputs.size();
        for (int outputIndex = 0; outputIndex < outSize; ++outputIndex) {
            int xPosition = 141 - (outSize % 2 != 0 && outputIndex == outSize - 1 ? 0 : (outputIndex % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (outputIndex / 2) + 50 + yOffset;
            if (itemOutputs.size() > outputIndex) {
                ProcessingOutput result = (ProcessingOutput)itemOutputs.get(outputIndex);
                Slot outputSlot = FryingCategory.basicSlot((int)(origin.x + xPosition + 1), (int)(origin.y + yPosition + yOffset + 1)).markOutput().entries((Collection)EntryIngredients.of((class_1799)result.getStack()));
                widgets.add((Widget)outputSlot);
                FryingCategory.addStochasticTooltip((Slot)outputSlot, (ProcessingOutput)result);
                ++i;
                continue;
            }
            Slot fluidSlot = FryingCategory.basicSlot((int)(origin.x + xPosition + 1), (int)(origin.y + yPosition + 1 + yOffset)).markOutput().entries((Collection)EntryIngredients.of((FluidStack)CreateRecipeCategory.convertToREIFluid((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)((io.github.fabricators_of_create.porting_lib.fluids.FluidStack)fluidOutputs.get(outputIndex - itemOutputs.size())))));
            CreateRecipeCategory.setFluidRenderRatio((Slot)fluidSlot);
            widgets.add((Widget)fluidSlot);
            ++j;
        }
        FryingCategory.addFluidTooltip(widgets, (List)fluidIngredients, (List)fluidOutputs);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            widgets.add((Widget)FryingCategory.basicSlot((int)(origin.x + 134), (int)(origin.y + 81)).markInput().entries((Collection)EntryIngredients.of((class_1799)AllBlocks.BLAZE_BURNER.asStack())));
            ++i;
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            widgets.add((Widget)FryingCategory.basicSlot((int)(origin.x + 153), (int)(origin.y + 81)).markOutput().entries((Collection)EntryIngredients.of((class_1799)AllItems.BLAZE_CAKE.asStack())));
            ++i;
        }
    }

    public void draw(DeepFryingRecipe recipe, class_332 graphics, double mouseX, double mouseY) {
        super.draw((class_1860)recipe, graphics, mouseX, mouseY);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        int vRows = (1 + recipe.getFluidResults().size() + recipe.getRollableResults().size()) / 2;
        if (vRows <= 2) {
            AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, -19 * (vRows - 1) + 32);
        }
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.render(graphics, 81, 58 + (noHeat ? 10 : 30));
        AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.render(graphics, 4, 80);
        graphics.method_51439(class_310.method_1551().field_1772, (class_2561)Lang.translateDirect((String)requiredHeat.getTranslationKey(), (Object[])new Object[0]), 9, 86, requiredHeat.getColor(), false);
        if (!noHeat) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, this.getDisplayWidth(null) / 2 + 3, 55);
        }
        this.fryer.draw(graphics, this.getDisplayWidth(null) / 2 + 3, 34);
    }

    static enum FryingType {
        FRYING;

    }
}

