/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.sound;

import com.mrh0.createaddition.sound.CAContinuousSound;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1144;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;

class CASoundScape {
    List<CAContinuousSound> continuous;
    private final float pitch;
    private final CASoundScapes.AmbienceGroup group;
    private class_243 meanPos;
    private final CASoundScapes.PitchGroup pitchGroup;

    public CASoundScape(float pitch, CASoundScapes.AmbienceGroup group) {
        this.pitchGroup = CASoundScapes.getGroupFromPitch(pitch);
        this.pitch = pitch;
        this.group = group;
        this.continuous = new ArrayList<CAContinuousSound>();
    }

    public CASoundScape continuous(class_3414 sound, float relativeVolume, float relativePitch) {
        return this.add(new CAContinuousSound(sound, this, this.pitch * relativePitch, relativeVolume));
    }

    public CASoundScape add(CAContinuousSound continuousSound) {
        this.continuous.add(continuousSound);
        return this;
    }

    public void play() {
        this.continuous.forEach(arg_0 -> ((class_1144)class_310.method_1551().method_1483()).method_4873(arg_0));
    }

    public void tick() {
        if (AnimationTickHolder.getTicks() % 5 == 0) {
            this.meanPos = null;
        }
    }

    public void remove() {
        this.continuous.forEach(CAContinuousSound::remove);
    }

    public class_243 getMeanPos() {
        return this.meanPos == null ? (this.meanPos = this.determineMeanPos()) : this.meanPos;
    }

    private class_243 determineMeanPos() {
        this.meanPos = class_243.field_1353;
        int amount = 0;
        for (class_2338 blockPos : CASoundScapes.getAllLocations(this.group, this.pitchGroup)) {
            this.meanPos = this.meanPos.method_1019(VecHelper.getCenterOf((class_2382)blockPos));
            ++amount;
        }
        if (amount == 0) {
            return this.meanPos;
        }
        return this.meanPos.method_1021((double)(1.0f / (float)amount));
    }

    public float getVolume() {
        class_1297 renderViewEntity = class_310.method_1551().field_1719;
        float distanceMultiplier = 0.0f;
        if (renderViewEntity != null) {
            double distanceTo = renderViewEntity.method_19538().method_1022(this.getMeanPos());
            distanceMultiplier = (float)class_3532.method_16436((double)(distanceTo / 16.0), (double)2.0, (double)0.0);
        }
        int soundCount = CASoundScapes.getSoundCount(this.group, this.pitchGroup);
        float max = AllConfigs.client().ambientVolumeCap.getF();
        float argMax = 15.0f;
        return class_3532.method_15363((float)((float)soundCount / (argMax * 10.0f)), (float)0.025f, (float)max) * distanceMultiplier;
    }
}

