/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.tileentity;

import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import shetiphian.core.common.Function;
import shetiphian.core.common.tileentity.TileEntityBase;

public class TileEntityExtendedRedstone
extends TileEntityBase {
    private final int MULTIPLIER;
    private final int MAXIMUM;
    private int redstone = 0;
    private boolean enabled = true;

    public TileEntityExtendedRedstone(class_2591<?> type, class_2338 pos, class_2680 state) {
        this(type, pos, state, 5);
    }

    public TileEntityExtendedRedstone(class_2591<?> type, class_2338 pos, class_2680 state, int multiplier) {
        super(type, pos, state);
        this.MULTIPLIER = multiplier;
        this.MAXIMUM = 15 * this.MULTIPLIER;
    }

    @Override
    protected void buildNBT(class_2487 nbtTag) {
        nbtTag.method_10569("redstone", this.redstone);
    }

    @Override
    protected void processNBT(class_2487 nbtTag) {
        this.redstone = nbtTag.method_10550("redstone");
    }

    public int getExPower() {
        return class_3532.method_15340((int)this.redstone, (int)0, (int)this.MAXIMUM);
    }

    public int getRSPower() {
        return class_3532.method_15340((int)(this.redstone / this.MULTIPLIER), (int)0, (int)15);
    }

    public void setExPower(int redstone) {
        this.redstone = class_3532.method_15340((int)redstone, (int)0, (int)this.MAXIMUM);
    }

    public void setRSPower(int redstone) {
        this.redstone = class_3532.method_15340((int)redstone, (int)0, (int)15) * this.MULTIPLIER;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean updatePower() {
        int powerIn;
        int newPower;
        int currentPower;
        if (this.field_11863 != null && !this.field_11863.method_8608() && (currentPower = this.getExPower()) != (newPower = class_3532.method_15340((int)((powerIn = this.isEnabled() ? this.doPowerCalculation() : 0) - 1), (int)0, (int)this.MAXIMUM))) {
            this.setExPower(newPower);
            Function.syncTile(this);
            this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
            for (class_2350 direction : class_2350.values()) {
                this.field_11863.method_8452(this.field_11867.method_10093(direction), this.method_11010().method_26204());
            }
            return true;
        }
        return false;
    }

    private int doPowerCalculation() {
        int power = this.getPowerAt(this.field_11867.method_10074(), class_2350.field_11033);
        if (power >= this.MAXIMUM) {
            return power;
        }
        if ((power = Math.max(power, this.getPowerAt(this.field_11867.method_10084(), class_2350.field_11036))) >= this.MAXIMUM) {
            return power;
        }
        if ((power = Math.max(power, this.getPowerAt(this.field_11867.method_10095(), class_2350.field_11043))) >= this.MAXIMUM) {
            return power;
        }
        if ((power = Math.max(power, this.getPowerAt(this.field_11867.method_10072(), class_2350.field_11035))) >= this.MAXIMUM) {
            return power;
        }
        if ((power = Math.max(power, this.getPowerAt(this.field_11867.method_10067(), class_2350.field_11039))) >= this.MAXIMUM) {
            return power;
        }
        power = Math.max(power, this.getPowerAt(this.field_11867.method_10078(), class_2350.field_11034));
        return Math.min(power, this.MAXIMUM);
    }

    private int getPowerAt(class_2338 pos, class_2350 direction) {
        if (this.field_11863 != null) {
            class_2586 tile = this.field_11863.method_8321(pos);
            if (tile instanceof TileEntityExtendedRedstone) {
                return ((TileEntityExtendedRedstone)tile).getExPower();
            }
            class_2680 state = this.field_11863.method_8320(pos);
            return Math.max(state.method_26203((class_1922)this.field_11863, pos, direction), state.method_26195((class_1922)this.field_11863, pos, direction)) * this.MULTIPLIER;
        }
        return 0;
    }
}

