/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.teams;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import shetiphian.core.common.NameHelper;
import shetiphian.core.internal.ShetiPhianCore;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.network.PacketNameSync;
import shetiphian.core.internal.teams.PacketTeamSync;
import shetiphian.core.internal.teams.PlayerTeam;
import shetiphian.core.internal.teams.TeamSaveData;

public class TeamHelper {
    static TeamSaveData SAVEDATA = new TeamSaveData();
    static final Map<UUID, PlayerTeam> PLAYER_TEAM = new HashMap<UUID, PlayerTeam>();

    public static Set<String> getTeams() {
        return TeamHelper.SAVEDATA.TEAMS.keySet();
    }

    public static boolean doesTeamExist(String id) {
        return TeamHelper.SAVEDATA.TEAMS.containsKey(id);
    }

    public static class_2561 getTeamDisplayName(String id) {
        return TeamHelper.doesTeamExist(id) ? TeamHelper.SAVEDATA.TEAMS.get(id).getDisplayName() : class_2561.method_43470((String)("? " + id + " ?"));
    }

    public static PlayerTeam getTeam(String id) {
        return TeamHelper.SAVEDATA.TEAMS.get(id);
    }

    public static PlayerTeam getTeam(class_1657 player) {
        return TeamHelper.getTeam(player.method_5667());
    }

    public static PlayerTeam getTeam(UUID player) {
        return PLAYER_TEAM.getOrDefault(player, null);
    }

    static List<UUID> deleteTeam(String id) {
        PlayerTeam team = TeamHelper.SAVEDATA.TEAMS.get(id);
        if (team != null) {
            List<UUID> members = team.getMembers();
            members.forEach(PLAYER_TEAM::remove);
            TeamHelper.SAVEDATA.TEAMS.remove(id);
            TeamHelper.markDirty();
            NetworkHandler.sendToList(new PacketTeamSync(team, null), members);
            TeamHelper.syncDisplayName(id, "? " + id + " ?");
            return members;
        }
        return Collections.emptyList();
    }

    static void syncDisplayName(String teamId, String display) {
        NameHelper.setTeamName(teamId, display);
        NetworkHandler.sendToAll(new PacketNameSync(teamId, display));
    }

    public static void load(MinecraftServer server, class_3218 world) {
        ShetiPhianCore.LOGGER.info("Loading Teams Data");
        SAVEDATA = (TeamSaveData)world.method_17983().method_17924(TeamSaveData::load, TeamSaveData::new, "shetiphiancore_teams");
        SAVEDATA.migrate(server);
        ShetiPhianCore.LOGGER.info("Finished Loading Teams Data");
    }

    public static void markDirty() {
        SAVEDATA.method_80();
    }
}

