/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.util.BoxOctree;
import com.yungnickyoung.minecraft.yungsapi.world.structure.action.StructureAction;
import com.yungnickyoung.minecraft.yungsapi.world.structure.action.StructureActionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.PieceEntry;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawSinglePoolElement;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3784;
import net.minecraft.class_3790;
import net.minecraft.class_5819;
import net.minecraft.class_5820;

public class TransformAction
extends StructureAction {
    private static final Codec<Either<class_2960, class_3499>> TEMPLATE_CODEC = Codec.of(TransformAction::encodeTemplate, (Decoder)class_2960.field_25139.map(Either::left));
    public static final Codec<TransformAction> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)TEMPLATE_CODEC.listOf().fieldOf("output").forGetter(action -> action.output), (App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(action -> action.xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(action -> action.yOffset), (App)Codec.INT.optionalFieldOf("z_offset", (Object)0).forGetter(action -> action.zOffset)).apply((Applicative)builder, TransformAction::new));
    private final List<Either<class_2960, class_3499>> output;
    private final int xOffset;
    private final int yOffset;
    private final int zOffset;

    private static <T> DataResult<T> encodeTemplate(Either<class_2960, class_3499> either, DynamicOps<T> ops, T data) {
        return either.left().isEmpty() ? DataResult.error(() -> "yungsapi - Cannot serialize a runtime pool element") : class_2960.field_25139.encode((Object)((class_2960)either.left().get()), ops, data);
    }

    public TransformAction(List<Either<class_2960, class_3499>> output, int xOffset, int yOffset, int zOffset) {
        this.output = output;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    @Override
    public StructureActionType<?> type() {
        return StructureActionType.TRANSFORM;
    }

    @Override
    public void apply(StructureContext ctx, PieceEntry targetPieceEntry) {
        class_3485 templateManager = ctx.structureTemplateManager();
        if (templateManager == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'structureTemplateManager' for transform action!");
            return;
        }
        YungJigsawSinglePoolElement old = (YungJigsawSinglePoolElement)targetPieceEntry.getPiece().method_16644();
        class_2919 rand = new class_2919((class_5819)new class_5820(0L));
        rand.method_12664((long)targetPieceEntry.getPiece().method_16648().method_10263(), targetPieceEntry.getPiece().method_16648().method_10264(), targetPieceEntry.getPiece().method_16648().method_10263());
        Either<class_2960, class_3499> newTemplate = this.output.get(rand.method_43048(this.output.size()));
        YungJigsawSinglePoolElement newElement = new YungJigsawSinglePoolElement(newTemplate, old.processors, old.method_16624(), old.name, old.maxCount, old.minRequiredDepth, old.maxPossibleDepth, old.isPriority, old.ignoreBounds, old.condition, old.enhancedTerrainAdaptation, old.deadendPool, old.modifiers);
        class_2338 offset = new class_2338(this.xOffset, this.yOffset, this.zOffset);
        offset = offset.method_10070(targetPieceEntry.getPiece().method_16888());
        class_2338 newPos = targetPieceEntry.getPiece().method_16648().method_10081((class_2382)offset);
        class_3341 newBoundingBox = newElement.method_16628(templateManager, newPos, targetPieceEntry.getPiece().method_16888());
        class_238 newAabb = class_238.method_19316((class_3341)newBoundingBox);
        ((BoxOctree)targetPieceEntry.getBoxOctree().getValue()).removeBox(targetPieceEntry.getPieceAabb());
        ((BoxOctree)targetPieceEntry.getBoxOctree().getValue()).addBox(newAabb);
        class_3790 newPiece = new class_3790(templateManager, (class_3784)newElement, newPos, targetPieceEntry.getPiece().method_16646(), targetPieceEntry.getPiece().method_16888(), newBoundingBox);
        targetPieceEntry.setPiece(newPiece);
    }
}

