/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.configs.ModConfigs;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public class ECNetworking {
    public static final ChannelHandler CHANNEL = ChannelHandler.builder((String)"everycomp").register(NetworkDir.PLAY_TO_CLIENT, S2CBlockStateCheckMessage.class, S2CBlockStateCheckMessage::new).register(NetworkDir.BOTH, S2CModVersionCheckMessage.class, S2CModVersionCheckMessage::new).version(2).build();
    private static int lastInd = 0;

    public static void init() {
    }

    public static void sendPacket(class_3222 s) {
        if (ModConfigs.DEBUG_PACKET.get().booleanValue() || PlatHelper.isDev()) {
            lastInd = 0;
            EveryCompat.LOGGER.warn("Starting Blockstate Map validity check:");
            while (lastInd < class_2248.field_10651.method_10204()) {
                CHANNEL.sendToClientPlayer(s, (Message)new S2CBlockStateCheckMessage());
            }
        }
    }

    public static class S2CBlockStateCheckMessage
    implements Message {
        public S2CBlockStateCheckMessage(class_2540 buf) {
            int start = buf.method_10816();
            int size = buf.method_10816();
            boolean mismatched = false;
            for (int i = start; i < start + size; ++i) {
                try {
                    class_2680 exp;
                    class_2680 b;
                    class_2487 nbt = buf.method_10798();
                    if (nbt == null) {
                        boolean bl = true;
                    }
                    if ((b = Utils.readBlockState((class_2487)nbt, null)) != (exp = (class_2680)class_2248.field_10651.method_10200(i))) {
                        if (!mismatched) {
                            EveryCompat.LOGGER.error("Found blockstate id mismatch from " + b + "at id " + i + ". Was expecting: " + exp);
                        }
                        mismatched = true;
                        continue;
                    }
                    if (mismatched) {
                        EveryCompat.LOGGER.error("to" + b + "at id " + i);
                    }
                    mismatched = false;
                    continue;
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to read blockstate in id map: ", (Throwable)e);
                    break;
                }
            }
            buf.release();
        }

        public S2CBlockStateCheckMessage() {
        }

        public void writeToBuffer(class_2540 buf) {
            class_2540 dummy = new class_2540(Unpooled.buffer());
            int start = lastInd;
            int i = lastInd;
            while (i < class_2248.field_10651.method_10204()) {
                ++lastInd;
                class_2487 nbt = class_2512.method_10686((class_2680)class_2248.method_9531((int)i));
                dummy.method_10794(nbt);
                if ((double)dummy.writerIndex() > 943718.4) break;
                ++i;
            }
            buf.method_10804(start);
            buf.method_10804(lastInd - start);
            buf.writeBytes((ByteBuf)dummy);
            dummy.release();
        }

        public void handle(ChannelHandler.Context context) {
        }
    }

    public static class S2CModVersionCheckMessage
    implements Message {
        private final Map<String, String> mods = new HashMap<String, String>();

        public S2CModVersionCheckMessage() {
            for (String m : EveryCompat.DEPENDENCIES) {
                String v = PlatHelper.getModVersion((String)m);
                if (v == null) continue;
                this.mods.put(m, v);
            }
        }

        public S2CModVersionCheckMessage(class_2540 buf) {
            this.mods.putAll(buf.method_34067(buf1 -> buf.method_19772(), buf1 -> buf.method_19772()));
        }

        public void writeToBuffer(class_2540 buf) {
            buf.method_34063(this.mods, (buf1, s) -> buf.method_10814(s), (buf1, s) -> buf.method_10814(s));
        }

        public void handle(ChannelHandler.Context context) {
            for (Map.Entry<String, String> m : this.mods.entrySet()) {
                String clientVersion = PlatHelper.getModVersion((String)m.getKey());
                String serverVersion = m.getValue();
                if (Objects.equals(serverVersion, clientVersion)) continue;
                context.disconnect((class_2561)class_2561.method_43470((String)("EveryCompat has detected that server has mismatched mod versions for mod " + m.getKey() + ": requested version " + serverVersion + ", actual version " + clientVersion)));
            }
        }
    }
}

