/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.ECNetworking;
import net.mehvahdjukaar.every_compat.UnsafeModuleDisabler;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EveryCompatAPI;
import net.mehvahdjukaar.every_compat.configs.ModConfigs;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.AllWoodItem;
import net.mehvahdjukaar.every_compat.modules.another_furniture.AnotherFurnitureModule;
import net.mehvahdjukaar.every_compat.modules.camp_chair.CampChairModule;
import net.mehvahdjukaar.every_compat.modules.chipped.ChippedModule;
import net.mehvahdjukaar.every_compat.modules.crayfish.RefurbishedFurnitureModule;
import net.mehvahdjukaar.every_compat.modules.decorative_blocks.DecorativeBlocksModule;
import net.mehvahdjukaar.every_compat.modules.exline.BarkCarpetsModule;
import net.mehvahdjukaar.every_compat.modules.farmersdelight.FarmersDelightModule;
import net.mehvahdjukaar.every_compat.modules.friendsandfoes.FriendsAndFoesModule;
import net.mehvahdjukaar.every_compat.modules.furnish.FurnishModule;
import net.mehvahdjukaar.every_compat.modules.hearth_and_home.HearthAndHomeModule;
import net.mehvahdjukaar.every_compat.modules.quark.QuarkModule;
import net.mehvahdjukaar.every_compat.modules.twigs.TwigsModule;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EveryCompat {
    public static final String MOD_ID = "everycomp";
    public static final Logger LOGGER = LogManager.getLogger((String)"Every Compat");
    public static final Map<String, CompatModule> ACTIVE_MODULES = new TreeMap<String, CompatModule>();
    public static final List<CompatMod> COMPAT_MODS = new ArrayList<CompatMod>();
    public static final Set<String> DEPENDENCIES = new HashSet<String>();
    public static final Map<Class<? extends BlockType>, Set<String>> ENTRY_TYPES = new Object2ObjectOpenHashMap();
    public static final Map<Object, CompatModule> ITEMS_TO_MODULES = new Object2ObjectOpenHashMap();
    private static final UnsafeModuleDisabler MODULE_DISABLER = new UnsafeModuleDisabler();
    public static boolean OLD_FD = false;
    public static final Supplier<AllWoodItem> ALL_WOODS = RegHelper.registerItem((class_2960)EveryCompat.res("all_woods"), AllWoodItem::new);
    public static final RegSupplier<class_1761> MOD_TAB = RegHelper.registerCreativeModeTab((class_2960)EveryCompat.res("everycomp"), (boolean)true, builder -> builder.method_47320(() -> ALL_WOODS.get().method_7854()).method_47319("item_search.png").method_47321((class_2561)class_2561.method_43471((String)"itemGroup.everycomp.everycomp")).method_47324());
    private int prevRegSize;

    public static class_2960 res(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void forAllModules(Consumer<CompatModule> action) {
        ACTIVE_MODULES.values().forEach(action);
    }

    protected void commonInit() {
        ECNetworking.init();
        ServerDynamicResourcesHandler.INSTANCE.register();
        RegHelper.addItemsToTabsRegistration(this::registerItemsToTabs);
        PlatHelper.addCommonSetup(this::commonSetup);
        BlockSetAPI.addDynamicBlockRegistration(this::registerWoodStuff, WoodType.class);
        BlockSetAPI.addDynamicBlockRegistration(this::registerLeavesStuff, LeavesType.class);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerItems((Registrator<class_1792>)r), WoodType.class, (class_2378)class_7923.field_41178);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerTiles(r), WoodType.class, (class_2378)class_7923.field_41181);
        BlockSetAPI.addDynamicRegistration((r, c) -> this.registerEntities(r), WoodType.class, (class_2378)class_7923.field_41177);
        this.addOtherCompatMod("compatoplenty", "biomesoplenty", List.of("twigs", "farmersdelight", "quark", "woodworks"));
        this.addOtherCompatMod("compat_makeover", "biomemakeover", List.of("habitat", "farmersdelight", "quark", "decorative_blocks"));
        this.addOtherCompatMod("decorative_compat", "biomesoplenty", List.of("decorative_blocks"));
        this.addOtherCompatMod("storagedrawersunlimited", "biomesoplenty", List.of("storagedrawers"));
        this.addOtherCompatMod("macawsbridgesbop", "biomesoplenty", List.of("mcwbridges"));
        this.addOtherCompatMod("macawbridgesbyg", "byg", List.of("mcwbridges"));
        this.addOtherCompatMod("mcwfencesbop", "biomesoplenty", List.of("mcwfences"));
        this.addOtherCompatMod("mcwfencesbyg", "byg", List.of("mcwfences"));
        this.addOtherCompatMod("macawsroofsbop", "biomesoplenty", List.of("mcwroofs"));
        this.addOtherCompatMod("macawsroofsbyg", "byg", List.of("mcwroofs"));
        this.addOtherCompatMod("abnormals_delight", List.of("autumnity", "upgrade_aquatic", "environmental", "atmospheric", "endergetic", "caves_and_chasms"), List.of("farmersdelight"));
        this.addModule("another_furniture", () -> AnotherFurnitureModule::new);
        this.addModule("barkcarpets", () -> BarkCarpetsModule::new);
        this.addModule("campchair", () -> CampChairModule::new);
        this.addModule("chipped", () -> ChippedModule::new);
        this.addModule("decorative_blocks", () -> DecorativeBlocksModule::new);
        this.addModule("friendsandfoes", () -> FriendsAndFoesModule::new);
        this.addModule("furnish", () -> FurnishModule::new);
        this.addModule("hearth_and_home", () -> HearthAndHomeModule::new);
        this.addModule("quark", () -> QuarkModule::new);
        this.addModule("twigs", () -> TwigsModule::new);
        this.addModule("refurbished_furniture", () -> RefurbishedFurnitureModule::new);
        this.addModule("farmersdelight", () -> FarmersDelightModule::new);
        EveryCompat.forAllModules(m -> LOGGER.info("Loaded {}", (Object)m.toString()));
        MODULE_DISABLER.save();
    }

    public static <T extends BlockType> void addEntryType(Class<T> type, String childId) {
        ENTRY_TYPES.computeIfAbsent(type, t -> new HashSet()).add(childId);
    }

    private void addOtherCompatMod(String modId, String woodFrom, List<String> blocksFrom) {
        this.addOtherCompatMod(modId, List.of(woodFrom), blocksFrom);
    }

    private void addOtherCompatMod(String modId, List<String> woodFrom, List<String> blocksFrom) {
        COMPAT_MODS.add(new CompatMod(modId, woodFrom, blocksFrom));
        DEPENDENCIES.add(modId);
        DEPENDENCIES.addAll(woodFrom);
        DEPENDENCIES.addAll(blocksFrom);
    }

    protected void addModule(String modId, Supplier<Function<String, CompatModule>> moduleFactory) {
        if (PlatHelper.isModLoaded((String)modId) && MODULE_DISABLER.isModuleOn(modId)) {
            if (modId.equals("farmersdelight")) {
                try {
                    Class.forName("vectorwing.farmersdelight.FarmersDelight");
                }
                catch (Exception e) {
                    LOGGER.error("Farmers Delight Refabricated is not installed. Disabling Farmers Delight Module");
                    OLD_FD = true;
                    return;
                }
            }
            CompatModule module = moduleFactory.get().apply(modId);
            try {
                EveryCompatAPI.registerModule(module);
            }
            catch (Exception e) {
                if (PlatHelper.isDev()) {
                    throw e;
                }
                LOGGER.error("Failed to register module for mod " + module, (Throwable)e);
            }
            DEPENDENCIES.add(modId);
            DEPENDENCIES.addAll(module.getAlreadySupportedMods());
        }
    }

    public static Collection<CompatMod> getCompatMods() {
        return COMPAT_MODS;
    }

    public void commonSetup() {
        if (PlatHelper.isModLoaded((String)"chipped")) {
            LOGGER.warn("Chipped is installed. The mod on its own adds a ludicrous amount of blocks. With Every Compat this can easily explode. You have been warned");
        }
        int newSize = class_7923.field_41175.method_10204();
        int am = newSize - this.prevRegSize;
        float p = (float)am / (float)newSize * 100.0f;
        LOGGER.info("Registered {} compat blocks making up {}% of total blocks registered", (Object)am, (Object)String.format("%.2f", Float.valueOf(p)));
        if (p > 33.0f) {
            CompatModule bloated = ACTIVE_MODULES.values().stream().max(Comparator.comparing(CompatModule::bloatAmount)).get();
            LOGGER.error("Every Compat registered blocks make up more than one third of your registered blocks, taking up memory and load time.");
            LOGGER.error("You might want to uninstall some mods, biggest offender was {} ({} blocks)", (Object)bloated.getModName().toUpperCase(Locale.ROOT), (Object)bloated.bloatAmount());
        }
        EveryCompat.forAllModules(CompatModule::onModSetup);
    }

    public void registerWoodStuff(Registrator<class_2248> event, Collection<WoodType> woods) {
        ModConfigs.initEarlyButNotSuperEarly();
        this.prevRegSize = class_7923.field_41175.method_10204();
        LOGGER.info("Registering Compat Wood Blocks");
        EveryCompat.forAllModules(m -> m.registerWoodBlocks(event, woods));
    }

    public void registerLeavesStuff(Registrator<class_2248> event, Collection<LeavesType> leaves) {
        LOGGER.info("Registering Compat Leaves Blocks");
        EveryCompat.forAllModules(m -> m.registerLeavesBlocks(event, leaves));
    }

    protected void registerItems(Registrator<class_1792> event) {
        EveryCompat.forAllModules(m -> m.registerItems(event));
    }

    protected void registerTiles(Registrator<class_2591<?>> event) {
        EveryCompat.forAllModules(m -> m.registerTiles(event));
    }

    protected void registerEntities(Registrator<class_1299<?>> event) {
        EveryCompat.forAllModules(m -> m.registerEntities(event));
    }

    private void registerItemsToTabs(RegHelper.ItemToTabEvent event) {
        if (ModConfigs.TAB_ENABLED.get().booleanValue()) {
            class_5321 tab = MOD_TAB.getKey();
            LinkedHashMap typeToEntrySet = new LinkedHashMap();
            for (BlockTypeRegistry r : BlockSetAPI.getRegistries()) {
                for (BlockType type : r.getValues()) {
                    EveryCompat.forAllModules(m -> typeToEntrySet.computeIfAbsent(type, j -> new ArrayList()).addAll(m.getAllItemsOfType(type)));
                }
            }
            for (List e : typeToEntrySet.values()) {
                event.add(tab, (class_1935[])e.toArray(class_1935[]::new));
            }
        } else {
            EveryCompat.forAllModules(m -> m.registerItemsToExistingTabs(event));
        }
    }

    public record CompatMod(String modId, List<String> woodFrom, List<String> blocksFrom) {
        public CompatMod(String modId, String woodFrom, List<String> blocksFrom) {
            this(modId, List.of(woodFrom), blocksFrom);
        }
    }
}

