/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;

public class UnsafeModuleDisabler {
    private final Properties properties;
    private final Path configPath = PlatHelper.getGamePath().resolve("config/everycomp-hazardous.properties");
    private boolean isSafe = true;

    public UnsafeModuleDisabler() {
        this.properties = new Properties();
        this.loadProperties();
    }

    private void loadProperties() {
        try (FileInputStream input = new FileInputStream(this.configPath.toFile());){
            this.properties.load(input);
        }
        catch (IOException e) {
            this.save();
        }
    }

    public void save() {
        try (FileOutputStream output = new FileOutputStream(this.configPath.toFile());){
            this.properties.store(output, "Hard disable entire modules. Use at your own risk and don't ask for support if you use this");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isModuleOn(String modId) {
        try {
            if (this.properties.getProperty(modId) != null) {
                boolean ret = Boolean.parseBoolean(this.properties.getProperty(modId, "true"));
                if (!ret && this.isSafe) {
                    this.isSafe = false;
                    EveryCompat.LOGGER.warn("!!! You are using conditional modules registration. Proceed at your own risk and dont complain if you cant connect to servers !!!");
                }
                return ret;
            }
            this.properties.setProperty(modId, String.valueOf(true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

