/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.configs.ModConfigs;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.class_1079;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleEntrySet<T extends BlockType, B extends class_2248, I extends class_1792>
implements EntrySet<T> {
    public final Map<T, B> blocks = new HashMap<T, B>();
    public final Map<T, I> items = new HashMap<T, I>();
    protected final Class<T> type;
    protected final Pattern nameScheme;
    protected final Supplier<T> baseType;
    public final String typeName;
    public final String postfix;
    @Nullable
    public final String prefix;
    protected final boolean mergePalette;
    protected final Supplier<class_5321<class_1761>> tab;
    protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap();
    protected final Set<Supplier<class_2960>> recipeLocations = new HashSet<Supplier<class_2960>>();
    protected final Set<Pair<class_2960, @Nullable class_2960>> textures = new HashSet<Pair<class_2960, class_2960>>();
    @Nullable
    protected final @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteSupplier;
    @Nullable
    protected final Consumer<BlockTypeResTransformer<T>> extraTransform;
    protected final Predicate<T> condition;

    protected AbstractSimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<class_5321<class_1761>> tab, @Nullable @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergePalette, Predicate<T> condition) {
        this.typeName = (String)(prefix == null ? "" : prefix + (name.isEmpty() ? "" : "_")) + name;
        this.postfix = name;
        this.prefix = prefix;
        this.tab = tab;
        this.baseType = baseType;
        this.type = type;
        this.extraTransform = extraTransform;
        this.paletteSupplier = paletteSupplier;
        this.mergePalette = mergePalette;
        this.nameScheme = this.prefix != null ? (this.postfix.isEmpty() ? Pattern.compile("^" + prefix + "_(.+?)$") : Pattern.compile("^" + prefix + "_(.+?)_" + this.postfix + "$")) : Pattern.compile("^(.+?)_" + this.postfix + "$");
        this.condition = condition;
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    @Nullable
    public class_1792 getItemOf(T type) {
        class_1792 i = (class_1792)this.items.get(type);
        if (ModConfigs.isEntryEnabled(type, (Object)i)) {
            return i;
        }
        return null;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.type;
    }

    public T getBaseType() {
        return (T)((BlockType)this.baseType.get());
    }

    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        BlockType w;
        String wood = this.parseWoodType(oldName);
        if (wood != null && (w = BlockSetAPI.getBlockSet(this.getTypeClass()).get(new class_2960(woodFrom, wood))) != null) {
            return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
        }
        return null;
    }

    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = this.nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void generateTags(CompatModule module, DynamicDataPack pack, class_3300 manager) {
        if (!this.tags.isEmpty()) {
            for (Map.Entry<class_2960, Set<class_5321<?>>> tb : this.tags.entrySet()) {
                SimpleTagBuilder builder = SimpleTagBuilder.of((class_2960)tb.getKey());
                for (Map.Entry<T, ?> entry : this.getDefaultEntries().entrySet()) {
                    if (!ModConfigs.isEntryEnabled((BlockType)entry.getKey(), entry.getValue())) continue;
                    builder.addEntry(entry.getValue());
                }
                for (class_5321 class_53212 : tb.getValue()) {
                    pack.addTag(builder, class_53212);
                }
            }
        }
    }

    public Map<T, ?> getDefaultEntries() {
        return this.blocks;
    }

    @Override
    public void generateRecipes(CompatModule module, DynamicDataPack pack, class_3300 manager) {
        int i = 0;
        for (Supplier<class_2960> r : this.recipeLocations) {
            class_2960 res = r.get();
            try {
                ResourcesUtils.addBlocksRecipes(manager, pack, this.items, res, (BlockType)this.baseType.get(), i++);
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to generate recipes for template at location {} ", (Object)res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateTextures(CompatModule module, DynClientResourcesGenerator handler, class_3300 manager) {
        if (this.textures.isEmpty()) {
            return;
        }
        ArrayList<TextureImage> images = new ArrayList<TextureImage>();
        try (TextureImage oakPlanksTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)((class_2248)this.getBaseType().mainChild())));){
            Palette oakPlanksPalette = Palette.fromImage((TextureImage)oakPlanksTexture);
            HashMap<class_2960, Respriter> respriters = new HashMap<class_2960, Respriter>();
            HashMap<class_2960, TextureImage> partialRespriters = new HashMap<class_2960, TextureImage>();
            Palette globalPalette = Palette.ofColors(new ArrayList());
            for (Pair<class_2960, class_2960> pair : this.textures) {
                class_2960 textureId = (class_2960)pair.getFirst();
                try {
                    TextureImage main;
                    class_2960 maskId = (class_2960)pair.getSecond();
                    if (maskId != null && textureId == null) {
                        main = TextureImage.open((class_3300)manager, (class_2960)maskId);
                        respriters.put(maskId, Respriter.ofPalette((TextureImage)main, List.of(Palette.ofColors(List.of(new RGBColor(1))))));
                        continue;
                    }
                    main = TextureImage.open((class_3300)manager, (class_2960)textureId);
                    images.add(main);
                    if (maskId != null) {
                        if (maskId.equals((Object)Builder.AUTO_MASK_MARKER)) {
                            if (this.mergePalette) {
                                globalPalette.addAll((Collection)oakPlanksPalette);
                                partialRespriters.put(textureId, main);
                                continue;
                            }
                            respriters.put(textureId, Respriter.ofPalette((TextureImage)main, (Palette)oakPlanksPalette));
                            continue;
                        }
                        TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)maskId);
                        if (this.mergePalette) {
                            globalPalette.addAll((Collection)Palette.fromImage((TextureImage)main, (TextureImage)mask, (float)0.0f));
                            partialRespriters.put(textureId, main);
                            continue;
                        }
                        respriters.put(textureId, Respriter.masked((TextureImage)main, (TextureImage)mask));
                        continue;
                    }
                    if (this.mergePalette) {
                        globalPalette.addAll((Collection)Palette.fromImage((TextureImage)main, null, (float)0.0f));
                        partialRespriters.put(textureId, main);
                        continue;
                    }
                    respriters.put(textureId, Respriter.of((TextureImage)main));
                }
                catch (UnsupportedOperationException e) {
                    EveryCompat.LOGGER.error("Could not generate textures for {}: {}", pair, (Object)e);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to read block texture at {}", pair);
                }
            }
            for (Map.Entry entry : partialRespriters.entrySet()) {
                respriters.put((class_2960)entry.getKey(), Respriter.ofPalette((TextureImage)((TextureImage)entry.getValue()), (Palette)globalPalette));
            }
            for (Map.Entry entry : this.getDefaultEntries().entrySet()) {
                Object b = entry.getValue();
                BlockType w = (BlockType)entry.getKey();
                class_2960 blockId = Utils.getID(b);
                List targetPalette = null;
                class_1079 animation = null;
                if (this.paletteSupplier != null) {
                    Pair<List<Palette>, class_1079> pal = this.paletteSupplier.apply(w, manager);
                    animation = (class_1079)pal.getSecond();
                    targetPalette = (List)pal.getFirst();
                } else {
                    class_1935 m = w.mainChild();
                    class_2248 mainWoodTypeBlock = null;
                    if (m instanceof class_2248) {
                        class_2248 bb;
                        mainWoodTypeBlock = bb = (class_2248)m;
                    } else if (m instanceof class_1747) {
                        class_1747 bii = (class_1747)m;
                        mainWoodTypeBlock = bii.method_7711();
                    }
                    if (mainWoodTypeBlock == null) {
                        throw new UnsupportedOperationException("You need to provide a palette supplier for non wood type based blocks");
                    }
                    try (TextureImage plankTexture22 = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)mainWoodTypeBlock));){
                        targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture22);
                        animation = plankTexture22.getMetadata();
                    }
                    catch (Exception plankTexture22) {
                        // empty catch block
                    }
                }
                if (targetPalette == null) {
                    EveryCompat.LOGGER.error("Could not get texture palette for block {} : ", b);
                    continue;
                }
                class_1079 finalAnimation = animation;
                List finalTargetPalette = targetPalette;
                int oldSize = ((Palette)finalTargetPalette.get(0)).size();
                for (Map.Entry re : respriters.entrySet()) {
                    boolean isOnAtlas;
                    if (oldSize != ((Palette)finalTargetPalette.get(0)).size()) {
                        throw new RuntimeException("This should not happen");
                    }
                    String oldPath = ((class_2960)re.getKey()).method_12832();
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)oldPath, (BlockType)w, (class_2960)blockId, (String)((BlockType)this.baseType.get()).getTypeName());
                    Respriter respriter = (Respriter)re.getValue();
                    boolean bl = isOnAtlas = !newId.startsWith("entity/");
                    if (this.type == WoodType.class) {
                        this.addWoodTexture((WoodType)w, handler, manager, newId, () -> respriter.recolorWithAnimation(finalTargetPalette, finalAnimation), isOnAtlas);
                        continue;
                    }
                    handler.addTextureIfNotPresent(manager, newId, () -> respriter.recolorWithAnimation(finalTargetPalette, finalAnimation), isOnAtlas);
                }
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not generate any block texture for entry set {} : ", (Object)(module == null ? "dummy" : module.modRes(this.getName())), (Object)e);
        }
        finally {
            for (TextureImage t : images) {
                t.close();
            }
        }
    }

    public void addWoodTexture(WoodType wood, DynClientResourcesGenerator handler, class_3300 manager, String path, Supplier<TextureImage> textureSupplier, boolean isOnAtlas) {
        handler.addTextureIfNotPresent(manager, path, () -> {
            TextureImage t = (TextureImage)textureSupplier.get();
            this.maybeFlowerAzalea(t, manager, wood);
            return t;
        }, isOnAtlas);
    }

    protected void maybeFlowerAzalea(TextureImage image, class_3300 manager, WoodType woodType) {
        WoodType azalea;
        if (woodType.getId().toString().equals("ecologics:flowering_azalea") && (azalea = WoodTypeRegistry.getValue((class_2960)new class_2960("ecologics:azalea"))) != null) {
            try (TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)EveryCompat.res("block/ecologics_overlay"));
                 TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)azalea.planks));){
                Respriter respriter = Respriter.of((TextureImage)image);
                TextureImage temp = respriter.recolorWithAnimationOf(plankTexture);
                image.applyOverlayOnExisting(new TextureImage[]{temp, mask});
                temp.close();
            }
            catch (Exception e) {
                EveryCompat.LOGGER.warn("failed to apply azalea overlay for wood type {} and image {}", (Object)woodType, (Object)image);
            }
        }
    }

    protected static class Builder<BL extends Builder<BL, T, B, I>, T extends BlockType, B extends class_2248, I extends class_1792> {
        protected final Class<T> type;
        protected final Supplier<T> baseType;
        protected final String name;
        @Nullable
        protected final String prefix;
        protected Supplier<class_5321<class_1761>> tab = () -> class_7706.field_40195;
        @Nullable
        protected @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> palette = null;
        protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap();
        protected final Set<Supplier<class_2960>> recipes = new HashSet<Supplier<class_2960>>();
        protected final Set<Pair<class_2960, @Nullable class_2960>> textures = new HashSet<Pair<class_2960, class_2960>>();
        protected boolean useMergedPalette;
        @Nullable
        protected Consumer<BlockTypeResTransformer<T>> extraModelTransform = null;
        protected Predicate<T> condition = w -> true;
        protected static final class_2960 AUTO_MASK_MARKER = new class_2960("auto_mask");

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType) {
            this.baseType = baseType;
            this.name = name;
            this.prefix = prefix;
            this.type = type;
        }

        public BL addModelTransform(Consumer<BlockTypeResTransformer<T>> transform) {
            this.extraModelTransform = transform;
            return (BL)this;
        }

        public BL requiresChildren(String ... childKeys) {
            this.addCondition(w -> {
                for (String c : childKeys) {
                    if (w.getChild(c) != null) continue;
                    return false;
                }
                return true;
            });
            return (BL)this;
        }

        public BL addCondition(Predicate<T> condition) {
            this.condition = condition;
            return (BL)this;
        }

        public BL setTabKey(Supplier<class_5321<class_1761>> tab) {
            this.tab = tab;
            return (BL)this;
        }

        public BL setTab(Supplier<class_1761> tab) {
            this.tab = Suppliers.memoize(() -> (class_5321)class_7923.field_44687.method_29113((Object)((class_1761)tab.get())).get());
            return (BL)this;
        }

        public BL addTag(class_2960 location, class_5321<?> registry) {
            Set s = this.tags.computeIfAbsent(location, b -> new HashSet());
            s.add(registry);
            return (BL)this;
        }

        public BL addTag(class_6862<?> tag, class_5321<?> registry) {
            this.addTag(tag.comp_327(), registry);
            return (BL)this;
        }

        public BL addRecipe(class_2960 resourceLocation) {
            this.recipes.add(() -> resourceLocation);
            return (BL)this;
        }

        public BL addTexture(class_2960 resourceLocation) {
            this.textures.add((Pair<class_2960, class_2960>)Pair.of((Object)resourceLocation, null));
            return (BL)this;
        }

        public BL addTextureM(class_2960 textureLocation, class_2960 maskLocation) {
            this.textures.add((Pair<class_2960, class_2960>)Pair.of((Object)textureLocation, (Object)maskLocation));
            return (BL)this;
        }

        public BL addTextureAutoM(class_2960 textureLocation) {
            this.textures.add((Pair<class_2960, class_2960>)Pair.of((Object)textureLocation, (Object)AUTO_MASK_MARKER));
            return (BL)this;
        }

        public BL copyTexture(class_2960 textureLocation) {
            this.textures.add((Pair<class_2960, class_2960>)Pair.of(null, (Object)textureLocation));
            return (BL)this;
        }

        public BL useMergedPalette() {
            this.useMergedPalette = true;
            return (BL)this;
        }

        public BL setPalette(BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteProvider) {
            this.palette = paletteProvider;
            return (BL)this;
        }

        public BL createPaletteFromOak(Consumer<Palette> paletteTransform) {
            return this.createPaletteFromChild(paletteTransform, "planks");
        }

        public BL createPaletteFromChild(Consumer<Palette> paletteTransform, String childKey) {
            return this.setPalette((w, m) -> {
                Object c = w.getChild(childKey);
                if (c instanceof class_2248) {
                    Pair pair;
                    block18: {
                        class_2248 b = (class_2248)c;
                        TextureImage plankTexture = TextureImage.open((class_3300)m, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)m, (class_2248)b));
                        try {
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                            targetPalette.forEach(paletteTransform);
                            pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMetadata());
                            if (plankTexture == null) break block18;
                        }
                        catch (Throwable targetPalette) {
                            try {
                                if (plankTexture != null) {
                                    try {
                                        plankTexture.close();
                                    }
                                    catch (Throwable throwable) {
                                        targetPalette.addSuppressed(throwable);
                                    }
                                }
                                throw targetPalette;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(String.format("Failed to generate palette for %s : %s", w, e));
                            }
                        }
                        plankTexture.close();
                    }
                    return pair;
                }
                if (c instanceof class_1792) {
                    Pair pair;
                    block19: {
                        class_1792 i = (class_1792)c;
                        TextureImage plankTexture = TextureImage.open((class_3300)m, (class_2960)RPUtils.findFirstItemTextureLocation((class_3300)m, (class_1792)i));
                        try {
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                            targetPalette.forEach(paletteTransform);
                            pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMetadata());
                            if (plankTexture == null) break block19;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (plankTexture != null) {
                                    try {
                                        plankTexture.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(String.format("Failed to generate palette for %s : %s", w, e));
                            }
                        }
                        plankTexture.close();
                    }
                    return pair;
                }
                throw new RuntimeException("No child with key " + childKey + "found");
            });
        }
    }
}

