/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.minecraft.class_1079;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemOnlyEntrySet<T extends BlockType, I extends class_1792>
extends AbstractSimpleEntrySet<T, class_2248, I> {
    protected final Supplier<@Nullable I> baseItem;
    protected final Function<T, @Nullable I> itemFactory;

    public ItemOnlyEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, I> itemFactory, Supplier<@Nullable I> baseItem, Supplier<T> baseType, Supplier<class_5321<class_1761>> tab, @Nullable @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, Predicate<T> condition) {
        super(type, name, prefix, baseType, tab, paletteSupplier, extraTransform, mergedPalette, condition);
        this.itemFactory = itemFactory;
        this.baseItem = baseItem;
    }

    public I getBaseItem() {
        return (I)((class_1792)this.baseItem.get());
    }

    @Override
    public void addTranslations(CompatModule module, AfterLanguageLoadEvent lang) {
        this.items.forEach((w, v) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)("item_type." + module.getModId() + "." + this.typeName), (BlockType)w, (class_1792)v));
    }

    @Override
    public void registerBlocks(CompatModule module, Registrator<class_2248> registry, Collection<T> woodTypes) {
    }

    @NotNull
    public String getItemName(T w) {
        String name;
        if (this.prefix != null) {
            name = this.prefix + "_" + w.getTypeName();
            if (!this.postfix.isEmpty()) {
                name = name + "_" + this.postfix;
            }
        } else {
            name = w.getTypeName() + "_" + this.postfix;
        }
        return name;
    }

    @Override
    public void registerItems(CompatModule module, Registrator<class_1792> registry) {
        BlockTypeRegistry typeRegistry = BlockSetAPI.getTypeRegistry((Class)this.type);
        for (BlockType w : typeRegistry.getValues()) {
            class_1792 item;
            String name = this.getItemName(w);
            String fullName = module.shortenedId() + "/" + w.getNamespace() + "/" + name;
            if (w.isVanilla() || module.isEntryAlreadyRegistered(name, w, (class_2378<?>)class_7923.field_41178) || !this.condition.test(w) || (item = (class_1792)this.itemFactory.apply(w)) == null) continue;
            this.items.put(w, item);
            registry.register(EveryCompat.res(fullName), (Object)item);
            w.addChild(this.getChildKey(module), (Object)item);
            EveryCompat.ITEMS_TO_MODULES.put(item, module);
        }
    }

    @Override
    public void registerTiles(CompatModule module, Registrator<class_2591<?>> registry) {
        I base = this.getBaseItem();
        if (base == null || base == class_1802.field_8162) {
            throw new UnsupportedOperationException("Base Item cant be null (" + this.typeName + " for " + module.modId + " module)");
        }
        String childKey = this.getChildKey(module);
        ((BlockType)this.baseType.get()).addChild(childKey, base);
        HashSet<String> alreadySupportedMods = new HashSet<String>(module.getAlreadySupportedMods());
        alreadySupportedMods.add(module.modId);
        String[] possibleNamespaces = (String[])alreadySupportedMods.toArray(String[]::new);
        for (BlockType w : BlockSetAPI.getTypeRegistry(this.getTypeClass()).getValues()) {
            if (this.items.containsKey(w)) continue;
            String path = this.getItemName(w);
            class_1792 item = ItemOnlyEntrySet.getOptionalItem(path, w.getNamespace());
            if (item == null) {
                item = ItemOnlyEntrySet.getOptionalItem(path, possibleNamespaces);
            }
            if (item == null) continue;
            w.addChild(childKey, (Object)item);
        }
    }

    @Nullable
    private static class_1792 getOptionalItem(String path, String ... namespaces) {
        for (String n : namespaces) {
            class_2960 id = new class_2960(n, path);
            Optional i = class_7923.field_41178.method_17966(id);
            if (!i.isPresent()) continue;
            return (class_1792)i.get();
        }
        return null;
    }

    @Override
    public void setRenderLayer() {
    }

    @Override
    public void generateLootTables(CompatModule module, DynamicDataPack pack, class_3300 manager) {
    }

    @Override
    public void generateModels(CompatModule module, DynClientResourcesGenerator handler, class_3300 manager) {
        ResourcesUtils.addItemModels(module.getModId(), manager, handler, this.items, (BlockType)this.baseType.get(), this.extraTransform);
    }

    @Override
    public void registerEntityRenderers(CompatModule simpleModule, ClientHelper.BlockEntityRendererEvent event) {
    }

    @Override
    public Map<T, ?> getDefaultEntries() {
        return this.items;
    }

    public static <T extends BlockType, I extends class_1792> Builder<T, I> builder(Class<T> type, String name, Supplier<I> baseItem, Supplier<T> baseType, Function<T, I> itemSupplier) {
        return new Builder<T, I>(type, name, null, baseType, baseItem, itemSupplier);
    }

    public static <T extends BlockType, I extends class_1792> Builder<T, I> builder(Class<T> type, String name, String prefix, Supplier<I> baseItem, Supplier<T> baseType, Function<T, I> itemSupplier) {
        return new Builder<T, I>(type, name, prefix, baseType, baseItem, itemSupplier);
    }

    public static class Builder<T extends BlockType, I extends class_1792>
    extends AbstractSimpleEntrySet.Builder<Builder<T, I>, T, class_2248, I> {
        protected final Supplier<@Nullable I> baseItem;
        protected final Function<T, I> itemFactory;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<I> baseItem, Function<T, I> itemFactory) {
            super(type, name, prefix, baseType);
            this.baseItem = baseItem;
            this.itemFactory = itemFactory;
        }

        public ItemOnlyEntrySet<T, I> build() {
            ItemOnlyEntrySet<T, I> e = new ItemOnlyEntrySet<T, I>(this.type, this.name, this.prefix, this.itemFactory, this.baseItem, this.baseType, this.tab, this.palette, this.extraModelTransform, this.useMergedPalette, this.condition);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }
    }
}

