/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.AbstractSimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.item.BlockTypeBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1079;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5614;
import net.minecraft.class_7923;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleEntrySet<T extends BlockType, B extends class_2248>
extends AbstractSimpleEntrySet<T, B, class_1792> {
    protected final Supplier<@Nullable B> baseBlock;
    protected final Function<T, @Nullable B> blockFactory;
    @Nullable
    protected final @Nullable TriFunction<T, B, // Could not load outer class - annotation placement on inner may be incorrect
    class_1792.class_1793, @Nullable class_1792> itemFactory;
    @Nullable
    protected final ITileHolder<?> tileHolder;
    protected final LootTableMode lootMode;
    @Nullable
    protected final Supplier<Supplier<class_1921>> renderType;
    protected static final boolean YEET_JSONS = true;
    protected static final Set<class_2248> SIMPLE_DROPS = new HashSet<class_2248>();

    public SimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, B> blockSupplier, Supplier<@Nullable B> baseBlock, Supplier<T> baseType, Supplier<class_5321<class_1761>> tab, LootTableMode lootMode, @Nullable TriFunction<T, B, class_1792.class_1793, class_1792> itemFactory, @Nullable ITileHolder<?> tileFactory, @Nullable Supplier<Supplier<class_1921>> renderType, @Nullable @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform, boolean mergedPalette, Predicate<T> condition) {
        super(type, name, prefix, baseType, tab, paletteSupplier, extraTransform, mergedPalette, condition);
        this.blockFactory = blockSupplier;
        this.tileHolder = tileFactory;
        this.lootMode = lootMode;
        this.baseBlock = baseBlock;
        this.itemFactory = itemFactory;
        this.renderType = renderType;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public ITileHolder<?> getTileHolder() {
        return this.tileHolder;
    }

    public <E extends class_2586> class_2591<E> getTile(Class<E> tileClass) {
        Preconditions.checkNotNull(this.tileHolder, (Object)"Entry set has no tile entity!");
        return this.tileHolder.get();
    }

    public class_2591<?> getTile() {
        Preconditions.checkNotNull(this.tileHolder, (Object)"Entry set has no tile entity!");
        return this.tileHolder.get();
    }

    public B getBaseBlock() {
        return (B)((class_2248)this.baseBlock.get());
    }

    @Override
    public void addTranslations(CompatModule module, AfterLanguageLoadEvent lang) {
        this.blocks.forEach((w, v) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)("block_type." + module.getModId() + "." + this.typeName), (BlockType)w, (class_2248)v));
    }

    @Override
    public void registerWoodBlocks(CompatModule module, Registrator<class_2248> registry, Collection<WoodType> woodTypes) {
        if (WoodType.class == this.getTypeClass()) {
            this.registerBlocks(module, registry, woodTypes);
        }
    }

    @Override
    public void registerLeavesBlocks(CompatModule module, Registrator<class_2248> registry, Collection<LeavesType> leavesTypes) {
        if (LeavesType.class == this.getTypeClass()) {
            this.registerBlocks(module, registry, leavesTypes);
        }
    }

    @Override
    public void registerBlocks(CompatModule module, Registrator<class_2248> registry, Collection<T> woodTypes) {
        B base = this.getBaseBlock();
        if (base == null || base == class_2246.field_10124) {
            throw new UnsupportedOperationException("Base block cant be null (" + this.typeName + " for " + module.modId + " module)");
        }
        String childKey = this.getChildKey(module);
        for (BlockType w : woodTypes) {
            class_2248 block;
            String name = this.getBlockName(w);
            String fullName = module.shortenedId() + "/" + w.getNamespace() + "/" + name;
            if (w.isVanilla() || module.isEntryAlreadyRegistered(name, w, (class_2378<?>)class_7923.field_41175) || !this.condition.test(w) || (block = (class_2248)this.blockFactory.apply(w)) == null) continue;
            this.blocks.put(w, block);
            registry.register(EveryCompat.res(fullName), (Object)block);
            w.addChild(childKey, (Object)block);
            if (this.lootMode != LootTableMode.DROP_SELF) continue;
            SIMPLE_DROPS.add(block);
        }
        try {
            ((BlockType)this.baseType.get()).addChild(childKey, base);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<String> alreadySupportedMods = new HashSet<String>(module.getAlreadySupportedMods());
        alreadySupportedMods.add(module.modId);
        String[] possibleNamespaces = (String[])alreadySupportedMods.toArray(String[]::new);
        for (BlockType w : BlockSetAPI.getTypeRegistry(this.getTypeClass()).getValues()) {
            if (this.items.containsKey(w) || w.getChild(childKey) != null) continue;
            String path = this.getBlockName(w);
            class_2248 block = SimpleEntrySet.getOptionalBlock(path, w.getNamespace());
            if (block == null) {
                block = SimpleEntrySet.getOptionalBlock(path, possibleNamespaces);
            }
            if (block == null || w.getChildKey((Object)block) != null) continue;
            try {
                w.addChild(childKey, (Object)block);
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    private static class_2248 getOptionalBlock(String path, String ... namespaces) {
        for (String n : namespaces) {
            class_2960 id = new class_2960(n, path);
            Optional i = class_7923.field_41175.method_17966(id);
            if (!i.isPresent()) continue;
            return (class_2248)i.get();
        }
        return null;
    }

    @NotNull
    public String getBlockName(T w) {
        String name;
        if (this.prefix != null) {
            name = this.prefix + "_" + w.getTypeName();
            if (!this.postfix.isEmpty()) {
                name = name + "_" + this.postfix;
            }
        } else {
            name = w.getTypeName() + "_" + this.postfix;
        }
        return name;
    }

    @Override
    public void registerItems(CompatModule module, Registrator<class_1792> registry) {
        this.blocks.forEach((w, value) -> {
            Object i = this.itemFactory != null ? (class_1792)this.itemFactory.apply(w, value, (Object)new class_1792.class_1793()) : new BlockTypeBasedBlockItem(value, new class_1792.class_1793(), w);
            if (i != null) {
                this.items.put(w, i);
                registry.register(Utils.getID((class_2248)value), i);
                EveryCompat.ITEMS_TO_MODULES.put(i, module);
            }
        });
    }

    @Override
    public void registerTiles(CompatModule module, Registrator<class_2591<?>> registry) {
        ITileHolder<?> iTileHolder = this.tileHolder;
        if (iTileHolder instanceof NewTileHolder) {
            NewTileHolder nt = (NewTileHolder)iTileHolder;
            class_2591 tile = nt.createInstance((class_2248[])this.blocks.values().toArray(class_2248[]::new));
            registry.register(EveryCompat.res(module.shortenedId() + "_" + this.getName()), tile);
        }
    }

    @Override
    public void setupExistingTiles() {
        ITileHolder<?> iTileHolder = this.tileHolder;
        if (iTileHolder instanceof ExistingTileHolder) {
            ExistingTileHolder et = (ExistingTileHolder)iTileHolder;
            SimpleModule.appendTileEntityBlocks(et.get(), this.blocks.values());
        }
    }

    @Override
    public void setRenderLayer() {
        if (this.renderType != null) {
            this.blocks.values().forEach(t -> ClientHelper.registerRenderType((class_2248)t, (class_1921)this.renderType.get().get()));
        }
    }

    @Override
    public void generateLootTables(CompatModule module, DynamicDataPack pack, class_3300 manager) {
        if (this.lootMode == LootTableMode.COPY_FROM_PARENT) {
            class_2960 reg = Utils.getID(this.getBaseBlock());
            ResourcesUtils.addBlockResources(module.getModId(), manager, (DynamicResourcePack)pack, this.blocks, ((BlockType)this.baseType.get()).getTypeName(), ResType.BLOCK_LOOT_TABLES.getPath(reg));
        } else if (this.lootMode == LootTableMode.DROP_SELF) {
            // empty if block
        }
    }

    @Override
    public void generateModels(CompatModule module, DynClientResourcesGenerator handler, class_3300 manager) {
        ResourcesUtils.addStandardResources(module.getModId(), manager, handler, this.blocks, (BlockType)this.baseType.get(), this.extraTransform);
    }

    public static <T extends BlockType, B extends class_2248> Builder<T, B> builder(Class<T> type, String name, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, null, baseType, baseBlock, blockSupplier);
    }

    public static <T extends BlockType, B extends class_2248> Builder<T, B> builder(Class<T> type, String name, String prefix, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, prefix, baseType, baseBlock, blockSupplier);
    }

    @Environment(value=EnvType.CLIENT)
    public void registerTileRenderer(ClientHelper.BlockEntityRendererEvent event, class_5614 aNew) {
        ITileHolder<?> tile = this.getTileHolder();
        if (tile != null) {
            tile.registerRenderer(event, aNew);
        }
    }

    @Override
    public void registerEntityRenderers(CompatModule simpleModule, ClientHelper.BlockEntityRendererEvent event) {
        if (this.tileHolder != null) {
            // empty if block
        }
    }

    public static boolean isSimpleDrop(class_2248 block) {
        return SIMPLE_DROPS.contains(block);
    }

    private static /* synthetic */ void lambda$generateLootTables$5(DynamicDataPack pack, BlockType wood, class_2248 value) {
        pack.addSimpleBlockLootTable(value);
    }

    public static interface ITileHolder<H extends class_2586> {
        public class_2591<H> get();

        @Environment(value=EnvType.CLIENT)
        default public void registerRenderer(ClientHelper.BlockEntityRendererEvent event, class_5614 renderer) {
            event.register(this.get(), renderer);
        }
    }

    public static enum LootTableMode {
        DROP_SELF,
        COPY_FROM_PARENT,
        NO_LOOT;

    }

    public static class NewTileHolder<H extends class_2586>
    implements ITileHolder<H> {
        protected final BiFunction<class_2338, class_2680, H> tileFactory;
        protected Supplier<class_5614<H>> renderer = null;
        protected class_2591<H> tile = null;

        public NewTileHolder(BiFunction<class_2338, class_2680, H> tileFactory) {
            this.tileFactory = tileFactory;
        }

        @Override
        public class_2591<H> get() {
            return this.tile;
        }

        public class_2591<? extends H> createInstance(class_2248 ... blocks) {
            if (this.tile != null) {
                throw new UnsupportedOperationException("tile has already been created");
            }
            this.tile = PlatHelper.newBlockEntityType(this.tileFactory::apply, (class_2248[])blocks);
            return this.tile;
        }
    }

    public record ExistingTileHolder<H extends class_2586>(Supplier<class_2591<H>> supplier) implements ITileHolder<H>
    {
        @Override
        public class_2591<H> get() {
            return this.supplier.get();
        }
    }

    public static class Builder<T extends BlockType, B extends class_2248>
    extends AbstractSimpleEntrySet.Builder<Builder<T, B>, T, B, class_1792> {
        protected final Supplier<@Nullable B> baseBlock;
        protected LootTableMode lootMode = LootTableMode.DROP_SELF;
        protected final Function<T, B> blockFactory;
        @Nullable
        protected TriFunction<T, B, class_1792.class_1793, class_1792> itemFactory;
        @Nullable
        protected ITileHolder<?> tileHolder;
        @Nullable
        protected Supplier<Supplier<class_1921>> renderType = null;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> blockFactory) {
            super(type, name, prefix, baseType);
            this.baseBlock = baseBlock;
            this.blockFactory = blockFactory;
        }

        public SimpleEntrySet<T, B> build() {
            SimpleEntrySet<T, B> e = new SimpleEntrySet<T, B>(this.type, this.name, this.prefix, this.blockFactory, this.baseBlock, this.baseType, this.tab, this.lootMode, this.itemFactory, this.tileHolder, this.renderType, this.palette, this.extraModelTransform, this.useMergedPalette, this.condition);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }

        public <H extends class_2586> Builder<T, B> addTile(Supplier<class_2591<H>> tile) {
            this.tileHolder = new ExistingTileHolder(tile);
            return this;
        }

        public <H extends class_2586> Builder<T, B> addTile(BiFunction<class_2338, class_2680, H> tileFactory) {
            this.tileHolder = new NewTileHolder(tileFactory);
            return this;
        }

        public Builder<T, B> addCustomItem(TriFunction<T, B, class_1792.class_1793, class_1792> itemFactory) {
            this.itemFactory = itemFactory;
            return this;
        }

        public Builder<T, B> noItem() {
            this.itemFactory = (a, b, c) -> null;
            return this;
        }

        public Builder<T, B> copyParentDrop() {
            this.lootMode = LootTableMode.COPY_FROM_PARENT;
            return this;
        }

        public Builder<T, B> dropSelf() {
            this.lootMode = LootTableMode.DROP_SELF;
            return this;
        }

        public Builder<T, B> noDrops() {
            this.lootMode = LootTableMode.NO_LOOT;
            return this;
        }

        public Builder<T, B> setRenderType(Supplier<Supplier<class_1921>> renderType) {
            this.renderType = renderType;
            return this;
        }

        public Builder<T, B> defaultRecipe() {
            this.recipes.add(() -> Utils.getID((class_2248)((class_2248)this.baseBlock.get())));
            return this;
        }
    }
}

