/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.configs;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.class_1747;
import net.minecraft.class_1935;
import org.jetbrains.annotations.Nullable;

public class ModConfigs {
    private static final Map<Class<? extends BlockType>, Map<String, Supplier<Boolean>>> BLOCK_TYPE_CONFIGS = new HashMap<Class<? extends BlockType>, Map<String, Supplier<Boolean>>>();
    private static final Map<Class<? extends BlockType>, Map<String, Supplier<Boolean>>> CHILD_CONFIGS = new HashMap<Class<? extends BlockType>, Map<String, Supplier<Boolean>>>();
    public static ConfigSpec SPEC;
    public static Supplier<Boolean> TAB_ENABLED;
    public static Supplier<Boolean> DEPEND_ON_PACKS;
    public static Supplier<Boolean> CHECK_PACKET;
    public static Supplier<Boolean> DEBUG_RESOURCES;
    public static Supplier<Boolean> DEBUG_PACKET;
    public static Supplier<Boolean> BLOCK_TYPE_TOOLTIP;
    public static Supplier<Boolean> MOD_TOOPTIP;
    public static Supplier<Boolean> TOOLTIPS_ADVANCED;

    public static void initEarlyButNotSuperEarly() {
        Map map;
        Supplier config;
        String key;
        ConfigBuilder builder = ConfigBuilder.create((String)"everycomp", (ConfigType)ConfigType.COMMON);
        builder.push("general");
        TAB_ENABLED = builder.comment("Puts all the added items into a new Every Compat tab instead of their own mod tabs. Be warned that if disabled it could cause some issue with some mods that have custom tabs").define("creative_tab", true);
        DEPEND_ON_PACKS = builder.comment("Makes dynamic assets that are generated depend on loaded resource packs. Turn off to make them just use vanilla assets").define("assets_depend_on_loaded_packs", true);
        DEBUG_RESOURCES = builder.comment("Creates a debug folder inside your instance directory where all the dynamically generated resources will be saved").define("save_debug_resources", false);
        CHECK_PACKET = builder.comment("Sends a packet to verify all dependencies mod versions are the same on connect. DIsable if it causes issues").define("mod_version_check_packet", true);
        DEBUG_PACKET = builder.comment("Don't touch unless you are told to").define("debug_packet", false);
        builder.push("tooltips");
        MOD_TOOPTIP = builder.comment("Enabled tooltips showing which mod an EC item is from").define("mod_origin_enabled", true);
        BLOCK_TYPE_TOOLTIP = builder.comment("Enabled tooltips showing which block type an EC item is made from").define("block_type_enabled", true);
        TOOLTIPS_ADVANCED = builder.comment("Only show on advanced settings").define("show_on_advanced_tooltips", false);
        builder.pop();
        builder.comment("Disables certain types").push("types");
        for (BlockTypeRegistry reg : BlockSetAPI.getRegistries()) {
            builder.push(reg.typeName().replace(" ", "_"));
            for (BlockType w : reg.getValues()) {
                if (w.isVanilla()) continue;
                key = w.toString().replace(":", ".");
                config = builder.define(key, true);
                map = BLOCK_TYPE_CONFIGS.computeIfAbsent(reg.getType(), s -> new HashMap());
                map.put(w.toString(), config);
            }
            builder.pop();
        }
        builder.pop();
        builder.comment("Disables specific entries").push("entries");
        for (BlockTypeRegistry reg : BlockSetAPI.getRegistries()) {
            if (reg.getType() != WoodType.class && reg.getType() != LeavesType.class) continue;
            builder.push(reg.typeName().replace(" ", "_"));
            for (String c : EveryCompat.ENTRY_TYPES.getOrDefault(reg.getType(), Set.of())) {
                key = c.replace(":", ".");
                config = builder.define(key, true);
                map = CHILD_CONFIGS.computeIfAbsent(reg.getType(), s -> new HashMap());
                map.put(c, config);
            }
            builder.pop();
        }
        builder.pop();
        SPEC = builder.buildAndRegister();
        SPEC.loadFromFile();
    }

    public static <T extends BlockType> boolean isEntryEnabled(T w, Object o) {
        if (o instanceof class_1747) {
            class_1747 bi = (class_1747)o;
            o = bi.method_7711();
        }
        return ModConfigs.isTypeEnabled(w, w.getChildKey(o));
    }

    public static <T extends BlockType> boolean isEntryEnabled(Class<T> typeClass, Object o) {
        if (o instanceof class_1747) {
            class_1747 bi = (class_1747)o;
            o = bi.method_7711();
        }
        BlockType w = BlockSetAPI.getBlockTypeOf((class_1935)((class_1935)o), typeClass);
        return ModConfigs.isTypeEnabled(w, w.getChildKey(o));
    }

    public static <T extends BlockType> boolean isTypeEnabled(T w) {
        return ModConfigs.isTypeEnabled(w, null);
    }

    public static <T extends BlockType> boolean isTypeEnabled(T w, @Nullable String childType) {
        try {
            if (childType != null && !CHILD_CONFIGS.get(w.getClass()).getOrDefault(childType, () -> true).get().booleanValue()) {
                return false;
            }
            return BLOCK_TYPE_CONFIGS.get(w.getClass()).get(w.getId().toString()).get();
        }
        catch (Exception exception) {
            return true;
        }
    }

    static {
        TAB_ENABLED = () -> true;
        DEPEND_ON_PACKS = () -> true;
        CHECK_PACKET = () -> true;
        DEBUG_RESOURCES = () -> false;
        DEBUG_PACKET = () -> false;
        BLOCK_TYPE_TOOLTIP = () -> true;
        MOD_TOOPTIP = () -> true;
        TOOLTIPS_ADVANCED = () -> true;
    }
}

