/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpacks.main;

import java.util.List;
import java.util.stream.Collectors;
import net.fxnt.fxntstorage.backpacks.main.BackPackBlock;
import net.fxnt.fxntstorage.backpacks.main.BackPackItem;
import net.fxnt.fxntstorage.backpacks.upgrades.UpgradeItem;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class BackPackContainer
extends class_1277
implements class_1263,
class_1737 {
    public class_2371<class_1799> items = class_2371.method_10213((int)(BackPackBlock.getSlotCount() + 1), (Object)class_1799.field_8037);
    public class_2371<String> upgrades = class_2371.method_10211();
    private int size = BackPackBlock.getSlotCount();
    @Nullable
    private List<class_1265> listeners;
    private class_1799 backPackItemStack = null;
    public int maxStackSize;
    public class_2248 block;

    public BackPackContainer(class_1799 itemStack) {
        super(new class_1799[0]);
        BackPackItem backPackItem;
        class_2248 class_22482;
        if (itemStack == null) {
            return;
        }
        this.backPackItemStack = itemStack;
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof BackPackItem && (class_22482 = (this.block = (backPackItem = (BackPackItem)class_17922).method_7711())) instanceof BackPackBlock) {
            BackPackBlock backPackBlock = (BackPackBlock)class_22482;
            this.maxStackSize = backPackBlock.getMaxStackSize();
        }
        this.loadItemsFromStack(itemStack);
        this.size = this.items.size();
    }

    public class_2561 getDisplayName() {
        return this.backPackItemStack.method_7964();
    }

    public int method_5444() {
        return this.maxStackSize;
    }

    public class_2371<String> getUpgrades() {
        return this.upgrades;
    }

    public void loadItemsFromStack(class_1799 itemStack) {
        class_2487 tag = itemStack.method_7941("BlockEntityTag");
        if (tag != null) {
            int i;
            if (tag.method_10545("Items")) {
                this.items.clear();
                class_2499 listTag = tag.method_10554("Items", 10);
                for (i = 0; i < listTag.size(); ++i) {
                    class_2487 compoundTag = listTag.method_10602(i);
                    int slot = compoundTag.method_10571("Slot") & 0xFF;
                    class_1799 slotStack = class_1799.method_7915((class_2487)compoundTag);
                    if (compoundTag.method_10573("ActualCount", 3)) {
                        slotStack.method_7939(compoundTag.method_10550("ActualCount"));
                    }
                    if (slot >= this.items.size()) continue;
                    this.items.set(slot, (Object)slotStack);
                }
            }
            if (tag.method_10545("Upgrades")) {
                this.upgrades.clear();
                class_2499 upgradesList = tag.method_10554("Upgrades", 8);
                for (i = 0; i < upgradesList.size(); ++i) {
                    this.upgrades.add(i, (Object)upgradesList.method_10608(i));
                }
            }
            if (tag.method_10545("maxStackSize")) {
                this.maxStackSize = tag.method_10550("maxStackSize");
            }
        } else {
            this.saveItemsToStack();
        }
    }

    public void saveItemsToStack() {
        class_2487 tag = new class_2487();
        class_2499 itemsList = new class_2499();
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 tagStack = (class_1799)this.items.get(i);
            if (tagStack.method_7960()) continue;
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10567("Slot", (byte)i);
            tagStack.method_7953(compoundTag);
            compoundTag.method_10569("ActualCount", tagStack.method_7947());
            itemsList.add((Object)compoundTag);
        }
        tag.method_10566("Items", (class_2520)itemsList);
        class_2499 upgradesList = new class_2499();
        for (int i = 0; i < this.upgrades.size(); ++i) {
            upgradesList.method_10531(i, (class_2520)class_2519.method_23256((String)((String)this.upgrades.get(i))));
        }
        tag.method_10566("Upgrades", (class_2520)upgradesList);
        tag.method_10569("maxStackSize", this.maxStackSize);
        this.backPackItemStack.method_7959("BlockEntityTag", (class_2520)tag);
    }

    public void method_5435(class_1657 player) {
    }

    public void method_5432(class_1657 player) {
        this.saveItemsToStack();
    }

    public void refreshUpgrades() {
        this.upgrades.clear();
        int UPGRADE_SLOT_START_INDEX = 132;
        int UPGRADE_SLOT_END_INDEX = UPGRADE_SLOT_START_INDEX + 6;
        for (int i = UPGRADE_SLOT_START_INDEX; i < UPGRADE_SLOT_END_INDEX; ++i) {
            UpgradeItem upgradeItem;
            String upgradeName;
            class_1799 itemStack = this.method_5438(i);
            class_1792 class_17922 = itemStack.method_7909();
            if (!(class_17922 instanceof UpgradeItem) || this.upgrades.contains((Object)(upgradeName = (upgradeItem = (UpgradeItem)class_17922).getUpgradeName()))) continue;
            this.upgrades.add((Object)upgradeName);
        }
    }

    public void method_5431() {
        if (this.listeners != null) {
            for (class_1265 containerListener : this.listeners) {
                containerListener.method_5453((class_1263)this);
            }
        }
        this.refreshUpgrades();
        this.saveItemsToStack();
    }

    public boolean method_5437(int index, class_1799 stack) {
        return super.method_5437(index, stack);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public class_1799 method_5438(int slot) {
        return slot >= 0 && slot < this.items.size() ? (class_1799)this.items.get(slot) : class_1799.field_8037;
    }

    public List<class_1799> method_24514() {
        List<class_1799> list = this.items.stream().filter(stack -> !stack.method_7960()).collect(Collectors.toList());
        this.method_5448();
        return list;
    }

    public class_1799 method_5491(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = stack.method_7972();
        this.moveItemToOccupiedSlotsWithSameType(itemStack);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.moveItemToEmptySlots(itemStack);
        return itemStack.method_7960() ? class_1799.field_8037 : itemStack;
    }

    public class_1799 method_20631(class_1792 item, int amount) {
        class_1799 itemStack = new class_1799((class_1935)item, 0);
        for (int i = this.size - 1; i >= 0; --i) {
            class_1799 itemStack2 = this.method_5438(i);
            if (!itemStack2.method_7909().equals(item)) continue;
            int j = amount - itemStack.method_7947();
            class_1799 itemStack3 = itemStack2.method_7971(j);
            itemStack.method_7933(itemStack3.method_7947());
            if (itemStack.method_7947() == amount) break;
        }
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack = class_1262.method_5430(this.items, (int)slot, (int)amount);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public boolean method_27070(class_1799 stack) {
        boolean bl = false;
        for (class_1799 itemStack : this.items) {
            if (!itemStack.method_7960() && (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack) || itemStack.method_7947() >= itemStack.method_7914())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public class_1799 method_5441(int slot) {
        class_1799 itemStack = (class_1799)this.items.get(slot);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.items.set(slot, (Object)class_1799.field_8037);
        return itemStack;
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.items.clear();
        this.refreshUpgrades();
        this.method_5431();
    }

    public void method_7683(class_1662 contents) {
        for (class_1799 itemStack : this.items) {
            contents.method_7400(itemStack);
        }
    }

    public String toString() {
        return this.items.stream().filter(stack -> !stack.method_7960()).collect(Collectors.toList()).toString();
    }

    private void moveItemToEmptySlots(class_1799 stack) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!itemStack.method_7960()) continue;
            this.method_5447(i, stack.method_51164());
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(class_1799 stack) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
            this.moveItemsBetweenStacks(stack, itemStack);
            if (!stack.method_7960()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(class_1799 stack, class_1799 other) {
        int i = Math.min(this.method_5444(), other.method_7914());
        int j = Math.min(stack.method_7947(), i - other.method_7947());
        if (j > 0) {
            other.method_7933(j);
            stack.method_7934(j);
            this.method_5431();
        }
    }
}

