/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpacks.main;

import net.fxnt.fxntstorage.backpacks.main.BackPackBlock;
import net.fxnt.fxntstorage.backpacks.main.BackPackItem;
import net.fxnt.fxntstorage.backpacks.upgrades.BackPackAsBlockUpgradeHandler;
import net.fxnt.fxntstorage.backpacks.upgrades.UpgradeItem;
import net.fxnt.fxntstorage.containers.util.ImplementedContainer;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackPackEntity
extends class_2586
implements ImplementedContainer,
class_1275 {
    private int slotCount = BackPackBlock.getSlotCount();
    public class_2371<class_1799> items;
    private final class_2338 pos;
    public int containerSlotCount;
    private static final int currentTick = 0;
    private static int lastTick = 0;
    private static final int updateEveryXTicks = 30;
    private boolean doTick = false;
    public class_1263 container;
    public int[] SIDED_SLOTS = new int[this.containerSlotCount];
    public class_2371<String> upgrades = class_2371.method_10211();
    private class_2561 customName;
    private final int size;
    private final class_2248 block;
    public int maxStackSize = 64;
    private boolean isBeingPickedUp = false;
    private boolean initializedBlock = false;

    public BackPackEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlocks.BACK_PACK_ENTITY, pos, blockState);
        this.items = class_2371.method_10213((int)this.slotCount, (Object)class_1799.field_8037);
        this.size = this.items.size();
        this.pos = pos;
        this.containerSlotCount = this.slotCount - 30;
        class_2248 class_22482 = this.block = blockState.method_26204();
        if (class_22482 instanceof BackPackBlock) {
            BackPackBlock backPackBlock = (BackPackBlock)class_22482;
            this.maxStackSize = backPackBlock.getMaxStackSize();
        }
    }

    public void setCustomName(class_2561 hoverName) {
        this.customName = hoverName;
    }

    public class_2561 method_5476() {
        if (this.customName != null) {
            return this.customName;
        }
        class_1937 blockLevel = this.field_11863;
        if (blockLevel != null) {
            return this.block.method_9574((class_1922)this.field_11863, this.pos, this.method_11010()).method_7964();
        }
        return new class_1799((class_1935)ModBlocks.BACK_PACK_ITEM).method_7964();
    }

    public class_2561 method_5477() {
        return this.method_5476();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.method_5476();
    }

    public void setData(int slotCount, int maxStackSize) {
        this.slotCount = slotCount;
        this.maxStackSize = maxStackSize;
    }

    public class_2371<String> getUpgrades() {
        return this.upgrades;
    }

    public void method_11014(class_2487 tag) {
        int i;
        super.method_11014(tag);
        if (tag.method_10545("Items")) {
            this.items.clear();
            class_2499 listTag = tag.method_10554("Items", 10);
            for (i = 0; i < listTag.size(); ++i) {
                class_2487 compoundTag = listTag.method_10602(i);
                int slot = compoundTag.method_10571("Slot") & 0xFF;
                class_1799 slotStack = class_1799.method_7915((class_2487)compoundTag);
                if (compoundTag.method_10573("ActualCount", 3)) {
                    slotStack.method_7939(compoundTag.method_10550("ActualCount"));
                }
                if (slot >= this.items.size()) continue;
                this.items.set(slot, (Object)slotStack);
            }
        }
        if (tag.method_10545("Upgrades")) {
            this.upgrades.clear();
            class_2499 upgradesList = tag.method_10554("Upgrades", 8);
            for (i = 0; i < upgradesList.size(); ++i) {
                this.upgrades.add(i, (Object)upgradesList.method_10608(i));
            }
        }
        if (tag.method_10545("maxStackSize")) {
            this.maxStackSize = tag.method_10550("maxStackSize");
        }
    }

    public void method_11007(class_2487 tag) {
        tag = this.saveEverything(tag);
        super.method_11007(tag);
    }

    public class_2487 saveEverything(class_2487 tag) {
        class_2499 itemsList = new class_2499();
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 tagStack = (class_1799)this.items.get(i);
            if (tagStack.method_7960()) continue;
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10567("Slot", (byte)i);
            tagStack.method_7953(compoundTag);
            compoundTag.method_10569("ActualCount", tagStack.method_7947());
            itemsList.add((Object)compoundTag);
        }
        tag.method_10566("Items", (class_2520)itemsList);
        class_2499 upgradesList = new class_2499();
        for (int i = 0; i < this.upgrades.size(); ++i) {
            upgradesList.method_10531(i, (class_2520)class_2519.method_23256((String)((String)this.upgrades.get(i))));
        }
        tag.method_10566("Upgrades", (class_2520)upgradesList);
        tag.method_10569("maxStackSize", this.maxStackSize);
        return tag;
    }

    public class_1799 saveToItemStack(class_1799 stack) {
        class_2487 tag = stack.method_7911("BlockEntityTag");
        tag = this.saveEverything(tag);
        if (this.customName != null) {
            class_2487 displayTag = stack.method_7911("display");
            displayTag.method_10582("Name", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        return stack;
    }

    public void refreshUpgrades() {
        this.upgrades.clear();
        int UPGRADE_SLOT_START_INDEX = 132;
        int UPGRADE_SLOT_END_INDEX = UPGRADE_SLOT_START_INDEX + 6;
        for (int i = UPGRADE_SLOT_START_INDEX; i < UPGRADE_SLOT_END_INDEX; ++i) {
            UpgradeItem upgradeItem;
            String upgradeName;
            class_1799 itemStack = (class_1799)this.items.get(i);
            class_1792 class_17922 = itemStack.method_7909();
            if (!(class_17922 instanceof UpgradeItem) || this.upgrades.contains((Object)(upgradeName = (upgradeItem = (UpgradeItem)class_17922).getUpgradeName()))) continue;
            this.upgrades.add((Object)upgradeName);
        }
    }

    public void setBeingPickedUp(boolean beingPickedUp) {
        this.isBeingPickedUp = beingPickedUp;
    }

    public boolean isBeingPickedUp() {
        return this.isBeingPickedUp;
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public void initializeSlotsForAllDirections() {
        this.SIDED_SLOTS = new int[this.containerSlotCount];
        for (int i = 0; i < this.containerSlotCount; ++i) {
            this.SIDED_SLOTS[i] = i;
        }
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @Override
    public int @NotNull [] method_5494(class_2350 side) {
        this.initializeSlotsForAllDirections();
        if (this.SIDED_SLOTS.length < 1) {
            return new int[]{0};
        }
        return this.SIDED_SLOTS;
    }

    @Override
    public boolean method_5492(int index, class_1799 itemStack, @Nullable class_2350 direction) {
        this.initializeSlotsForAllDirections();
        if (!BackPackEntity.filterTest(this.field_11863, itemStack)) {
            return false;
        }
        return this.SIDED_SLOTS.length >= 1;
    }

    @Override
    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        this.initializeSlotsForAllDirections();
        return this.SIDED_SLOTS.length >= 1;
    }

    public static boolean filterTest(class_1937 level, class_1799 stack) {
        return !(stack.method_7909() instanceof BackPackItem);
    }

    public <T extends class_2586> void serverTick(class_1937 level, class_2338 blockPos, class_2586 blockEntity) {
        if (level != null && !level.field_9236) {
            if (++lastTick >= 30) {
                lastTick = 0;
                this.doTick = true;
            }
            if (!this.doTick) {
                return;
            }
            if (!this.initializedBlock) {
                level.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
                this.initializedBlock = true;
            }
            if (this.upgrades.contains((Object)"back_pack_magnet_upgrade")) {
                BackPackAsBlockUpgradeHandler upgradeHandler = new BackPackAsBlockUpgradeHandler(this);
                upgradeHandler.applyMagnetUpgrade();
            }
            this.doTick = false;
        }
    }

    public int method_5444() {
        return this.maxStackSize;
    }

    private boolean inUpgradeSlotRange(int slot) {
        return slot >= Util.UPGRADE_SLOT_START_RANGE && slot < Util.UPGRADE_SLOT_END_RANGE;
    }

    @Override
    public void method_5431() {
        this.refreshUpgrades();
        super.method_5431();
    }
}

