/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpacks.main;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Rectangle;
import net.fxnt.fxntstorage.backpacks.main.BackPackBlock;
import net.fxnt.fxntstorage.backpacks.main.BackPackMenu;
import net.fxnt.fxntstorage.backpacks.upgrades.UpgradeItem;
import net.fxnt.fxntstorage.backpacks.util.BackPackNetworkHelper;
import net.fxnt.fxntstorage.init.ModItems;
import net.fxnt.fxntstorage.init.ModTags;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackPackScreen
extends class_465<BackPackMenu> {
    private static class_1263 container;
    private final int containerSlots = BackPackBlock.getContainerSlotCount();
    private final int toolSlots = BackPackBlock.getToolSlotCount();
    private final int upgradeSlots = BackPackBlock.getUpgradeSlotCount();
    private final int totalSlots = BackPackBlock.getSlotCount();
    private final int containerColumns = 12;
    private int containerRows = 5;
    private final int totalRows = (int)Math.ceil((double)this.containerSlots / 12.0);
    private final int toolSlotColumns = 12;
    private final int toolSlotRows = 2;
    private final int upgradeSlotColumns = 1;
    private final int upgradeSlotRows = 6;
    private final int containerSlotsMinX = 29;
    private final int containerSlotsMaxX = 245;
    private final int containerSlotsMinZ = 17;
    private int containerSlotsMaxZ = 29 + 18 * this.containerRows;
    private int containerSlotsHeight = this.containerSlotsMaxZ - 17;
    private final int scrollBarMinX = 249;
    private final int scrollBarMaxX = 263;
    private final int scrollBarMinZ = 17;
    private int scrollBarMaxZ = this.containerSlotsMaxZ;
    private final int upgradeSlotsMinX = 7;
    private final int upgradeSlotsMaxX = 25;
    private final int upgradeSlotsMinZ = 17;
    private final int upgradeSlotsMaxZ = 125;
    private final int toolSlotsMinX = 29;
    private final int toolSlotsMaxX = 245;
    private int toolSlotsMinZ = this.containerSlotsMaxZ + 4;
    private int toolSlotsMaxZ = this.toolSlotsMinZ + 36;
    private final int inventorySlotsMinX = 60;
    private final int inventorySlotsMaxX = 222;
    private int inventorySlotsMinZ = this.toolSlotsMaxZ + 15;
    private int inventorySlotsMaxZ = this.inventorySlotsMinZ + 54;
    private final int hotbarSlotsMinX = 60;
    private final int hotbarSlotsMaxX = 222;
    private int hotbarSlotsMinZ = this.inventorySlotsMaxZ + 4;
    private int hotbarSlotsMaxZ = this.hotbarSlotsMinZ + 18;
    private final int scrollThumbMinX = 270;
    private final int scrollThumbMaxX = 282;
    private final int scrollThumbMinZ = 0;
    private final int scrollThumbMaxZ = 15;
    private int scrollThumbY = 0;
    private int topVisibleRow;
    private int scrollYOffset;
    private final int scrollThumbWidth = 12;
    private final int scrollThumbHeight = 15;
    private boolean isDragging;
    private int inventoryTextOffset = 11;
    private int containerExclusionZoneMinX;
    private int containerExclusionZoneMaxX;
    private int containerExclusionZoneMinZ;
    private int containerExclusionZoneMaxZ;
    private int containerExclusionZoneWidth;
    private int containerExclusionZoneHeight;
    private int inventoryExclusionZoneMinX;
    private int inventoryExclusionZoneMaxX;
    private int inventoryExclusionZoneMinZ;
    private int inventoryExclusionZoneMaxZ;
    private int inventoryExclusionZoneWidth;
    private int inventoryExclusionZoneHeight;
    private final class_2960 guiTexture5 = new class_2960("fxntstorage", "textures/gui/container/back_pack_screen_5.png");
    private final class_2960 guiTexture7 = new class_2960("fxntstorage", "textures/gui/container/back_pack_screen_7.png");
    private final class_2960 guiTexture9 = new class_2960("fxntstorage", "textures/gui/container/back_pack_screen_9.png");
    private final int guiTexture5Height = 240;
    private final int guiTexture5Rows = 5;
    private final int guiTexture7Height = 281;
    private final int guiTexture7Rows = 7;
    private final int guiTexture9Height = 317;
    private final int guiTexture9Rows = 9;
    private class_2960 guiTexture = this.guiTexture5;
    private int textureHeight = 240;
    private final int textureWidth = 282;
    private static boolean ctrlKeyDown;

    @Nullable
    public static BackPackScreen createScreen(BackPackMenu menu, class_1661 playerInventory, class_2561 title) {
        return new BackPackScreen(menu, playerInventory, title);
    }

    public BackPackScreen(BackPackMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        container = menu.getInventory();
        this.field_22789 = class_310.method_1551().method_22683().method_4486();
        this.field_22790 = class_310.method_1551().method_22683().method_4502();
        this.updateGuiTextureSize(this.field_22789, this.field_22790);
    }

    public void method_25410(class_310 minecraft, int winWidth, int winHeight) {
        this.updateGuiTextureSize(winWidth, winHeight);
        super.method_25410(minecraft, winWidth, winHeight);
    }

    private void updateGuiTextureSize(int winWidth, int winHeight) {
        this.field_22789 = winWidth;
        this.field_22790 = winHeight;
        this.field_2792 = 270;
        if (winHeight >= 317) {
            this.guiTexture = this.guiTexture9;
            this.textureHeight = 317;
            this.containerRows = 9;
        } else if (winHeight >= 281) {
            this.guiTexture = this.guiTexture7;
            this.textureHeight = 281;
            this.containerRows = 7;
        } else {
            this.guiTexture = this.guiTexture5;
            this.textureHeight = 240;
            this.containerRows = 5;
        }
        this.field_2779 = this.textureHeight;
        this.scrollBarMaxZ = this.containerSlotsMaxZ = 17 + 18 * this.containerRows;
        this.containerSlotsHeight = this.containerSlotsMaxZ - 29;
        if (this.guiTexture == this.guiTexture5) {
            this.toolSlotsMinZ = this.containerSlotsMaxZ + 2;
            this.toolSlotsMaxZ = this.toolSlotsMinZ + 36;
            this.inventorySlotsMinZ = this.toolSlotsMaxZ + 12;
            this.inventorySlotsMaxZ = this.inventorySlotsMinZ + 54;
            this.hotbarSlotsMinZ = this.inventorySlotsMaxZ + 4;
            this.hotbarSlotsMaxZ = this.hotbarSlotsMinZ + 18;
            this.inventoryTextOffset = 9;
        } else {
            this.toolSlotsMinZ = this.containerSlotsMaxZ + 4;
            this.toolSlotsMaxZ = this.toolSlotsMinZ + 36;
            this.inventorySlotsMinZ = this.toolSlotsMaxZ + 15;
            this.inventorySlotsMaxZ = this.inventorySlotsMinZ + 54;
            this.hotbarSlotsMinZ = this.inventorySlotsMaxZ + 4;
            this.hotbarSlotsMaxZ = this.hotbarSlotsMinZ + 18;
            this.inventoryTextOffset = 11;
        }
        this.field_2776 = (this.field_22789 - this.field_2792) / 2;
        this.field_2800 = (this.field_22790 - this.field_2779) / 2;
        this.containerExclusionZoneMinX = this.field_2776;
        this.containerExclusionZoneMinZ = this.field_2800;
        this.containerExclusionZoneWidth = 270;
        this.containerExclusionZoneHeight = this.toolSlotsMaxZ + 12;
        this.containerExclusionZoneMaxX = this.containerExclusionZoneMinX + this.containerExclusionZoneWidth;
        this.containerExclusionZoneMaxZ = this.containerExclusionZoneMinZ + this.containerExclusionZoneHeight;
        this.inventoryExclusionZoneMinX = this.field_2776 + 60 - 6;
        this.inventoryExclusionZoneMinZ = this.field_2800 + this.inventorySlotsMinZ - 6;
        this.inventoryExclusionZoneWidth = 174;
        this.inventoryExclusionZoneHeight = this.hotbarSlotsMaxZ - this.inventorySlotsMinZ + 12;
        this.inventoryExclusionZoneMaxX = this.inventoryExclusionZoneMinX + this.inventoryExclusionZoneWidth;
        this.inventoryExclusionZoneMaxZ = this.inventoryExclusionZoneMinZ + this.inventoryExclusionZoneHeight;
        this.initializeSlots();
    }

    protected void method_25426() {
        super.method_25426();
        this.isDragging = false;
    }

    private void initializeSlots() {
        int xOffset;
        int x;
        int yOffset;
        int y;
        int index = 0;
        block0: for (y = 0; y < this.totalRows; ++y) {
            yOffset = 17 + y * 18 + 1;
            int scrollSlotYOffset = y >= this.containerRows ? -2000 : yOffset;
            for (int x2 = 0; x2 < 12; ++x2) {
                int xOffset2 = 29 + x2 * 18 + 1;
                class_1735 slot = ((BackPackMenu)this.field_2797).method_7611(index);
                slot.field_7873 = xOffset2;
                slot.field_7872 = scrollSlotYOffset;
                if (++index == this.containerSlots) continue block0;
            }
        }
        block2: for (y = 0; y < 2; ++y) {
            yOffset = this.toolSlotsMinZ + y * 18 + 1;
            for (x = 0; x < 12; ++x) {
                xOffset = 29 + x * 18 + 1;
                class_1735 slot = ((BackPackMenu)this.field_2797).method_7611(index);
                slot.field_7873 = xOffset;
                slot.field_7872 = yOffset;
                if (++index == this.containerSlots + this.toolSlots) continue block2;
            }
        }
        block4: for (y = 0; y < 6; ++y) {
            yOffset = 17 + y * 18 + 1;
            for (x = 0; x < 1; ++x) {
                xOffset = 7 + x * 18 + 1;
                class_1735 slot = ((BackPackMenu)this.field_2797).method_7611(index);
                slot.field_7873 = xOffset;
                slot.field_7872 = yOffset;
                if (++index == this.totalSlots) continue block4;
            }
        }
        index = 0;
        for (y = 0; y < 3; ++y) {
            yOffset = this.inventorySlotsMinZ + y * 18 + 1;
            for (x = 0; x < 9; ++x) {
                xOffset = 60 + x * 18 + 1;
                class_1735 slot = ((BackPackMenu)this.field_2797).getPlayerSlot(index);
                slot.field_7873 = xOffset;
                slot.field_7872 = yOffset;
                ++index;
            }
        }
        index = 0;
        for (int x3 = 0; x3 < 9; ++x3) {
            int xOffset3 = 60 + x3 * 18 + 1;
            class_1735 slot = ((BackPackMenu)this.field_2797).getHotbarSlot(index);
            slot.field_7873 = xOffset3;
            slot.field_7872 = this.hotbarSlotsMinZ + 1;
            ++index;
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_25290(this.guiTexture, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 282, this.textureHeight);
        graphics.method_25290(this.guiTexture, this.field_2776 + 249 + 1, this.getScrollThumbY(), 270.0f, 0.0f, 12, 15, 282, this.textureHeight);
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_22785, 8, 6, 0x404040, false);
        graphics.method_51439(this.field_22793, this.field_29347, 60, this.inventorySlotsMinZ - this.inventoryTextOffset, 0x404040, false);
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        boolean clickedInside = false;
        double containerLeft = this.containerExclusionZoneMinX;
        double containerRight = this.containerExclusionZoneMaxX;
        double containerTop = this.containerExclusionZoneMinZ;
        double containerBottom = this.containerExclusionZoneMaxZ;
        if (mouseX > containerLeft && mouseX < containerRight && mouseY > containerTop && mouseY < containerBottom) {
            clickedInside = true;
        }
        double inventoryLeft = this.inventoryExclusionZoneMinX;
        double inventoryRight = this.inventoryExclusionZoneMaxX;
        double inventoryTop = this.inventoryExclusionZoneMinZ;
        double inventoryBottom = this.inventoryExclusionZoneMaxZ;
        if (mouseX > inventoryLeft && mouseX < inventoryRight && mouseY > inventoryTop && mouseY < inventoryBottom) {
            clickedInside = true;
        }
        if (!clickedInside) {
            return true;
        }
        return super.method_2381(mouseX, mouseY, left, top, button);
    }

    private int getScrollThumbY() {
        return this.field_2800 + 17 + 1 + this.scrollThumbY;
    }

    private void updateThumbPosition(double adjustedMouseY) {
        this.scrollThumbY = (int)Math.min(Math.max(adjustedMouseY, 0.0), (double)(this.containerSlotsHeight - 15 - 2));
        int row = (int)Math.round((double)this.scrollThumbY / (double)(this.containerSlotsHeight - 15 - 2) * (double)(this.totalRows - this.containerRows));
        this.setTopRow(this.topVisibleRow, row);
    }

    private void snapThumbToGradation() {
        this.scrollThumbY = (int)((double)this.topVisibleRow / (double)(this.totalRows - this.containerRows) * (double)(this.containerRows * 18 - 2 - 15));
    }

    private void setTopRow(int oldTopRow, int newTopRow) {
        if (oldTopRow == newTopRow) {
            return;
        }
        this.topVisibleRow = newTopRow;
        boolean atBottom = newTopRow + this.containerRows > this.totalRows;
        int rowsToMove = newTopRow - oldTopRow;
        int yOffsetBase = 18;
        int numSlotsToUpdate = 12 * this.containerRows;
        int oldStartIndex = oldTopRow * 12;
        int newStartIndex = newTopRow * 12;
        for (int index = oldStartIndex; index < oldStartIndex + numSlotsToUpdate; ++index) {
            ((class_1735)((BackPackMenu)this.field_2797).field_7761.get((int)index)).field_7872 = -2000;
        }
        int newRangeEnd = newStartIndex + numSlotsToUpdate;
        if (atBottom) {
            newRangeEnd = Math.min(newRangeEnd, this.containerSlots);
        }
        for (int index = newStartIndex; index < newRangeEnd; ++index) {
            int yOffset;
            int row = index / 12 - newTopRow;
            ((class_1735)((BackPackMenu)this.field_2797).field_7761.get((int)index)).field_7872 = yOffset = yOffsetBase + row * 18;
        }
    }

    private void setTopRowAndMoveThumb(int oldTopRow, int newTopRow) {
        this.setTopRow(oldTopRow, newTopRow);
        this.snapThumbToGradation();
    }

    private boolean isMouseOverScrollArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_2776 + 29) && mouseX <= (double)(this.field_2776 + 263) && mouseY >= (double)(this.field_2800 + 17) && mouseY <= (double)(this.field_2800 + this.scrollBarMaxZ);
    }

    private boolean isMouseOverScrollBar(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_2776 + 249) && mouseX <= (double)(this.field_2776 + 263) && mouseY >= (double)(this.field_2800 + 17) && mouseY <= (double)(this.field_2800 + this.scrollBarMaxZ);
    }

    private boolean isMouseOverScrollThumb(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_2776 + 249) && mouseX <= (double)(this.field_2776 + 263) && mouseY >= (double)this.getScrollThumbY() && mouseY <= (double)(this.getScrollThumbY() + 15);
    }

    public final boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            ctrlKeyDown = true;
        }
        if (this.handleKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            ctrlKeyDown = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        super.method_25419();
    }

    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 264 || keyCode == 267) {
            if (this.topVisibleRow != this.totalRows - this.containerRows) {
                if (BackPackScreen.method_25442()) {
                    this.setTopRowAndMoveThumb(this.topVisibleRow, Math.min(this.topVisibleRow + this.containerRows, this.totalRows - this.containerRows));
                } else {
                    this.setTopRowAndMoveThumb(this.topVisibleRow, this.topVisibleRow + 1);
                }
            }
            return true;
        }
        if (keyCode == 265 || keyCode == 266) {
            if (this.topVisibleRow != 0) {
                if (BackPackScreen.method_25442()) {
                    this.setTopRowAndMoveThumb(this.topVisibleRow, Math.max(this.topVisibleRow - this.containerRows, 0));
                } else {
                    this.setTopRowAndMoveThumb(this.topVisibleRow, this.topVisibleRow - 1);
                }
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isMouseOverScrollThumb(mouseX, mouseY) && button == 0) {
            this.scrollYOffset = (int)mouseY - this.scrollThumbY;
            this.isDragging = true;
        } else if (this.isMouseOverScrollBar(mouseX, mouseY) && button == 0) {
            this.updateThumbPosition(mouseY - 17.0 - 1.0 - (double)this.field_2800);
            this.snapThumbToGradation();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging) {
            this.updateThumbPosition(mouseY - (double)this.scrollYOffset);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isDragging) {
            this.isDragging = false;
            this.snapThumbToGradation();
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaY) {
        if (super.method_25401(mouseX, mouseY, deltaY)) {
            return true;
        }
        if (this.isMouseOverScrollArea(mouseX, mouseY)) {
            int newTop = deltaY < 0.0 ? Math.min(this.topVisibleRow + (BackPackScreen.method_25442() ? this.containerRows : 1), this.totalRows - this.containerRows) : Math.max(this.topVisibleRow - (BackPackScreen.method_25442() ? this.containerRows : 1), 0);
            this.setTopRowAndMoveThumb(this.topVisibleRow, newTop);
            return true;
        }
        return false;
    }

    protected void method_2383(class_1735 slot, int slotId, int mouseButton, class_1713 type) {
        class_1792 class_17922;
        if (slotId >= Util.UPGRADE_SLOT_START_RANGE && slotId < Util.UPGRADE_SLOT_END_RANGE && slot.method_7677().method_31573(ModTags.BACK_PACK_UPGRADE) && (class_17922 = slot.method_7677().method_7909()) instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)class_17922;
            if (ctrlKeyDown) {
                itemName = upgradeItem.getUpgradeName();
                String baseItemName = itemName.replace("back_pack_", "").replace("_upgrade", "").replace("_deactivated", "");
                class_1799 itemStack = ((class_1735)((BackPackMenu)this.field_2797).field_7761.get(slotId)).method_7677();
                if (!itemStack.method_7960()) {
                    if (itemName.contains("_deactivated")) {
                        itemStack = switch (baseItemName) {
                            case "magnet" -> new class_1799((class_1935)ModItems.BACK_PACK_MAGNET_UPGRADE);
                            case "pickblock" -> new class_1799((class_1935)ModItems.BACK_PACK_PICKBLOCK_UPGRADE);
                            case "itempickup" -> new class_1799((class_1935)ModItems.BACK_PACK_ITEMPICKUP_UPGRADE);
                            case "flight" -> new class_1799((class_1935)ModItems.BACK_PACK_FLIGHT_UPGRADE);
                            case "refill" -> new class_1799((class_1935)ModItems.BACK_PACK_REFILL_UPGRADE);
                            case "feeder" -> new class_1799((class_1935)ModItems.BACK_PACK_FEEDER_UPGRADE);
                            case "toolswap" -> new class_1799((class_1935)ModItems.BACK_PACK_TOOLSWAP_UPGRADE);
                            case "falldamage" -> new class_1799((class_1935)ModItems.BACK_PACK_FALLDAMAGE_UPGRADE);
                            default -> class_1799.field_8037;
                        };
                    } else {
                        switch (baseItemName) {
                            case "magnet": {
                                class_1799 class_17992 = new class_1799((class_1935)ModItems.BACK_PACK_MAGNET_UPGRADE_DEACTIVATED);
                                break;
                            }
                            case "pickblock": {
                                class_1799 class_17992 = new class_1799((class_1935)ModItems.BACK_PACK_PICKBLOCK_UPGRADE_DEACTIVATED);
                                break;
                            }
                            case "itempickup": {
                                class_1799 class_17992 = new class_1799((class_1935)ModItems.BACK_PACK_ITEMPICKUP_UPGRADE_DEACTIVATED);
                                break;
                            }
                            case "flight": {
                                class_1799 class_17992 = new class_1799((class_1935)ModItems.BACK_PACK_FLIGHT_UPGRADE_DEACTIVATED);
                                break;
                            }
                            case "refill": {
                                class_1799 class_17992 = new class_1799((class_1935)ModItems.BACK_PACK_REFILL_UPGRADE_DEACTIVATED);
                                break;
                            }
                            case "feeder": {
                                class_1799 class_17992 = new class_1799((class_1935)ModItems.BACK_PACK_FEEDER_UPGRADE_DEACTIVATED);
                                break;
                            }
                            case "toolswap": {
                                class_1799 class_17992 = new class_1799((class_1935)ModItems.BACK_PACK_TOOLSWAP_UPGRADE_DEACTIVATED);
                                break;
                            }
                            case "falldamage": {
                                class_1799 class_17992 = new class_1799((class_1935)ModItems.BACK_PACK_FALLDAMAGE_UPGRADE_DEACTIVATED);
                                break;
                            }
                            default: {
                                class_1799 class_17992 = itemStack = class_1799.field_8037;
                            }
                        }
                    }
                    if (!itemStack.method_7960()) {
                        BackPackNetworkHelper.sendToServer(slotId, itemStack.method_46651(slot.method_7677().method_7947()), ((BackPackMenu)this.field_2797).backPackType, ((BackPackMenu)this.field_2797).blockPos);
                    }
                    return;
                }
            } else {
                itemName = upgradeItem.getUpgradeName();
                if (itemName.contains("_deactivated")) {
                    String baseItemName;
                    class_1799 itemStack = switch (baseItemName = itemName.replace("back_pack_", "").replace("_upgrade", "").replace("_deactivated", "")) {
                        case "magnet" -> new class_1799((class_1935)ModItems.BACK_PACK_MAGNET_UPGRADE);
                        case "pickblock" -> new class_1799((class_1935)ModItems.BACK_PACK_PICKBLOCK_UPGRADE);
                        case "itempickup" -> new class_1799((class_1935)ModItems.BACK_PACK_ITEMPICKUP_UPGRADE);
                        case "flight" -> new class_1799((class_1935)ModItems.BACK_PACK_FLIGHT_UPGRADE);
                        case "refill" -> new class_1799((class_1935)ModItems.BACK_PACK_REFILL_UPGRADE);
                        case "feeder" -> new class_1799((class_1935)ModItems.BACK_PACK_FEEDER_UPGRADE);
                        case "toolswap" -> new class_1799((class_1935)ModItems.BACK_PACK_TOOLSWAP_UPGRADE);
                        case "falldamage" -> new class_1799((class_1935)ModItems.BACK_PACK_FALLDAMAGE_UPGRADE);
                        default -> class_1799.field_8037;
                    };
                    BackPackNetworkHelper.sendToServer(slotId, itemStack.method_46651(slot.method_7677().method_7947()), ((BackPackMenu)this.field_2797).backPackType, ((BackPackMenu)this.field_2797).blockPos);
                }
            }
        }
        super.method_2383(slot, slotId, mouseButton, type);
    }

    @NotNull
    @ApiStatus.OverrideOnly
    public List<class_768> getExclusionZones() {
        return Arrays.asList(new class_768(this.containerExclusionZoneMinX, this.containerExclusionZoneMinZ, this.containerExclusionZoneWidth, this.containerExclusionZoneHeight), new class_768(this.inventoryExclusionZoneMinX, this.inventoryExclusionZoneMinZ, this.inventoryExclusionZoneWidth, this.inventoryExclusionZoneHeight));
    }

    public Collection<Rectangle> getREIExclusionZones() {
        return Arrays.asList(new Rectangle(this.containerExclusionZoneMinX, this.containerExclusionZoneMinZ, this.containerExclusionZoneWidth, this.containerExclusionZoneHeight), new Rectangle(this.inventoryExclusionZoneMinX, this.inventoryExclusionZoneMinZ, this.inventoryExclusionZoneWidth, this.inventoryExclusionZoneHeight));
    }

    static {
        ctrlKeyDown = false;
    }
}

