/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpacks.upgrades;

import java.util.List;
import java.util.UUID;
import net.fxnt.fxntstorage.backpacks.main.BackPackContainer;
import net.fxnt.fxntstorage.backpacks.main.BackPackItem;
import net.fxnt.fxntstorage.backpacks.main.BackPackMenu;
import net.fxnt.fxntstorage.backpacks.upgrades.PickBlockHandler;
import net.fxnt.fxntstorage.backpacks.upgrades.ToolSwapHandler;
import net.fxnt.fxntstorage.backpacks.util.BackPackHelper;
import net.fxnt.fxntstorage.config.Config;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3468;

public class BackPackOnBackUpgradeHandler {
    public class_1657 player;
    private final BackPackHelper helper;
    private final int magnetUpgradeRange = (Integer)Config.BACKPACK_MAGNET_RANGE.get();
    private final class_1799 itemStack;

    public BackPackOnBackUpgradeHandler(class_1657 player) {
        this.player = player;
        this.helper = new BackPackHelper();
        this.itemStack = this.helper.getWornBackPackStack(player);
    }

    public boolean hasUpgrade(String upgradeName) {
        if (this.itemStack.method_7960()) {
            return false;
        }
        class_2487 tag = this.itemStack.method_7941("BlockEntityTag");
        if (tag != null && tag.method_10545("Upgrades")) {
            class_2499 upgradesList = tag.method_10554("Upgrades", 8);
            for (class_2520 upgrade : upgradesList) {
                if (!upgrade.method_10714().equals(upgradeName)) continue;
                return true;
            }
        }
        return false;
    }

    private BackPackContainer getContainer() {
        class_1703 class_17032 = this.player.field_7512;
        if (class_17032 instanceof BackPackMenu) {
            BackPackMenu backPackMenu = (BackPackMenu)class_17032;
            if (backPackMenu.backPackType == 1) {
                return (BackPackContainer)backPackMenu.container;
            }
        }
        return new BackPackContainer(this.itemStack);
    }

    public void applyMagnetUpgrade() {
        if (this.itemStack.method_7960() || this.player.method_37908().field_9236 || !this.hasUpgrade("back_pack_magnet_upgrade")) {
            return;
        }
        class_238 boundingBox = new class_238(this.player.method_24515()).method_1014((double)this.magnetUpgradeRange);
        List nearbyItems = this.player.method_37908().method_18467(class_1542.class, boundingBox);
        if (!nearbyItems.isEmpty()) {
            for (class_1542 itemEntity : nearbyItems) {
                if (itemEntity.method_6983().method_7909() instanceof BackPackItem) continue;
                this.helper.itemEntityToBackPack(this.getContainer(), this.player.method_37908(), itemEntity, 0, Util.ITEM_SLOT_END_RANGE);
            }
        }
    }

    public boolean applyItemPickupUpgrade(class_1542 itemEntity, UUID target, int pickupDelay) {
        if (this.itemStack.method_7960() || this.player.method_37908().field_9236 || !this.hasUpgrade("back_pack_itempickup_upgrade") || this.hasUpgrade("back_pack_magnet_upgrade")) {
            return false;
        }
        class_1799 itemStack = itemEntity.method_6983();
        class_1792 item = itemStack.method_7909();
        int i = itemStack.method_7947();
        if (pickupDelay == 0 && (target == null || target.equals(this.player.method_5667())) && this.helper.itemEntityToBackPack(this.getContainer(), this.player.method_37908(), itemEntity, 0, Util.ITEM_SLOT_END_RANGE)) {
            this.player.method_6103((class_1297)itemEntity, i);
            if (itemStack.method_7960()) {
                itemEntity.method_31472();
                itemStack.method_7939(i);
            }
            this.player.method_7342(class_3468.field_15392.method_14956((Object)item), i);
            this.player.method_29499(itemEntity);
            return true;
        }
        return false;
    }

    public void applyPickBlockUpgrade(class_2338 blockPos) {
        if (this.itemStack.method_7960() || this.player.method_37908().field_9236 || !this.hasUpgrade("back_pack_pickblock_upgrade")) {
            return;
        }
        PickBlockHandler.pickBlockHandler(this.player, this.getContainer(), blockPos);
    }

    public void applyFeederUpgrade() {
        if (this.itemStack.method_7960() || this.player.method_37908().field_9236 || !this.hasUpgrade("back_pack_feeder_upgrade")) {
            return;
        }
        boolean doFeed = false;
        int hunger = this.player.method_7344().method_7586();
        float saturation = this.player.method_7344().method_7589();
        float health = this.player.method_6032();
        if (health < this.player.method_6063() && hunger < 18 && saturation < 2.0f) {
            doFeed = true;
        }
        if (hunger < 6) {
            doFeed = true;
        }
        if (doFeed) {
            for (int i = 0; i < this.getContainer().method_5439(); ++i) {
                class_1799 food = this.getContainer().method_5438(i);
                if (!food.method_19267()) continue;
                this.player.method_18866(this.player.method_37908(), food);
                break;
            }
        }
    }

    public void applyRefillUpgrade() {
        if (this.itemStack.method_7960() || this.player.method_37908().field_9236 || !this.hasUpgrade("back_pack_refill_upgrade")) {
            return;
        }
        this.refillHand(this.player.method_6047(), false);
        this.refillHand(this.player.method_6079(), true);
    }

    public void refillHand(class_1799 handItem, boolean isOffHand) {
        if (handItem.method_7960()) {
            return;
        }
        int requiredItems = handItem.method_7909().method_7882() - handItem.method_7947();
        if (requiredItems > 0) {
            int offHandSlotIndex = 40;
            int ignorePlayerSlot = isOffHand ? offHandSlotIndex : this.player.method_31548().field_7545;
            boolean success = this.refillMatchingItem(handItem, requiredItems, (class_1263)this.player.method_31548(), 0, this.player.method_31548().method_5439(), ignorePlayerSlot);
            if (!success) {
                this.refillMatchingItem(handItem, requiredItems, this.getContainer(), 0, Util.ITEM_SLOT_END_RANGE, -1);
            }
        }
    }

    public boolean refillMatchingItem(class_1799 itemStack, int requiredItems, class_1263 container, int startIndex, int endIndex, int ignoreSlot) {
        int amountToPlace = requiredItems;
        for (int i = startIndex; i < endIndex; ++i) {
            class_1799 containerItem;
            if (i == ignoreSlot || !class_1799.method_31577((class_1799)itemStack, (class_1799)(containerItem = container.method_5438(i)))) continue;
            if (containerItem.method_7947() < requiredItems) {
                amountToPlace = containerItem.method_7947();
            }
            itemStack.method_7933(amountToPlace);
            containerItem.method_7934(amountToPlace);
            container.method_5431();
            return true;
        }
        return false;
    }

    public boolean applyFallDamageUpgrade() {
        return !this.itemStack.method_7960() && !this.player.method_37908().field_9236 && this.hasUpgrade("back_pack_falldamage_upgrade");
    }

    public void fromAttackBlockEvent(class_1657 player, class_1937 level, class_1268 hand, class_2338 pos) {
        if (this.itemStack.method_7960() || hand != class_1268.field_5810 && player.method_7325() || level.field_9236 || !player.method_5805() || player.method_6113() || player.method_29504() || !this.hasUpgrade("back_pack_toolswap_upgrade")) {
            return;
        }
        ToolSwapHandler toolSwapHandler = new ToolSwapHandler(player, this.getContainer(), Util.TOOL_SLOT_START_RANGE, Util.TOOL_SLOT_END_RANGE);
        toolSwapHandler.doToolSwap(level, pos, null, "block");
    }

    public void fromAttackEntityEvent(class_1657 player, class_1937 level, class_1268 hand, class_1309 entity) {
        if (this.itemStack.method_7960() || hand != class_1268.field_5810 && player.method_7325() || level.field_9236 || !player.method_5805() || player.method_6113() || player.method_29504() || !this.hasUpgrade("back_pack_toolswap_upgrade")) {
            return;
        }
        ToolSwapHandler toolSwapHandler = new ToolSwapHandler(player, this.getContainer(), Util.TOOL_SLOT_START_RANGE, Util.TOOL_SLOT_END_RANGE);
        toolSwapHandler.doToolSwap(level, null, entity, "entity");
    }
}

