/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpacks.upgrades;

import com.simibubi.create.AllSoundEvents;
import net.fxnt.fxntstorage.backpacks.util.BackPackNetworkHelper;
import net.fxnt.fxntstorage.util.ParticleHelper;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_744;

public class JetpackController {
    private final class_1657 player;
    private class_744 input;
    public static boolean isHovering = false;
    public static double hoverHeight = 0.0;
    private static boolean hasJumpedFromGround = false;
    private float jetPackFuelRemaining;
    private final double gravity = -1.7;
    private final double thrust = 0.5;
    private final int maxAllowedHeight = 32;
    private final double defaultPlayerWalkSpeed = 0.17;
    private final double defaultPlayerSneakSpeed = 0.08;
    private final double defaultPlayerSprintSpeed = 0.21;
    private final double baseFlySpeedBoost = 0.5;
    private final double baseHoverSpeedBoost = 0.25;

    public JetpackController(class_1657 player, class_744 input) {
        this.player = player;
        this.input = input;
    }

    public JetpackController(class_1657 player) {
        this.player = player;
    }

    public void doJetPack() {
        if (this.player.method_24828() && !this.input.field_3904) {
            this.deactivateHovering();
            this.player.method_5875(false);
            return;
        }
        this.getJetPackFuel();
        if (this.jetPackFuelRemaining <= 0.0f) {
            this.endHovering(false);
            this.player.method_5875(false);
            return;
        }
        if (this.player.method_5715() && this.input.field_3904) {
            this.startHovering(true);
        } else if (isHovering && this.input.field_3904) {
            this.endHovering(true);
        }
        this.updateJetpackMovement();
        if (this.input.field_3904 || isHovering) {
            this.depleteJetPackFuel();
            ParticleHelper.jetPackParticles(this.player);
        }
        if (this.player.method_24828() && isHovering) {
            this.deactivateHovering();
        }
        if (this.player.method_24828() && this.input.field_3904 && !hasJumpedFromGround) {
            this.player.method_37908().method_8396(this.player, this.player.method_24515(), AllSoundEvents.STEAM.getMainEvent(), class_3419.field_15248, 0.1f, 1.0f);
            hasJumpedFromGround = true;
        }
        if (!this.player.method_24828()) {
            hasJumpedFromGround = false;
        }
    }

    public void updateJetpackMovement() {
        class_243 viewDirection = this.player.method_5828(1.0f);
        class_243 strafeDirection = viewDirection.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
        double forward = this.input.field_3905;
        double strafe = -this.input.field_3907;
        class_243 movementDirection = viewDirection.method_1021(forward).method_1019(strafeDirection.method_1021(strafe));
        double acceleration = isHovering ? 0.01 : 0.05;
        double horizontalSpeed = this.calculateHorizontalSpeed();
        class_243 horizontalVelocity = this.applyMovementPhysics(this.player.method_18798(), movementDirection.method_1029(), acceleration, horizontalSpeed);
        double flySpeed = this.calculateVerticalSpeed();
        double verticalHoverSpeed = isHovering ? this.calculateVerticalHoveringSpeed(hoverHeight) : 0.0;
        double verticalSpeed = this.player.method_18798().field_1351;
        int distanceToGround = JetpackController.getDistance(this.player);
        if ((this.jetPackFuelRemaining < 10.0f || distanceToGround > 32) && this.input.field_3904) {
            verticalSpeed = this.lerp(verticalSpeed, -0.16999999999999998, 0.5);
        } else if (isHovering && Math.abs(verticalSpeed) > 0.1) {
            verticalSpeed = this.lerp(verticalSpeed, verticalHoverSpeed, 0.5);
        } else if (isHovering) {
            this.player.method_38785();
            verticalSpeed = verticalHoverSpeed;
        } else {
            verticalSpeed = flySpeed;
        }
        if (this.input.field_3904) {
            this.player.method_38785();
        }
        this.player.method_18800(horizontalVelocity.field_1352, verticalSpeed, horizontalVelocity.field_1350);
    }

    private class_243 applyMovementPhysics(class_243 currentVelocity, class_243 direction, double acceleration, double maxSpeed) {
        class_243 targetVelocity = currentVelocity.method_1019(direction.method_1021(acceleration));
        double speed = Math.sqrt(targetVelocity.field_1352 * targetVelocity.field_1352 + targetVelocity.field_1350 * targetVelocity.field_1350);
        if (speed > maxSpeed) {
            double scale = maxSpeed / speed;
            targetVelocity = new class_243(targetVelocity.field_1352 * scale, currentVelocity.field_1351, targetVelocity.field_1350 * scale);
        }
        return targetVelocity;
    }

    private double calculateHorizontalSpeed() {
        double enchantedSpeedMultiplier = class_1890.method_42304((class_1309)this.player);
        double mobEffectSpeedMultiplier = this.player.method_6059(class_1294.field_5904) ? (double)this.player.method_6112(class_1294.field_5904).method_5578() : 0.0;
        double baseSpeed = 0.17;
        if (this.player.method_5624()) {
            baseSpeed = 0.21;
        }
        if (isHovering) {
            baseSpeed = 0.08;
        }
        double horizontalSpeed = baseSpeed + 0.5 + mobEffectSpeedMultiplier / 10.0;
        if (isHovering) {
            horizontalSpeed = baseSpeed + 0.25 + enchantedSpeedMultiplier + mobEffectSpeedMultiplier / 10.0;
        }
        return horizontalSpeed;
    }

    private double calculateVerticalSpeed() {
        class_243 motion = this.player.method_18798();
        double currentVerticalSpeed = motion.field_1351;
        double dampingFactor = 0.15;
        if (currentVerticalSpeed < 0.0 && !this.input.field_3904) {
            dampingFactor = 0.05;
        }
        double verticalTarget = this.input.field_3904 ? 0.5 : -1.7;
        double newVerticalSpeed = currentVerticalSpeed * (1.0 - dampingFactor) + verticalTarget * dampingFactor;
        return newVerticalSpeed;
    }

    private double calculateVerticalHoveringSpeed(double targetHeight) {
        double currentHeight = this.player.method_23318();
        double heightDifference = targetHeight - currentHeight;
        long timeInMillis = System.currentTimeMillis();
        double bobbingFrequency = 0.3;
        double bobbingAmplitude = 0.2;
        double cycleDuration = 8000.0;
        double bobbing = Math.sin(Math.PI * 2 * bobbingFrequency * ((double)timeInMillis % cycleDuration) / 200.0);
        bobbing = bobbingAmplitude * bobbing;
        double P = 0.5;
        double D = 0.1;
        return P * heightDifference + D * (heightDifference - bobbing);
    }

    private double lerp(double start, double end, double factor) {
        return start + factor * (end - start);
    }

    private static int getDistance(class_1657 player) {
        class_2338 blockPos;
        class_2338 offset = blockPos = player.method_24515();
        int y = player.method_31478();
        int distance = 0;
        for (int i = y; i >= -64; --i) {
            offset = blockPos.method_33096(i);
            if (!player.method_37908().method_8320(offset).method_26204().method_9564().method_26215()) break;
            ++distance;
        }
        return distance - 1;
    }

    public void deactivateHovering() {
        this.endHovering(true);
    }

    public void toggleHover() {
        if (this.player.method_24828()) {
            this.deactivateHovering();
            return;
        }
        if (!isHovering) {
            this.startHovering(true);
        } else {
            this.endHovering(true);
        }
    }

    public void startHovering(boolean announce) {
        isHovering = true;
        hoverHeight = this.player.method_23318();
        if (announce) {
            this.player.method_7353((class_2561)class_2561.method_43470((String)"Hovering Activated"), true);
        }
    }

    public void endHovering(boolean announce) {
        isHovering = false;
        hoverHeight = 0.0;
        if (announce) {
            this.player.method_7353((class_2561)class_2561.method_43470((String)"Hovering Deactivated"), true);
        }
    }

    public void getJetPackFuel() {
        this.jetPackFuelRemaining = 0.0f;
        BackPackNetworkHelper.updateJetPackFuel();
        this.jetPackFuelRemaining = JetpackState.getFuelLevel();
    }

    public void depleteJetPackFuel() {
        if (this.player.method_7337()) {
            return;
        }
        BackPackNetworkHelper.depleteJetPackFuel();
    }

    public class JetpackState {
        private static float fuelLevel = 0.0f;
        private static boolean hasFlightUpgrade = false;

        public static synchronized float getFuelLevel() {
            return fuelLevel;
        }

        public static synchronized void setFuelLevel(float fuel) {
            fuelLevel = fuel;
        }

        public static synchronized boolean checkHasFlightUpgrade() {
            return hasFlightUpgrade;
        }

        public static synchronized void setHasFlightUpgrade(boolean result) {
            hasFlightUpgrade = result;
        }
    }
}

