/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpacks.upgrades;

import io.github.fabricators_of_create.porting_lib.tool.ToolActions;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_5134;

public class ToolSwapHandler {
    private final class_1657 player;
    private final class_1263 container;
    private final int startIndex;
    private final int endIndex;
    private static class_2680 lastBlockState;
    private static class_1799 lastTool;
    private static class_1309 lastEntity;
    private static class_1799 lastWeapon;

    public ToolSwapHandler(class_1657 player, class_1263 container, int startIndex, int endIndex) {
        this.player = player;
        this.container = container;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public void doToolSwap(class_1937 level, class_2338 blockPos, class_1309 entity, String type) {
        class_1799 currentItem;
        if (type == "block" && blockPos != null) {
            currentItem = this.player.method_6047();
            class_2680 blockState = level.method_8320(blockPos);
            if (blockState != lastBlockState || currentItem != lastTool) {
                this.swapBlockTool(blockState);
            }
            lastBlockState = blockState;
            lastTool = currentItem;
        }
        if (type == "entity" && entity != null) {
            currentItem = this.player.method_6047();
            if (entity != lastEntity || currentItem != lastWeapon) {
                this.swapEntityTool(entity);
            }
            lastEntity = entity;
            lastWeapon = currentItem;
        }
    }

    public void swapBlockTool(class_2680 blockState) {
        class_1799 selectedStack;
        int selectedSlot;
        ToolInfo bestTool = this.findBestToolForBreakingBlock(blockState);
        if (bestTool == null) {
            return;
        }
        if (!bestTool.itemStack.method_7960() && (selectedSlot = this.player.method_31548().field_7545) != bestTool.slot && !(selectedStack = this.player.method_31548().method_7391().method_7972()).method_7960()) {
            this.player.method_31548().method_5447(selectedSlot, bestTool.itemStack.method_7972());
            this.container.method_5447(bestTool.slot, selectedStack.method_7972());
        }
    }

    private ToolInfo findBestToolForBreakingBlock(class_2680 blockState) {
        class_2371 suitableItems = class_2371.method_10211();
        boolean requiresSilkTouch = this.requiresSilkTouch(blockState);
        boolean prefersSilkTouch = this.prefersSilkTouch(blockState);
        boolean needsOrPrefersSilkTouch = requiresSilkTouch || prefersSilkTouch;
        class_1799 currentTool = this.player.method_31548().method_7391();
        boolean currentToolIsCorrect = currentTool.method_7951(blockState);
        boolean currentToolHasSilkTouch = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)currentTool) > 0;
        boolean currentToolMeetsSilkTouchRequirement = false;
        if (needsOrPrefersSilkTouch && currentToolHasSilkTouch) {
            currentToolMeetsSilkTouchRequirement = true;
        } else if (!needsOrPrefersSilkTouch && currentToolHasSilkTouch) {
            currentToolMeetsSilkTouchRequirement = true;
        } else if (!needsOrPrefersSilkTouch) {
            currentToolMeetsSilkTouchRequirement = true;
        }
        if (currentToolIsCorrect && currentToolMeetsSilkTouchRequirement) {
            return null;
        }
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            boolean hasSilkTouch;
            class_1799 itemStack = this.container.method_5438(i);
            if (!itemStack.method_7951(blockState)) continue;
            double speed = itemStack.method_7924(blockState);
            boolean bl = hasSilkTouch = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)itemStack) > 0;
            if (requiresSilkTouch && hasSilkTouch) {
                suitableItems.add((Object)new ToolInfo(itemStack, i, speed, hasSilkTouch));
                continue;
            }
            if (requiresSilkTouch) continue;
            suitableItems.add((Object)new ToolInfo(itemStack, i, speed, hasSilkTouch));
        }
        if (suitableItems.isEmpty()) {
            return new ToolInfo(class_1799.field_8037, -1, 0.0, false);
        }
        ToolSwapHandler.sortTools((class_2371<ToolInfo>)suitableItems, prefersSilkTouch);
        return (ToolInfo)suitableItems.get(0);
    }

    public void swapEntityTool(class_1309 entity) {
        class_1799 selectedStack;
        int selectedSlot;
        WeaponInfo bestWeapon = this.findBestWeaponForAttackingEntity(entity);
        if (bestWeapon == null) {
            return;
        }
        if (!bestWeapon.itemStack.method_7960() && (selectedSlot = this.player.method_31548().field_7545) != bestWeapon.slot && !(selectedStack = this.player.method_31548().method_7391().method_7972()).method_7960()) {
            this.player.method_31548().method_5447(selectedSlot, bestWeapon.itemStack.method_7972());
            this.container.method_5447(bestWeapon.slot, selectedStack.method_7972());
        }
    }

    public WeaponInfo findBestWeaponForAttackingEntity(class_1309 entity) {
        class_2371 suitableItems = class_2371.method_10211();
        class_1799 currentItem = this.player.method_31548().method_7391();
        double currentItemDamage = ToolSwapHandler.getAttackDamage(currentItem, entity);
        for (int i = this.startIndex; i < this.endIndex; ++i) {
            double itemDamage;
            class_1799 itemStack = this.container.method_5438(i);
            if (!itemStack.canPerformAction(ToolActions.SWORD_SWEEP) && !itemStack.method_31573(class_3489.field_42611) && !itemStack.method_31573(class_3489.field_42612) || !((itemDamage = ToolSwapHandler.getAttackDamage(itemStack, entity)) > currentItemDamage)) continue;
            suitableItems.add((Object)new WeaponInfo(itemStack, i, itemDamage));
        }
        if (suitableItems.isEmpty()) {
            return new WeaponInfo(class_1799.field_8037, -1, 0.0);
        }
        ToolSwapHandler.sortWeapons((class_2371<WeaponInfo>)suitableItems);
        return (WeaponInfo)suitableItems.get(0);
    }

    public static double getAttackDamage(class_1799 weapon, class_1309 target) {
        double baseDamage = ToolSwapHandler.getBaseAttackDamage(weapon);
        double enchantmentDamage = ToolSwapHandler.calculateEnchantmentDamage(weapon, target);
        return baseDamage + enchantmentDamage;
    }

    public static double getBaseAttackDamage(class_1799 itemStack) {
        return itemStack.method_7909().getAttributeModifiers(itemStack, class_1304.field_6173).get((Object)class_5134.field_23721).stream().mapToDouble(class_1322::method_6186).sum();
    }

    public static double calculateEnchantmentDamage(class_1799 weapon, class_1309 target) {
        int sharpnessLevel = class_1890.method_8225((class_1887)class_1893.field_9118, (class_1799)weapon);
        int smiteLevel = class_1890.method_8225((class_1887)class_1893.field_9123, (class_1799)weapon);
        int baneLevel = class_1890.method_8225((class_1887)class_1893.field_9112, (class_1799)weapon);
        double additionalDamage = 0.0;
        if (sharpnessLevel > 0) {
            additionalDamage += 1.0 + (double)(sharpnessLevel - 1) * 0.5;
        }
        if (smiteLevel > 0 && target.method_6046() == class_1310.field_6289) {
            additionalDamage += (double)smiteLevel * 2.5;
        }
        if (baneLevel > 0 && target.method_5864() == class_1299.field_6079 || target.method_5864() == class_1299.field_6084 || target.method_5864() == class_1299.field_6125 || target.method_5864() == class_1299.field_6128) {
            additionalDamage += (double)baneLevel * 2.5;
        }
        return additionalDamage;
    }

    public static void sortTools(class_2371<ToolInfo> tools, final boolean sortSilkTouchFirst) {
        Collections.sort(tools, new Comparator<ToolInfo>(){

            @Override
            public int compare(ToolInfo o1, ToolInfo o2) {
                int silkTouchComparison;
                if (sortSilkTouchFirst && (silkTouchComparison = Boolean.compare(o2.silkTouch, o1.silkTouch)) != 0) {
                    return silkTouchComparison;
                }
                return Double.compare(o2.speed, o1.speed);
            }
        });
    }

    public static void sortWeapons(class_2371<WeaponInfo> tools) {
        Collections.sort(tools, new Comparator<WeaponInfo>(){

            @Override
            public int compare(WeaponInfo o1, WeaponInfo o2) {
                return Double.compare(o2.damage, o1.damage);
            }
        });
    }

    public boolean requiresSilkTouch(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        return block == class_2246.field_10033 || block == class_2246.field_10428 || block == class_2246.field_10295 || block == class_2246.field_10225 || block == class_2246.field_10384 || block == class_2246.field_20421;
    }

    public boolean prefersSilkTouch(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        return block == class_2246.field_10219 || block == class_2246.field_10402 || block == class_2246.field_10520 || block == class_2246.field_10460 || block == class_2246.field_10255 || block == class_2246.field_10491 || block == class_2246.field_10477 || block == class_2246.field_10171 || block == class_2246.field_10340 || block == class_2246.field_10174 || block == class_2246.field_10418 || block == class_2246.field_29219 || block == class_2246.field_23077 || block == class_2246.field_10213 || block == class_2246.field_23880 || block == class_2246.field_10212 || block == class_2246.field_29027 || block == class_2246.field_10090 || block == class_2246.field_29028 || block == class_2246.field_10571 || block == class_2246.field_29026 || block == class_2246.field_10013 || block == class_2246.field_29220 || block == class_2246.field_10442 || block == class_2246.field_29029 || block == class_2246.field_10080 || block == class_2246.field_29030;
    }

    public class ToolInfo {
        public final class_1799 itemStack;
        public final int slot;
        public final double speed;
        public final boolean silkTouch;

        public ToolInfo(class_1799 itemStack, int slot, double speed, boolean silkTouch) {
            this.itemStack = itemStack;
            this.slot = slot;
            this.speed = speed;
            this.silkTouch = silkTouch;
        }
    }

    public class WeaponInfo {
        public final class_1799 itemStack;
        public final int slot;
        public final double damage;

        public WeaponInfo(class_1799 itemStack, int slot, double damage) {
            this.itemStack = itemStack;
            this.slot = slot;
            this.damage = damage;
        }
    }
}

