/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.backpacks.upgrades;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeItem
extends class_1792 {
    private final String name;
    private static final int maxLength = 40;

    public UpgradeItem(FabricItemSettings properties, String name) {
        super(properties.method_7889(64));
        this.name = name;
    }

    public String method_7876() {
        return this.method_7869();
    }

    public String getUpgradeName() {
        String name = this.method_7876();
        String replaceTarget = "item.fxntstorage.";
        return name.replace(replaceTarget, "");
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        switch (this.name) {
            case "back_pack_magnet_upgrade_deactivated": 
            case "back_pack_pickblock_upgrade_deactivated": 
            case "back_pack_itempickup_upgrade_deactivated": 
            case "back_pack_flight_upgrade_deactivated": 
            case "back_pack_refill_upgrade_deactivated": 
            case "back_pack_feeder_upgrade_deactivated": 
            case "back_pack_toolswap_upgrade_deactivated": 
            case "back_pack_falldamage_upgrade_deactivated": {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)"DEACTIVATED").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}));
            }
            case "back_pack_magnet_upgrade": 
            case "back_pack_pickblock_upgrade": 
            case "back_pack_itempickup_upgrade": 
            case "back_pack_refill_upgrade": 
            case "back_pack_feeder_upgrade": 
            case "back_pack_toolswap_upgrade": 
            case "back_pack_falldamage_upgrade": {
                this.addUpgradeDetails(tooltipComponents, this.name);
                break;
            }
            case "back_pack_flight_upgrade": {
                this.addFlightUpgradeDetails(tooltipComponents, this.name);
            }
        }
    }

    private void addUpgradeDetails(List<class_2561> tooltipComponents, String upgradeName) {
        List<String> text = this.getUpgradeText(upgradeName, true);
        for (String line : text) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)line).method_27692(class_124.field_1063));
        }
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"fxntstorage.tooltip.holdForDescription").method_27692(class_124.field_1080));
        if (class_437.method_25442()) {
            text = this.getUpgradeText(upgradeName, false);
            for (String line : text) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)line).method_27692(class_124.field_1065));
            }
            text = this.disableText();
            for (String line : text) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)line).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            }
        }
    }

    private void addFlightUpgradeDetails(List<class_2561> tooltipComponents, String upgradeName) {
        List<String> text = this.getUpgradeText(upgradeName, true);
        for (String line : text) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)line).method_27692(class_124.field_1063));
        }
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"fxntstorage.tooltip.holdForDescription").method_27692(class_124.field_1080));
        if (class_437.method_25442()) {
            text = this.getUpgradeText(upgradeName, false);
            for (String line : text) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)line).method_27692(class_124.field_1065));
            }
            text = this.disableText();
            for (String line : text) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)line).method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            }
        }
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"fxntstorage.tooltip.holdForControls").method_27692(class_124.field_1080));
        if (class_437.method_25441()) {
            text = this.getUpgradeText("flight_controls", false);
            for (String line : text) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)line).method_27692(class_124.field_1064));
            }
        }
    }

    private List<String> getUpgradeText(String upgradeName, boolean isActive) {
        switch (upgradeName) {
            case "back_pack_magnet_upgrade": {
                return this.magnetText(isActive);
            }
            case "back_pack_pickblock_upgrade": {
                return this.pickblockText(isActive);
            }
            case "back_pack_itempickup_upgrade": {
                return this.pickupText(isActive);
            }
            case "back_pack_flight_upgrade": {
                return this.flightText(isActive);
            }
            case "flight_controls": {
                return this.flightControlsText(isActive);
            }
            case "back_pack_refill_upgrade": {
                return this.refillText(isActive);
            }
            case "back_pack_feeder_upgrade": {
                return this.feederText(isActive);
            }
            case "back_pack_toolswap_upgrade": {
                return this.toolswapText(isActive);
            }
            case "back_pack_falldamage_upgrade": {
                return this.fallDamageText(isActive);
            }
        }
        return new ArrayList<String>();
    }

    private List<String> disableText() {
        String text = "\nToggle upgrade ability by holding CTRL and clicking the upgrade while in the Backpack's upgrade slot.";
        return Util.wrapText(text, 40);
    }

    private List<String> magnetText(boolean isActive) {
        String text = "Picks up items in a 5 block range around the backpack.\nRange can be configured in the [Config Menu].";
        String shiftText = "Upgrade activates while worn on the Player's back or while placed on the floor.";
        if (isActive) {
            return Util.wrapText(text, 40);
        }
        return Util.wrapText(shiftText, 40);
    }

    private List<String> pickblockText(boolean isActive) {
        String text = "Retrieves an item out of the Item Slots in the backpack when using pick block for an item that's not in the Player's inventory.";
        String shiftText = "Upgrade activates while worn on the Player's back.";
        if (isActive) {
            return Util.wrapText(text, 40);
        }
        return Util.wrapText(shiftText, 40);
    }

    private List<String> pickupText(boolean isActive) {
        String text = "Items will go into the backpack instead of the Player's inventory when picked up.\nDoes NOT work with the Magnet Upgrade";
        String shiftText = "Upgrade activates while worn on the Player's back.";
        if (isActive) {
            return Util.wrapText(text, 40);
        }
        return Util.wrapText(shiftText, 40);
    }

    private List<String> flightText(boolean isActive) {
        String text = "Turns the backpack into a functional jetpack!";
        String shiftText = "Upgrade activates while worn on the Player's back.";
        if (isActive) {
            return Util.wrapText(text, 40);
        }
        return Util.wrapText(shiftText, 40);
    }

    private List<String> flightControlsText(boolean isActive) {
        String text = "\n[Fuel]\nBackTank air from any BackTank inside of the Backpack\n\n[Fly]\nHold Jump to fly upwards to a maximum height of 32 blocks above the ground\n\n[Hover]\nPress H (or Jump and Crouch) to enable hovering\n\nDeactivate hovering by pressing H or Jump";
        String shiftText = "";
        return Util.wrapText(text, 40);
    }

    private List<String> refillText(boolean isActive) {
        String text = "Refills the selected hotbar stack from the Backpack's Item Storage";
        String shiftText = "Upgrade activates while worn on the Player's back.";
        if (isActive) {
            return Util.wrapText(text, 40);
        }
        return Util.wrapText(shiftText, 40);
    }

    private List<String> feederText(boolean isActive) {
        String text = "Feeds the player when hungry from the Backpack's Item Storage";
        String shiftText = "Upgrade activates while worn on the Player's back.";
        if (isActive) {
            return Util.wrapText(text, 40);
        }
        return Util.wrapText(shiftText, 40);
    }

    private List<String> toolswapText(boolean isActive) {
        String text = "Swaps the main hand tool for the most appropriate from the Backpack's Tool Storage";
        String shiftText = "Detects the best tool for the block or entity being broken/attacked.\nTries to prioritize silk touch when beneficial.\nWill only swap tools from the Tool Section of the Backpack.\nUpgrade activates while worn on the Player's back.";
        if (isActive) {
            return Util.wrapText(text, 40);
        }
        return Util.wrapText(shiftText, 40);
    }

    private List<String> fallDamageText(boolean isActive) {
        String text = "Prevents the player from taking fall damage";
        String shiftText = "Upgrade activates while worn on the Player's back.";
        if (isActive) {
            return Util.wrapText(text, 40);
        }
        return Util.wrapText(shiftText, 40);
    }
}

