/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.containers;

import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fxnt.fxntstorage.containers.StorageBoxEntity;
import net.fxnt.fxntstorage.containers.util.ContainerActions;
import net.fxnt.fxntstorage.containers.util.EnumProperties;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2383;
import net.minecraft.class_239;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageBox
extends class_2237
implements class_2343 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2754 STORAGE_USED = class_2754.method_11850((String)"storage_used", EnumProperties.StorageUsed.class);
    private final String title;
    private final int slotCount;
    private static long lastInteractionTime = 0L;
    private static final long INTERACTION_COOLDOWN = 200L;

    public StorageBox(FabricBlockSettings properties, int slotCount, String title) {
        super((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10085));
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)STORAGE_USED, (Comparable)((Object)EnumProperties.StorageUsed.EMPTY)));
        this.slotCount = slotCount;
        this.title = "container.fxntstorage." + title;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        StorageBoxEntity blockEntity = new StorageBoxEntity(pos, state);
        blockEntity.setData(this.title, this.slotCount);
        return blockEntity;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return StorageBox.method_31618(blockEntityType, ModBlocks.STORAGE_BOX_ENTITY, (type, world, pos, entity) -> entity.serverTick(type, world, entity));
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        class_2586 blockEntity;
        if (!state.method_27852(newState.method_26204()) && (blockEntity = level.method_8321(pos)) instanceof class_1263) {
            class_1799 itemStack = new class_1799((class_1935)state.method_26204());
            if (!level.field_9236 && blockEntity instanceof StorageBoxEntity) {
                class_2487 nbt = new class_2487();
                ((StorageBoxEntity)blockEntity).saveItems(nbt);
                if (!nbt.method_33133()) {
                    if (!itemStack.method_7985()) {
                        itemStack.method_7980(new class_2487());
                    }
                    itemStack.method_7969().method_10566("BlockEntityTag", (class_2520)nbt);
                }
                StorageBox.method_9577((class_1937)level, (class_2338)pos, (class_1799)itemStack);
            }
            level.method_8455(pos, (class_2248)this);
        }
        super.method_9536(state, level, pos, newState, movedByPiston);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 blockEntity;
        if (stack.method_7938() && (blockEntity = level.method_8321(pos)) instanceof StorageBoxEntity) {
            ((StorageBoxEntity)blockEntity).method_5476();
        }
    }

    private boolean hitFront(class_2680 blockState, class_3965 hit) {
        class_2350 side = hit.method_17780();
        return blockState.method_11654((class_2769)FACING) == side;
    }

    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean isClient = level.method_8608();
        if (!isClient) {
            if (hand == class_1268.field_5810) {
                return class_1269.field_5812;
            }
            if (!this.hitFront(blockState, hit)) {
                return class_1269.field_5811;
            }
            if (player.method_5998(class_1268.field_5808).method_7960()) {
                StorageBoxEntity screenHandlerFactory;
                class_2586 blockEntity = level.method_8321(blockPos);
                if (blockEntity instanceof StorageBoxEntity && (screenHandlerFactory = (StorageBoxEntity)level.method_8321(blockPos)) != null) {
                    player.method_17355((class_3908)screenHandlerFactory);
                }
                return class_1269.field_21466;
            }
            return ContainerActions.transferItemsToContainer(level, blockPos, player, hit, FACING);
        }
        return class_1269.field_5812;
    }

    public void method_9606(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_1657 player) {
        long currentTime = class_156.method_658();
        if (level.field_9236 || currentTime - lastInteractionTime < 200L) {
            return;
        }
        lastInteractionTime = currentTime;
        class_3965 hit = ContainerActions.rayTraceEyes(level, player, blockPos);
        if (hit.method_17783() != class_239.class_240.field_1332 || !hit.method_17777().equals((Object)blockPos)) {
            return;
        }
        if (!this.hitFront(blockState, hit)) {
            return;
        }
        ContainerActions.transferItemsFromContainer(level, blockPos, player, hit, FACING);
    }

    public void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean movedByPiston) {
        super.method_9615(state, level, pos, oldState, movedByPiston);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder);
        pBuilder.method_11667(new class_2769[]{FACING, STORAGE_USED});
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_9568(stack, level, tooltip, flag);
        class_2487 compoundTag = class_1747.method_38072((class_1799)stack);
        if (compoundTag != null) {
            if (compoundTag.method_10573("LootTable", 8)) {
                tooltip.add((class_2561)class_2561.method_43470((String)"???????"));
            }
            if (compoundTag.method_10573("Items", 9)) {
                class_2371 nonNullList = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)compoundTag, (class_2371)nonNullList);
                int i = 0;
                int j = 0;
                for (class_1799 itemStack : nonNullList) {
                    if (itemStack.method_7960()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    class_5250 mutableComponent = itemStack.method_7964().method_27661();
                    mutableComponent.method_27693(" x").method_27693(String.valueOf(itemStack.method_7947()));
                    tooltip.add((class_2561)mutableComponent);
                }
                if (j - i > 0) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).method_27692(class_124.field_1056));
                }
            }
        }
    }

    @Nullable
    public static class_2350 getDirectionFacing(class_2680 state) {
        if (!(state.method_26204() instanceof StorageBox)) {
            return null;
        }
        return ((StorageBox)state.method_26204()).getFacing(state);
    }

    protected class_2350 getFacing(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)FACING);
    }
}

