/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.containers;

import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fxnt.fxntstorage.config.Config;
import net.fxnt.fxntstorage.containers.StorageBox;
import net.fxnt.fxntstorage.containers.StorageBoxMenu;
import net.fxnt.fxntstorage.containers.util.ContainerSaveContents;
import net.fxnt.fxntstorage.containers.util.StorageBoxEntityHelper;
import net.fxnt.fxntstorage.containers.util.StorageBoxFilteringBox;
import net.fxnt.fxntstorage.init.ModBlocks;
import net.fxnt.fxntstorage.init.ModTags;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageBoxEntity
extends SmartBlockEntity
implements class_1278,
ContainerSaveContents,
ExtendedScreenHandlerFactory {
    public String title = "Default Storage Box";
    public int slotCount = 999;
    public int[] SLOTS_FOR_ALL_DIRECTIONS = new int[this.slotCount];
    public class_2371<class_1799> items;
    protected final class_3913 containerData;
    public class_2338 pos;
    public int storedAmount = -1;
    public int percentageUsed = 0;
    public int lastTick = 0;
    public boolean doTick = false;
    public int updateEveryXTicks = (Integer)Config.STORAGE_BOX_UPDATE_TIME.get();
    public FilteringBehaviour filtering;
    public InvManipulationBehaviour invManipulation;
    public VersionedInventoryTrackerBehaviour invVersionTracker;
    private final StorageBoxEntityHelper<StorageBoxEntity> helper;

    public StorageBoxEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlocks.STORAGE_BOX_ENTITY, pos, blockState);
        this.items = class_2371.method_10213((int)this.slotCount, (Object)class_1799.field_8037);
        this.initializeSlotsForAllDirections();
        this.pos = pos;
        this.containerData = new class_3913(){

            public int method_17390(int index) {
                return StorageBoxEntity.this.slotCount;
            }

            public void method_17391(int index, int value) {
            }

            public int method_17389() {
                return StorageBoxEntity.this.slotCount;
            }
        };
        this.helper = new StorageBoxEntityHelper<StorageBoxEntity>(this);
    }

    public void saveItems(class_2487 nbt) {
        class_2371<class_1799> items = this.getItems();
        class_1262.method_5427((class_2487)nbt, items, (boolean)true);
    }

    public void onLoad() {
        this.helper.onLoad();
    }

    public void setData(String title, int slotCount) {
        this.title = title;
        this.slotCount = slotCount;
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.helper.read(tag);
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        this.helper.write(tag);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.invManipulation = new InvManipulationBehaviour((SmartBlockEntity)this, (w, p, s) -> new BlockFace(p, StorageBox.getDirectionFacing(s).method_10153()));
        behaviours.add((BlockEntityBehaviour)this.invManipulation);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new StorageBoxFilteringBox());
        behaviours.add(1, (BlockEntityBehaviour)this.filtering);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        this.helper.writeScreenOpeningData(buf);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.title);
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return new StorageBoxMenu(i, inventory, (class_2586)this, this.containerData);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @Override
    public int method_5439() {
        return this.slotCount;
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return true;
    }

    public int getStoredAmount() {
        return this.storedAmount;
    }

    public int calculateStoredAmount() {
        return this.helper.calculateStoredAmount();
    }

    public int getPercentageUsed() {
        return this.percentageUsed;
    }

    public int calculatePercentageUsed() {
        return this.helper.calculatePercentageUsed();
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public <T extends class_2586> void serverTick(class_1937 level, class_2338 blockPos, class_2586 blockEntity) {
        this.helper.serverTick(level, blockPos, blockEntity);
    }

    public void initializeSlotsForAllDirections() {
        this.SLOTS_FOR_ALL_DIRECTIONS = new int[this.slotCount];
        for (int i = 0; i < this.slotCount; ++i) {
            this.SLOTS_FOR_ALL_DIRECTIONS[i] = i;
        }
    }

    public int @NotNull [] method_5494(class_2350 side) {
        this.initializeSlotsForAllDirections();
        if (this.SLOTS_FOR_ALL_DIRECTIONS.length < 1) {
            return new int[]{0};
        }
        return this.SLOTS_FOR_ALL_DIRECTIONS;
    }

    public boolean method_5492(int index, class_1799 itemStack, @Nullable class_2350 direction) {
        return this.helper.canPlaceItemThroughFace(this.field_11863, index, itemStack, direction);
    }

    public boolean method_5493(int index, class_1799 itemStack, class_2350 direction) {
        return this.helper.canTakeItemThroughFace(this.field_11863, index, itemStack, direction);
    }

    public boolean transferItems(class_1799 itemStack, int itemSlot, class_1657 player, boolean toPlayer) {
        return this.helper.transferItems(this.field_11863, itemStack, itemSlot, player, toPlayer);
    }

    public boolean filterTest(class_1937 level, class_1799 stack) {
        if (stack.method_31573(ModTags.STORAGE_BOX_ITEM)) {
            return false;
        }
        class_1799 filterItem = this.filtering.getFilter();
        return FilterItemStack.of((class_1799)filterItem).test(level, stack);
    }
}

