/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.containers;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import net.fxnt.fxntstorage.containers.StorageBoxEntity;
import net.fxnt.fxntstorage.util.Util;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class StorageBoxEntityRenderer
extends SmartBlockEntityRenderer<StorageBoxEntity> {
    private final class_5614.class_5615 context;
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};
    private static final int TEXT_COLOR_TRANSPARENT = class_5253.class_5254.method_27764((int)0, (int)255, (int)255, (int)255);

    public StorageBoxEntityRenderer(class_5614.class_5615 context) {
        super(context);
        this.context = context;
    }

    private float getRotationYForSide2D(class_2350 side) {
        return sideRotationY2D[side.ordinal()] * 90.0f * (float)Math.PI / 180.0f;
    }

    protected void renderSafe(StorageBoxEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)blockEntity, (float)partialTick, (class_4587)poseStack, (class_4597)buffer, (int)255, (int)packedOverlay);
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            return;
        }
        int amount = blockEntity.getStoredAmount();
        int percentUsed = blockEntity.getPercentageUsed();
        String amountText = Util.formatNumber(amount);
        String percentText = percentUsed + "% Used";
        float distance = (float)Math.sqrt(blockEntity.method_11016().method_19770((class_2374)player.method_19538()));
        float alpha = Math.max(1.0f - distance / 10.0f, 0.05f);
        if (distance > 10.0f) {
            return;
        }
        float Line1Offset = 7.0f;
        float Line2Offset = 4.0f;
        this.renderLine(amountText, Line1Offset, blockEntity, partialTick, poseStack, buffer, packedLight, alpha);
        this.renderLine(percentText, Line2Offset, blockEntity, partialTick, poseStack, buffer, packedLight, alpha);
    }

    private void renderLine(String text, float YOffset, StorageBoxEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight, float alpha) {
        class_327 textRenderer = this.context.method_32143();
        int textWidth = textRenderer.method_1727(text);
        class_2680 blockState = blockEntity.method_11010();
        class_2350 side = (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        poseStack.method_22903();
        poseStack.method_46416(0.5f, 0.0f, 0.5f);
        poseStack.method_34425(new Matrix4f().rotateYXZ(this.getRotationYForSide2D(side), 0.0f, 0.0f));
        poseStack.method_46416(-0.5f, 0.0f, -0.5f);
        float ZOffset = 15.05f;
        poseStack.method_46416(0.5f, YOffset / 16.0f, ZOffset / 16.0f);
        poseStack.method_22905(0.015625f, -0.015625f, 1.0f);
        int color = 0xFFFFFF;
        color = (int)(255.0f * alpha) << 24 | TEXT_COLOR_TRANSPARENT;
        float x = (float)(-textWidth) / 2.0f;
        float y = 0.0f;
        boolean dropShadow = false;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_4597 buf = buffer;
        class_327.class_6415 displayMode = class_327.class_6415.field_33993;
        int backgroundColor = 0;
        packedLight = 250;
        textRenderer.method_27521(text, x, y, color, dropShadow, matrix, buf, displayMode, backgroundColor, packedLight);
        poseStack.method_22909();
    }
}

