/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.containers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Rectangle;
import net.fxnt.fxntstorage.containers.StorageBoxMenu;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_768;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageBoxScreen
extends class_465<StorageBoxMenu> {
    private static class_1263 container;
    private final int containerSlots;
    private final int containerColumns = 12;
    private int containerRows;
    private final int totalRows;
    private final int containerSlotsMinX = 29;
    private final int containerSlotsMaxX = 245;
    private final int containerSlotsMinZ = 17;
    private int containerSlotsMaxZ;
    private int containerSlotsHeight;
    private final int scrollBarMinX = 249;
    private final int scrollBarMaxX = 263;
    private final int scrollBarMinZ = 17;
    private int scrollBarMaxZ;
    private final int inventorySlotsMinX = 60;
    private final int inventorySlotsMaxX = 222;
    private int inventorySlotsMinZ;
    private int inventorySlotsMaxZ;
    private final int hotbarSlotsMinX = 60;
    private int hotbarSlotsMinZ;
    private int hotbarSlotsMaxZ;
    private final int scrollThumbMinX = 270;
    private final int scrollThumbMaxX = 282;
    private final int scrollThumbMinZ = 0;
    private final int scrollThumbMaxZ = 15;
    private int scrollThumbY;
    private int topVisibleRow;
    private int scrollYOffset;
    private final int scrollThumbWidth = 12;
    private final int scrollThumbHeight = 15;
    private boolean isDragging;
    private int inventoryTextOffset;
    private int containerExclusionZoneMinX;
    private int containerExclusionZoneMaxX;
    private int containerExclusionZoneMinZ;
    private int containerExclusionZoneMaxZ;
    private int containerExclusionZoneWidth;
    private int containerExclusionZoneHeight;
    private int inventoryExclusionZoneMinX;
    private int inventoryExclusionZoneMaxX;
    private int inventoryExclusionZoneMinZ;
    private int inventoryExclusionZoneMaxZ;
    private int inventoryExclusionZoneWidth;
    private int inventoryExclusionZoneHeight;
    private final class_2960 guiTexture5;
    private final class_2960 guiTexture7;
    private final class_2960 guiTexture9;
    private final class_2960 guiTexture11;
    private final int guiTexture5Height = 205;
    private final int guiTexture5Rows = 5;
    private final int guiTexture7Height = 241;
    private final int guiTexture7Rows = 7;
    private final int guiTexture9Height = 277;
    private final int guiTexture9Rows = 9;
    private final int guiTexture11Height = 313;
    private final int guiTexture11Rows = 11;
    private class_2960 guiTexture;
    private int textureHeight;
    private final int textureWidth = 282;

    @Nullable
    public static StorageBoxScreen createScreen(StorageBoxMenu menu, class_1661 playerInventory, class_2561 title) {
        return new StorageBoxScreen(menu, playerInventory, title);
    }

    public StorageBoxScreen(StorageBoxMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.containerSlots = ((StorageBoxMenu)this.field_2797).getContainerSize();
        this.containerColumns = 12;
        this.containerRows = 5;
        this.totalRows = (int)Math.ceil((double)this.containerSlots / 12.0);
        this.containerSlotsMinX = 29;
        this.containerSlotsMaxX = 245;
        this.containerSlotsMinZ = 17;
        this.containerSlotsMaxZ = 29 + 18 * this.containerRows;
        this.containerSlotsHeight = this.containerSlotsMaxZ - 17;
        this.scrollBarMinX = 249;
        this.scrollBarMaxX = 263;
        this.scrollBarMinZ = 17;
        this.scrollBarMaxZ = this.containerSlotsMaxZ;
        this.inventorySlotsMinX = 60;
        this.inventorySlotsMaxX = 222;
        this.inventorySlotsMinZ = this.containerSlotsMaxZ + 15;
        this.inventorySlotsMaxZ = this.inventorySlotsMinZ + 54;
        this.hotbarSlotsMinX = 60;
        this.hotbarSlotsMinZ = this.inventorySlotsMaxZ + 4;
        this.hotbarSlotsMaxZ = this.hotbarSlotsMinZ + 18;
        this.scrollThumbMinX = 270;
        this.scrollThumbMaxX = 282;
        this.scrollThumbMinZ = 0;
        this.scrollThumbMaxZ = 15;
        this.scrollThumbY = 0;
        this.scrollThumbWidth = 12;
        this.scrollThumbHeight = 15;
        this.inventoryTextOffset = 11;
        this.guiTexture5 = new class_2960("fxntstorage", "textures/gui/container/storage_box_screen_5.png");
        this.guiTexture7 = new class_2960("fxntstorage", "textures/gui/container/storage_box_screen_7.png");
        this.guiTexture9 = new class_2960("fxntstorage", "textures/gui/container/storage_box_screen_9.png");
        this.guiTexture11 = new class_2960("fxntstorage", "textures/gui/container/storage_box_screen_11.png");
        this.guiTexture5Height = 205;
        this.guiTexture5Rows = 5;
        this.guiTexture7Height = 241;
        this.guiTexture7Rows = 7;
        this.guiTexture9Height = 277;
        this.guiTexture9Rows = 9;
        this.guiTexture11Height = 313;
        this.guiTexture11Rows = 11;
        this.guiTexture = this.guiTexture5;
        this.textureHeight = 205;
        this.textureWidth = 282;
        container = menu.getInventory();
        this.field_22789 = class_310.method_1551().method_22683().method_4486();
        this.field_22790 = class_310.method_1551().method_22683().method_4502();
        this.updateGuiTextureSize(this.field_22789, this.field_22790);
    }

    public void method_25410(class_310 minecraft, int winWidth, int winHeight) {
        this.updateGuiTextureSize(winWidth, winHeight);
        super.method_25410(minecraft, winWidth, winHeight);
    }

    private void updateGuiTextureSize(int winWidth, int winHeight) {
        this.field_22789 = winWidth;
        this.field_22790 = winHeight;
        this.field_2792 = 270;
        if (winHeight >= 313 && this.containerSlots >= 132) {
            this.guiTexture = this.guiTexture11;
            this.textureHeight = 313;
            this.containerRows = 11;
        } else if (winHeight >= 277 && this.containerSlots >= 108) {
            this.guiTexture = this.guiTexture9;
            this.textureHeight = 277;
            this.containerRows = 9;
        } else if (winHeight >= 241 && this.containerSlots >= 84) {
            this.guiTexture = this.guiTexture7;
            this.textureHeight = 241;
            this.containerRows = 7;
        } else {
            this.guiTexture = this.guiTexture5;
            this.textureHeight = 205;
            this.containerRows = 5;
        }
        this.field_2779 = this.textureHeight;
        this.scrollBarMaxZ = this.containerSlotsMaxZ = 17 + 18 * this.containerRows;
        this.containerSlotsHeight = this.containerSlotsMaxZ - 29;
        this.inventorySlotsMinZ = this.containerSlotsMaxZ + 15;
        this.inventorySlotsMaxZ = this.inventorySlotsMinZ + 54;
        this.hotbarSlotsMinZ = this.inventorySlotsMaxZ + 4;
        this.hotbarSlotsMaxZ = this.hotbarSlotsMinZ + 18;
        this.inventoryTextOffset = 11;
        this.field_2776 = (this.field_22789 - this.field_2792) / 2;
        this.field_2800 = (this.field_22790 - this.field_2779) / 2;
        this.containerExclusionZoneMinX = this.field_2776 + 22;
        this.containerExclusionZoneMinZ = this.field_2800;
        this.containerExclusionZoneWidth = 248;
        this.containerExclusionZoneHeight = this.containerSlotsMaxZ + 12;
        this.containerExclusionZoneMaxX = this.containerExclusionZoneMinX + this.containerExclusionZoneWidth;
        this.containerExclusionZoneMaxZ = this.containerExclusionZoneMinZ + this.containerExclusionZoneHeight;
        this.inventoryExclusionZoneMinX = this.field_2776 + 60 - 6;
        this.inventoryExclusionZoneMinZ = this.field_2800 + this.inventorySlotsMinZ - 6;
        this.inventoryExclusionZoneWidth = 174;
        this.inventoryExclusionZoneHeight = this.hotbarSlotsMaxZ - this.inventorySlotsMinZ + 12;
        this.inventoryExclusionZoneMaxX = this.inventoryExclusionZoneMinX + this.inventoryExclusionZoneWidth;
        this.inventoryExclusionZoneMaxZ = this.inventoryExclusionZoneMinZ + this.inventoryExclusionZoneHeight;
        this.initializeSlots();
    }

    protected void method_25426() {
        super.method_25426();
        this.isDragging = false;
    }

    private void initializeSlots() {
        int yOffset;
        int y;
        int index = 0;
        block0: for (y = 0; y < this.totalRows; ++y) {
            yOffset = 17 + y * 18 + 1;
            int scrollSlotYOffset = y >= this.containerRows ? -2000 : yOffset;
            for (int x = 0; x < 12; ++x) {
                int xOffset = 29 + x * 18 + 1;
                class_1735 slot = ((StorageBoxMenu)this.field_2797).method_7611(index);
                slot.field_7873 = xOffset;
                slot.field_7872 = scrollSlotYOffset;
                if (++index == this.containerSlots) continue block0;
            }
        }
        index = 0;
        for (y = 0; y < 3; ++y) {
            yOffset = this.inventorySlotsMinZ + y * 18 + 1;
            for (int x = 0; x < 9; ++x) {
                int xOffset = 60 + x * 18 + 1;
                class_1735 slot = ((StorageBoxMenu)this.field_2797).getPlayerSlot(index);
                slot.field_7873 = xOffset;
                slot.field_7872 = yOffset;
                ++index;
            }
        }
        index = 0;
        for (int x = 0; x < 9; ++x) {
            int xOffset = 60 + x * 18 + 1;
            class_1735 slot = ((StorageBoxMenu)this.field_2797).getHotbarSlot(index);
            slot.field_7873 = xOffset;
            slot.field_7872 = this.hotbarSlotsMinZ + 1;
            ++index;
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_25290(this.guiTexture, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 282, this.textureHeight);
        graphics.method_25290(this.guiTexture, this.field_2776 + 249 + 1, this.getScrollThumbY(), 270.0f, 0.0f, 12, 15, 282, this.textureHeight);
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_22785, 30, 6, 0x404040, false);
        graphics.method_51439(this.field_22793, this.field_29347, 60, this.inventorySlotsMinZ - this.inventoryTextOffset, 0x404040, false);
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        boolean clickedInside = false;
        double containerLeft = this.containerExclusionZoneMinX;
        double containerRight = this.containerExclusionZoneMaxX;
        double containerTop = this.containerExclusionZoneMinZ;
        double containerBottom = this.containerExclusionZoneMaxZ;
        if (mouseX > containerLeft && mouseX < containerRight && mouseY > containerTop && mouseY < containerBottom) {
            clickedInside = true;
        }
        double inventoryLeft = this.inventoryExclusionZoneMinX;
        double inventoryRight = this.inventoryExclusionZoneMaxX;
        double inventoryTop = this.inventoryExclusionZoneMinZ;
        double inventoryBottom = this.inventoryExclusionZoneMaxZ;
        if (mouseX > inventoryLeft && mouseX < inventoryRight && mouseY > inventoryTop && mouseY < inventoryBottom) {
            clickedInside = true;
        }
        if (!clickedInside) {
            return true;
        }
        return super.method_2381(mouseX, mouseY, left, top, button);
    }

    private int getScrollThumbY() {
        return this.field_2800 + 17 + 1 + this.scrollThumbY;
    }

    private void updateThumbPosition(double adjustedMouseY) {
        this.scrollThumbY = (int)Math.min(Math.max(adjustedMouseY, 0.0), (double)(this.containerSlotsHeight - 15 - 2));
        int row = (int)Math.round((double)this.scrollThumbY / (double)(this.containerSlotsHeight - 15 - 2) * (double)(this.totalRows - this.containerRows));
        this.setTopRow(this.topVisibleRow, row);
    }

    private void snapThumbToGradation() {
        this.scrollThumbY = (int)((double)this.topVisibleRow / (double)(this.totalRows - this.containerRows) * (double)(this.containerRows * 18 - 2 - 15));
    }

    private void setTopRow(int oldTopRow, int newTopRow) {
        if (oldTopRow == newTopRow) {
            return;
        }
        this.topVisibleRow = newTopRow;
        boolean atBottom = newTopRow + this.containerRows > this.totalRows;
        int rowsToMove = newTopRow - oldTopRow;
        int yOffsetBase = 18;
        int numSlotsToUpdate = 12 * this.containerRows;
        int oldStartIndex = oldTopRow * 12;
        int newStartIndex = newTopRow * 12;
        for (int index = oldStartIndex; index < oldStartIndex + numSlotsToUpdate; ++index) {
            ((class_1735)((StorageBoxMenu)this.field_2797).field_7761.get((int)index)).field_7872 = -2000;
        }
        int newRangeEnd = newStartIndex + numSlotsToUpdate;
        if (atBottom) {
            newRangeEnd = Math.min(newRangeEnd, this.containerSlots);
        }
        for (int index = newStartIndex; index < newRangeEnd; ++index) {
            int yOffset;
            int row = index / 12 - newTopRow;
            ((class_1735)((StorageBoxMenu)this.field_2797).field_7761.get((int)index)).field_7872 = yOffset = yOffsetBase + row * 18;
        }
    }

    private void setTopRowAndMoveThumb(int oldTopRow, int newTopRow) {
        this.setTopRow(oldTopRow, newTopRow);
        this.snapThumbToGradation();
    }

    private boolean isMouseOverScrollArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_2776 + 29) && mouseX <= (double)(this.field_2776 + 263) && mouseY >= (double)(this.field_2800 + 17) && mouseY <= (double)(this.field_2800 + this.scrollBarMaxZ);
    }

    private boolean isMouseOverScrollBar(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_2776 + 249) && mouseX <= (double)(this.field_2776 + 263) && mouseY >= (double)(this.field_2800 + 17) && mouseY <= (double)(this.field_2800 + this.scrollBarMaxZ);
    }

    private boolean isMouseOverScrollThumb(double mouseX, double mouseY) {
        return mouseX >= (double)(this.field_2776 + 249) && mouseX <= (double)(this.field_2776 + 263) && mouseY >= (double)this.getScrollThumbY() && mouseY <= (double)(this.getScrollThumbY() + 15);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isMouseOverScrollThumb(mouseX, mouseY) && button == 0) {
            this.scrollYOffset = (int)mouseY - this.scrollThumbY;
            this.isDragging = true;
        } else if (this.isMouseOverScrollBar(mouseX, mouseY) && button == 0) {
            this.updateThumbPosition(mouseY - 17.0 - 1.0 - (double)this.field_2800);
            this.snapThumbToGradation();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging) {
            this.updateThumbPosition(mouseY - (double)this.scrollYOffset);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isDragging) {
            this.isDragging = false;
            this.snapThumbToGradation();
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaY) {
        if (super.method_25401(mouseX, mouseY, deltaY)) {
            return true;
        }
        if (this.isMouseOverScrollArea(mouseX, mouseY)) {
            int newTop = deltaY < 0.0 ? Math.min(this.topVisibleRow + (StorageBoxScreen.method_25442() ? this.containerRows : 1), this.totalRows - this.containerRows) : Math.max(this.topVisibleRow - (StorageBoxScreen.method_25442() ? this.containerRows : 1), 0);
            this.setTopRowAndMoveThumb(this.topVisibleRow, newTop);
            return true;
        }
        return false;
    }

    @NotNull
    @ApiStatus.OverrideOnly
    public List<class_768> getExclusionZones() {
        return Arrays.asList(new class_768(this.containerExclusionZoneMinX, this.containerExclusionZoneMinZ, this.containerExclusionZoneWidth, this.containerExclusionZoneHeight), new class_768(this.inventoryExclusionZoneMinX, this.inventoryExclusionZoneMinZ, this.inventoryExclusionZoneWidth, this.inventoryExclusionZoneHeight));
    }

    public Collection<Rectangle> getREIExclusionZones() {
        return Arrays.asList(new Rectangle(this.containerExclusionZoneMinX, this.containerExclusionZoneMinZ, this.containerExclusionZoneWidth, this.containerExclusionZoneHeight), new Rectangle(this.inventoryExclusionZoneMinX, this.inventoryExclusionZoneMinZ, this.inventoryExclusionZoneWidth, this.inventoryExclusionZoneHeight));
    }
}

