/*
 * Decompiled with CFR 0.152.
 */
package net.fxnt.fxntstorage.containers.util;

import net.fxnt.fxntstorage.containers.StorageBox;
import net.fxnt.fxntstorage.containers.StorageBoxEntity;
import net.fxnt.fxntstorage.containers.util.EnumProperties;
import net.fxnt.fxntstorage.containers.util.TransferItems;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class StorageBoxEntityHelper<T extends StorageBoxEntity> {
    private final T instance;

    public StorageBoxEntityHelper(T blockEntity) {
        this.instance = blockEntity;
    }

    public void onLoad() {
        if (this.instance.method_10997() != null && this.instance.method_10997().field_9236) {
            this.instance.method_10997().method_8413(this.instance.method_11016(), this.instance.method_11010(), this.instance.method_11010(), 3);
            ((StorageBoxEntity)this.instance).initializeSlotsForAllDirections();
        }
    }

    public void read(class_2487 tag) {
        this.instance.loadInventoryFromTag(tag);
        ((StorageBoxEntity)this.instance).title = tag.method_10558("title");
        ((StorageBoxEntity)this.instance).slotCount = tag.method_10550("slotCount");
        ((StorageBoxEntity)this.instance).storedAmount = tag.method_10550("storedAmount");
        ((StorageBoxEntity)this.instance).percentageUsed = tag.method_10550("percentageUsed");
    }

    public void write(class_2487 tag) {
        this.instance.saveInventoryToTag(tag);
        tag.method_10582("title", ((StorageBoxEntity)this.instance).title);
        tag.method_10569("slotCount", ((StorageBoxEntity)this.instance).slotCount);
        tag.method_10569("storedAmount", ((StorageBoxEntity)this.instance).calculateStoredAmount());
        tag.method_10569("percentageUsed", ((StorageBoxEntity)this.instance).calculatePercentageUsed());
    }

    public void writeScreenOpeningData(class_2540 buf) {
        buf.method_10807(((StorageBoxEntity)this.instance).pos);
        buf.writeInt(((StorageBoxEntity)this.instance).slotCount);
    }

    public int calculateStoredAmount() {
        int storedAmount = 0;
        int slots = ((StorageBoxEntity)this.instance).method_5439();
        for (int i = 0; i < slots; ++i) {
            storedAmount += this.instance.method_5438(i).method_7947();
        }
        return storedAmount;
    }

    public int calculatePercentageUsed() {
        double percentageUsed = 0.0;
        int totalSpace = 0;
        int usedSpace = 0;
        int slots = ((StorageBoxEntity)this.instance).method_5439();
        for (int i = 0; i < slots; ++i) {
            int amountInSlot = this.instance.method_5438(i).method_7947();
            int maxItemStackSize = this.instance.method_5444();
            if (!this.instance.method_5438(i).method_7960()) {
                maxItemStackSize = this.instance.method_5438(i).method_7909().method_7882();
            }
            totalSpace += maxItemStackSize;
            usedSpace += amountInSlot;
        }
        if (totalSpace > 0) {
            percentageUsed = (double)usedSpace / (double)totalSpace * 100.0;
        }
        return (int)Math.round(percentageUsed);
    }

    public <T extends class_2586> void serverTick(class_1937 level, class_2338 blockPos, class_2586 blockEntity) {
        if (!level.field_9236 && level != null) {
            ++((StorageBoxEntity)this.instance).lastTick;
            if (((StorageBoxEntity)this.instance).lastTick >= ((StorageBoxEntity)this.instance).updateEveryXTicks) {
                ((StorageBoxEntity)this.instance).lastTick = 0;
                ((StorageBoxEntity)this.instance).doTick = true;
            }
            if (!((StorageBoxEntity)this.instance).doTick) {
                return;
            }
            ((StorageBoxEntity)this.instance).storedAmount = this.calculateStoredAmount();
            level.method_8413(this.instance.method_11016(), this.instance.method_11010(), this.instance.method_11010(), 3);
            class_2680 currentState = level.method_8320(blockPos);
            class_1263 container = (class_1263)blockEntity;
            int totalSlots = container.method_5439();
            boolean allSlotsFull = true;
            int filledSlots = 0;
            for (int i = 0; i < totalSlots; ++i) {
                class_1799 slot = container.method_5438(i);
                if (!slot.method_7960()) {
                    ++filledSlots;
                    if (slot.method_7947() >= slot.method_7909().method_7882()) continue;
                    allSlotsFull = false;
                    continue;
                }
                allSlotsFull = false;
            }
            int emptySlots = totalSlots - filledSlots;
            EnumProperties.StorageUsed newStorageUsed = EnumProperties.StorageUsed.EMPTY;
            if (allSlotsFull) {
                newStorageUsed = EnumProperties.StorageUsed.FULL;
            } else if (emptySlots == 0) {
                newStorageUsed = EnumProperties.StorageUsed.SLOTS_FILLED;
            } else if (filledSlots > 0) {
                newStorageUsed = EnumProperties.StorageUsed.HAS_ITEMS;
            }
            if (currentState.method_11654((class_2769)StorageBox.STORAGE_USED) != newStorageUsed) {
                level.method_8652(blockPos, (class_2680)currentState.method_11657((class_2769)StorageBox.STORAGE_USED, (Comparable)((Object)newStorageUsed)), 3);
            }
            ((StorageBoxEntity)this.instance).doTick = false;
        }
    }

    public boolean canPlaceItemThroughFace(class_1937 level, int index, class_1799 itemStack, @Nullable class_2350 direction) {
        ((StorageBoxEntity)this.instance).initializeSlotsForAllDirections();
        if (!((StorageBoxEntity)this.instance).filterTest(level, itemStack)) {
            return false;
        }
        return ((StorageBoxEntity)this.instance).SLOTS_FOR_ALL_DIRECTIONS.length >= 1;
    }

    public boolean canTakeItemThroughFace(class_1937 level, int index, class_1799 itemStack, class_2350 direction) {
        ((StorageBoxEntity)this.instance).initializeSlotsForAllDirections();
        if (!((StorageBoxEntity)this.instance).filterTest(level, itemStack)) {
            return false;
        }
        return ((StorageBoxEntity)this.instance).SLOTS_FOR_ALL_DIRECTIONS.length >= 1;
    }

    public boolean transferItems(class_1937 level, class_1799 itemStack, int itemSlot, class_1657 player, boolean toPlayer) {
        if (!((StorageBoxEntity)this.instance).filterTest(level, itemStack)) {
            return false;
        }
        int containerRows = ((StorageBoxEntity)this.instance).method_5439() / 9;
        T container = this.instance;
        class_1661 inventory = player.method_31548();
        boolean isSneaking = player.method_5715();
        if (!(itemStack = TransferItems.quickMoveStack(toPlayer, itemStack, itemSlot, containerRows, container, inventory)).method_7960() && toPlayer) {
            this.dropItems(level, itemStack);
        }
        return false;
    }

    private void dropItems(class_1937 level, class_1799 itemStack) {
        class_2350 facing = StorageBox.getDirectionFacing(this.instance.method_11010());
        float xOffset = 0.5f;
        float zOffset = 0.5f;
        if (facing == class_2350.field_11043) {
            zOffset = -0.3f;
        }
        if (facing == class_2350.field_11039) {
            xOffset = -0.3f;
        }
        if (facing == class_2350.field_11034) {
            xOffset = 1.3f;
        }
        if (facing == class_2350.field_11035) {
            zOffset = 1.3f;
        }
        float dropX = (float)((StorageBoxEntity)this.instance).pos.method_10263() + xOffset;
        float dropY = ((StorageBoxEntity)this.instance).pos.method_10264();
        float dropZ = (float)((StorageBoxEntity)this.instance).pos.method_10260() + zOffset;
        class_1799 dropStack = itemStack.method_7971(itemStack.method_7947());
        class_1542 droppedItems = new class_1542(level, (double)dropX, (double)dropY, (double)dropZ, dropStack);
        class_243 motion = droppedItems.method_18798();
        droppedItems.method_5762(-motion.field_1352, -motion.field_1351, -motion.field_1350);
        level.method_8649((class_1297)droppedItems);
    }
}

