/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips.config;

import com.anthonyhilyard.legendarytooltips.Loader;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.toml.TomlParser;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3518;
import net.minecraft.class_5251;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class LegacyConfigConverter {
    private static final String JSON_FILENAME = "legendarytooltips.json5";
    private static final String TOML_FILENAME = "legendarytooltips-common.toml";

    public static void convert() {
        File legacyTomlConfig;
        File legacyJsonConfig = FabricLoader.getInstance().getConfigDir().resolve(JSON_FILENAME).toFile();
        if (legacyJsonConfig.exists() && !legacyJsonConfig.isDirectory()) {
            Loader.LOGGER.info("Legacy configuration file \"{}\" found, converting to new format!", (Object)JSON_FILENAME);
            try (InputStreamReader reader = new InputStreamReader(new FileInputStream(legacyJsonConfig));){
                int i;
                JsonObject rootObject = class_3518.method_15274((Reader)reader, (boolean)true);
                if (rootObject.has("nameSeparator")) {
                    LegendaryTooltipsConfig.INSTANCE.nameSeparator.set((Object)class_3518.method_15270((JsonObject)rootObject, (String)"nameSeparator"));
                }
                if (rootObject.has("bordersMatchRarity")) {
                    LegendaryTooltipsConfig.INSTANCE.bordersMatchRarity.set((Object)class_3518.method_15270((JsonObject)rootObject, (String)"bordersMatchRarity"));
                }
                if (rootObject.has("tooltipShadow")) {
                    LegendaryTooltipsConfig.INSTANCE.tooltipShadow.set((Object)class_3518.method_15270((JsonObject)rootObject, (String)"tooltipShadow"));
                }
                if (rootObject.has("shineEffect")) {
                    LegendaryTooltipsConfig.INSTANCE.shineEffect.set((Object)class_3518.method_15270((JsonObject)rootObject, (String)"shineEffect"));
                }
                if (rootObject.has("startColors")) {
                    JsonArray startColorsArray = class_3518.method_15261((JsonObject)rootObject, (String)"startColors");
                    for (i = 0; i < startColorsArray.size() && i < LegendaryTooltipsConfig.INSTANCE.startColors.length; ++i) {
                        LegendaryTooltipsConfig.INSTANCE.startColors[i] = class_5251.method_27717((int)(startColorsArray.get(i).getAsInt() & 0xFFFFFFFF));
                    }
                }
                if (rootObject.has("endColors")) {
                    JsonArray endColorsArray = class_3518.method_15261((JsonObject)rootObject, (String)"endColors");
                    for (i = 0; i < endColorsArray.size() && i < LegendaryTooltipsConfig.INSTANCE.endColors.length; ++i) {
                        LegendaryTooltipsConfig.INSTANCE.endColors[i] = class_5251.method_27717((int)(endColorsArray.get(i).getAsInt() & 0xFFFFFFFF));
                    }
                }
                if (rootObject.has("framePriorities")) {
                    ArrayList<Integer> newPriorities = new ArrayList<Integer>();
                    JsonArray framePrioritiesArray = class_3518.method_15261((JsonObject)rootObject, (String)"framePriorities");
                    for (int i2 = 0; i2 < framePrioritiesArray.size(); ++i2) {
                        newPriorities.add(framePrioritiesArray.get(i2).getAsInt());
                    }
                    LegendaryTooltipsConfig.INSTANCE.framePriorities.set(newPriorities);
                }
                if (rootObject.has("itemSelectors")) {
                    JsonArray itemSelectorsArray = class_3518.method_15261((JsonObject)rootObject, (String)"itemSelectors");
                    for (int i3 = 0; i3 < itemSelectorsArray.size(); ++i3) {
                        ArrayList<String> newSelectors = new ArrayList<String>();
                        for (JsonElement selector : itemSelectorsArray.get(i3).getAsJsonArray()) {
                            newSelectors.add(selector.getAsString());
                        }
                        LegendaryTooltipsConfig.itemSelectors.get(i3).set(newSelectors);
                    }
                }
                Loader.LOGGER.info("Backing up legacy file to \"{}.bak\".  Configuration file \"{}\" updated from legacy configuration.", (Object)JSON_FILENAME, (Object)TOML_FILENAME);
                LegendaryTooltipsConfig.SPEC.save();
                LegendaryTooltipsConfig.reset();
                reader.close();
                legacyJsonConfig.renameTo(FabricLoader.getInstance().getConfigDir().resolve("legendarytooltips.json5.bak").toFile());
            }
            catch (Exception e) {
                Loader.LOGGER.warn("An error occurred while converting a legacy configuration: {}", (Throwable)e);
            }
        }
        if ((legacyTomlConfig = FabricLoader.getInstance().getConfigDir().resolve(TOML_FILENAME).toFile()).exists() && !legacyTomlConfig.isDirectory()) {
            boolean convert = false;
            ArrayList colorDefs = Lists.newArrayList();
            try (FileInputStream fileStream = new FileInputStream(legacyTomlConfig);){
                BufferedReader reader = new BufferedReader(new InputStreamReader(fileStream));
                Config parsedConfig = Config.of((ConfigFormat)TomlFormat.instance());
                TomlParser parser = new TomlParser();
                parser.parse((Reader)reader, parsedConfig, ParsingMode.REPLACE);
                if (parsedConfig.get("client.custom_borders.colors.level0_start_color") != null) {
                    for (int i = 0; i < 16; ++i) {
                        Object startColor = parsedConfig.get(String.format("client.custom_borders.colors.level%d_start_color", i));
                        Object endColor = parsedConfig.get(String.format("client.custom_borders.colors.level%d_end_color", i));
                        Object bgColor = parsedConfig.get(String.format("client.custom_borders.colors.level%d_bg_color", i));
                        if (i > 0) {
                            if (startColor instanceof Number && ((Number)startColor).intValue() == Integer.valueOf(LegendaryTooltipsConfig.defaultColors.get((Object)LegendaryTooltipsConfig.ColorType.BORDER_START).method_27716()).intValue() || startColor instanceof String && Integer.parseInt((String)startColor) == Integer.valueOf(LegendaryTooltipsConfig.defaultColors.get((Object)LegendaryTooltipsConfig.ColorType.BORDER_START).method_27716())) {
                                startColor = "auto";
                            }
                            if (endColor instanceof Number && ((Number)endColor).intValue() == Integer.valueOf(LegendaryTooltipsConfig.defaultColors.get((Object)LegendaryTooltipsConfig.ColorType.BORDER_END).method_27716()).intValue() || endColor instanceof String && Integer.parseInt((String)endColor) == Integer.valueOf(LegendaryTooltipsConfig.defaultColors.get((Object)LegendaryTooltipsConfig.ColorType.BORDER_END).method_27716())) {
                                endColor = "auto";
                            }
                        }
                        if (bgColor == null) {
                            bgColor = "auto";
                        }
                        colorDefs.add(Arrays.asList(startColor, endColor, bgColor, bgColor));
                    }
                    Loader.LOGGER.info("Legacy configuration file \"{}\" found, converting to new format!", (Object)TOML_FILENAME);
                    convert = true;
                }
                reader.close();
            }
            catch (Exception e) {
                Loader.LOGGER.warn("An error occurred while converting a legacy configuration: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            if (!convert) {
                return;
            }
            try {
                List<String> lines = Files.readAllLines(legacyTomlConfig.toPath());
                FileWriter writer = new FileWriter(legacyTomlConfig);
                for (int i = 0; i < lines.size(); ++i) {
                    if (lines.get(i).contains("[client.custom_borders]")) continue;
                    if (lines.get(i).contains("_start_color")) {
                        Pattern pattern = Pattern.compile("(\\d+)_start");
                        Matcher matcher = pattern.matcher(lines.get(i));
                        matcher.find();
                        int borderIndex = Integer.parseInt(matcher.group(1));
                        Object replacement = lines.get(i).split("=")[0];
                        replacement = (String)replacement + ((List)colorDefs.get(borderIndex)).stream().map(o -> LegacyConfigConverter.formatColorValues(o)).collect(Collectors.joining(", ", "= [", "]"));
                        lines.set(i, ((String)replacement).replace("_start_color", "_colors"));
                    }
                    if (lines.get(i).contains("_end_color") || lines.get(i).contains("_bg_color")) continue;
                    writer.write(lines.get(i).replace("custom_borders.", "") + "\r\n");
                }
                writer.close();
            }
            catch (Exception e) {
                Loader.LOGGER.warn("An error occurred while converting a legacy configuration: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    private static String formatColorValues(Object value) {
        if (value instanceof String) {
            return String.format("\"%s\"", value);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return "\"#" + Integer.toHexString(number.intValue()).toUpperCase() + "\"";
        }
        return "";
    }
}

