/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.render;

import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.WheelBase;
import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.render.AutomobileModels;
import io.github.foundationgames.automobility.automobile.render.BaseModel;
import io.github.foundationgames.automobility.automobile.render.ExhaustFumesModel;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.automobile.render.SkidEffectModel;
import io.github.foundationgames.automobility.automobile.render.attachment.front.FrontAttachmentRenderModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.RearAttachmentRenderModel;
import io.github.foundationgames.automobility.automobile.render.wheel.WheelContextReceiver;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.joml.Vector3f;

public final class AutomobileRenderer
extends Enum<AutomobileRenderer> {
    private static final /* synthetic */ AutomobileRenderer[] $VALUES;

    public static AutomobileRenderer[] values() {
        return (AutomobileRenderer[])$VALUES.clone();
    }

    public static AutomobileRenderer valueOf(String name) {
        return Enum.valueOf(AutomobileRenderer.class, name);
    }

    public static void render(class_4587 pose, class_4597 buffers, int light, int overlay, float tickDelta, RenderableAutomobile automobile) {
        FrontAttachmentType<?> frontAtt;
        AutomobileFrame frame = automobile.getFrame();
        AutomobileWheel wheels = automobile.getWheels();
        AutomobileEngine engine = automobile.getEngine();
        class_3879 skidEffectModel = AutomobileModels.getModel(AutomobileModels.SKID_EFFECT);
        class_3879 exhaustFumesModel = AutomobileModels.getModel(AutomobileModels.EXHAUST_FUMES);
        pose.method_22903();
        pose.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        pose.method_22907(class_7833.field_40716.rotationDegrees(automobile.getAutomobileYaw(tickDelta) + 180.0f));
        float chassisRaise = wheels.model().radius() / 16.0f;
        float bounce = automobile.getSuspensionBounce(tickDelta) * 0.048f;
        class_3879 frameModel = AutomobileModels.getModel(automobile.getFrame().model().modelId());
        class_3879 wheelModel = AutomobileModels.getModel(automobile.getWheels().model().modelId());
        class_3879 engineModel = AutomobileModels.getModel(automobile.getEngine().model().modelId());
        class_3879 rearAttachmentModel = AutomobileModels.getModel(automobile.getRearAttachmentType().model().modelId());
        class_3879 frontAttachmentModel = AutomobileModels.getModel(automobile.getFrontAttachmentType().model().modelId());
        pose.method_46416(0.0f, -chassisRaise, 0.0f);
        pose.method_22903();
        pose.method_22904(0.0, (double)bounce + (automobile.engineRunning() ? Math.cos((double)((float)automobile.getTime() + tickDelta) * 2.7) / 156.0 : 0.0), 0.0);
        class_2960 frameTexture = frame.model().texture();
        class_2960 engineTexture = engine.model().texture();
        if (!frame.isEmpty() && frameModel != null) {
            frameModel.method_2828(pose, buffers.getBuffer(frameModel.method_23500(frameTexture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (frameModel instanceof BaseModel) {
                BaseModel base = (BaseModel)frameModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
        }
        float eBack = frame.model().enginePosBack() / 16.0f;
        float eUp = frame.model().enginePosUp() / 16.0f;
        pose.method_46416(0.0f, -eUp, eBack);
        pose.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        if (!engine.isEmpty() && engineModel != null) {
            engineModel.method_2828(pose, buffers.getBuffer(engineModel.method_23500(engineTexture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (engineModel instanceof BaseModel) {
                BaseModel base = (BaseModel)engineModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
        }
        class_4588 exhaustBuffer = null;
        if (automobile.getBoostTimer() > 0) {
            exhaustTexes = ExhaustFumesModel.FLAME_TEXTURES;
            index = (int)(automobile.getTime() % (long)exhaustTexes.length);
            exhaustBuffer = buffers.getBuffer(class_1921.method_23026((class_2960)exhaustTexes[index]));
        } else if (automobile.engineRunning()) {
            exhaustTexes = ExhaustFumesModel.SMOKE_TEXTURES;
            index = (int)Math.floor(((float)automobile.getTime() + tickDelta) / 1.5f % (float)exhaustTexes.length);
            exhaustBuffer = buffers.getBuffer(class_1921.method_23580((class_2960)exhaustTexes[index]));
        }
        if (exhaustBuffer != null) {
            for (AutomobileEngine.ExhaustPos exhaust : engine.model().exhausts()) {
                pose.method_22903();
                pose.method_46416(exhaust.x() / 16.0f, -exhaust.y() / 16.0f, exhaust.z() / 16.0f);
                pose.method_22907(class_7833.field_40716.rotationDegrees(exhaust.yaw()));
                pose.method_22907(class_7833.field_40714.rotationDegrees(exhaust.pitch()));
                exhaustFumesModel.method_2828(pose, exhaustBuffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                pose.method_22909();
            }
        }
        pose.method_22909();
        RearAttachmentType<?> rearAtt = automobile.getRearAttachmentType();
        if (!rearAtt.isEmpty()) {
            pose.method_22903();
            pose.method_46416(0.0f, chassisRaise, frame.model().rearAttachmentPos() / 16.0f);
            pose.method_22907(class_7833.field_40715.rotationDegrees(automobile.getAutomobileYaw(tickDelta) - automobile.getRearAttachmentYaw(tickDelta)));
            pose.method_46416(0.0f, 0.0f, rearAtt.model().pivotDistPx() / 16.0f);
            if (rearAttachmentModel instanceof RearAttachmentRenderModel) {
                RearAttachmentRenderModel rm = (RearAttachmentRenderModel)rearAttachmentModel;
                rm.setRenderState(automobile.getRearAttachment(), (float)Math.toRadians(automobile.getWheelAngle(tickDelta)), tickDelta);
            }
            rearAttachmentModel.method_2828(pose, buffers.getBuffer(rearAttachmentModel.method_23500(rearAtt.model().texture())), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (rearAttachmentModel instanceof BaseModel) {
                BaseModel base = (BaseModel)rearAttachmentModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
            pose.method_22909();
        }
        if (!(frontAtt = automobile.getFrontAttachmentType()).isEmpty()) {
            pose.method_22903();
            pose.method_46416(0.0f, 0.0f, frame.model().frontAttachmentPos() / -16.0f);
            if (frontAttachmentModel instanceof FrontAttachmentRenderModel) {
                FrontAttachmentRenderModel fm = (FrontAttachmentRenderModel)frontAttachmentModel;
                fm.setRenderState(automobile.getFrontAttachment(), chassisRaise, tickDelta);
            }
            frontAttachmentModel.method_2828(pose, buffers.getBuffer(frontAttachmentModel.method_23500(frontAtt.model().texture())), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (frontAttachmentModel instanceof BaseModel) {
                BaseModel base = (BaseModel)frontAttachmentModel;
                base.doOtherLayerRender(pose, buffers, light, overlay);
            }
            pose.method_22909();
        }
        WheelBase.WheelPos[] wPoses = frame.model().wheelBase().wheels;
        if (!wheels.isEmpty()) {
            class_4588 wheelBuffer = buffers.getBuffer(wheelModel.method_23500(wheels.model().texture()));
            float wheelAngle = automobile.getWheelAngle(tickDelta);
            int wheelCount = automobile.getWheelCount();
            for (WheelBase.WheelPos pos : wPoses) {
                if (wheelCount <= 0) break;
                if (wheelModel instanceof WheelContextReceiver) {
                    WheelContextReceiver receiver = (WheelContextReceiver)wheelModel;
                    receiver.provideContext(pos);
                }
                float scale = pos.scale();
                float wheelRadius = wheels.model().radius() - wheels.model().radius() * (scale - 1.0f);
                pose.method_22903();
                pose.method_46416(pos.right() / 16.0f, wheelRadius / 16.0f, -pos.forward() / 16.0f);
                if (pos.end() == WheelBase.WheelEnd.FRONT) {
                    pose.method_22907(class_7833.field_40716.rotationDegrees(automobile.getSteering(tickDelta) * 27.0f));
                }
                pose.method_46416(0.0f, -chassisRaise, 0.0f);
                pose.method_22907(class_7833.field_40714.rotationDegrees(wheelAngle));
                pose.method_22905(scale, scale, scale);
                pose.method_22907(class_7833.field_40716.rotationDegrees(180.0f + pos.yaw()));
                wheelModel.method_2828(pose, wheelBuffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                if (wheelModel instanceof BaseModel) {
                    BaseModel base = (BaseModel)wheelModel;
                    base.doOtherLayerRender(pose, buffers, light, overlay);
                }
                pose.method_22909();
                --wheelCount;
            }
        }
        if ((automobile.getTurboCharge() > 35 || automobile.debris()) && automobile.automobileOnGround()) {
            class_2960[] skidTexes = SkidEffectModel.COOL_SPARK_TEXTURES;
            boolean bright = true;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (automobile.getTurboCharge() > 115) {
                skidTexes = SkidEffectModel.FLAME_TEXTURES;
            } else if (automobile.getTurboCharge() > 70) {
                skidTexes = SkidEffectModel.HOT_SPARK_TEXTURES;
            } else if (automobile.debris()) {
                skidTexes = SkidEffectModel.DEBRIS_TEXTURES;
                Vector3f c = automobile.debrisColor();
                r = c.x() * 0.85f;
                g = c.y() * 0.85f;
                b = c.z() * 0.85f;
                bright = false;
            }
            int index = (int)Math.floor(((float)automobile.getTime() + tickDelta) / 1.5f % (float)skidTexes.length);
            class_4588 skidEffectBuffer = buffers.getBuffer(bright ? class_1921.method_23026((class_2960)skidTexes[index]) : class_1921.method_23584((class_2960)skidTexes[index]));
            for (WheelBase.WheelPos pos : wPoses) {
                if (pos.end() != WheelBase.WheelEnd.BACK) continue;
                float scale = pos.scale();
                float heightOffset = wheels.model().radius();
                float wheelRadius = wheels.model().radius() * scale;
                float wheelWidth = wheels.model().width() / 16.0f * scale;
                float back = wheelRadius > 2.0f ? (float)(Math.sqrt((double)(wheelRadius * wheelRadius) - Math.pow(wheelRadius - 2.0f, 2.0)) - 0.85) / 16.0f : 0.08f;
                pose.method_22903();
                pose.method_46416(pos.right() / 16.0f + wheelWidth * (float)(pos.side() == WheelBase.WheelSide.RIGHT ? 1 : -1), heightOffset / 16.0f, -pos.forward() / 16.0f + back);
                pose.method_22905(pos.side() == WheelBase.WheelSide.LEFT ? -1.0f : 1.0f, 1.0f, -1.0f);
                skidEffectModel.method_2828(pose, skidEffectBuffer, light, overlay, r, g, b, 0.6f);
                pose.method_22909();
            }
        }
        pose.method_22909();
    }

    private static /* synthetic */ AutomobileRenderer[] $values() {
        return new AutomobileRenderer[0];
    }

    static {
        $VALUES = AutomobileRenderer.$values();
    }
}

