/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block.entity;

import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileStats;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.block.AutomobileAssemblerBlock;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.item.AutomobileEngineItem;
import io.github.foundationgames.automobility.item.AutomobileFrameItem;
import io.github.foundationgames.automobility.item.AutomobileWheelItem;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AutomobileAssemblerBlockEntity
extends class_2586
implements RenderableAutomobile {
    protected AutomobileFrame frame = AutomobileFrame.EMPTY;
    protected AutomobileEngine engine = AutomobileEngine.EMPTY;
    protected AutomobileWheel wheel = AutomobileWheel.EMPTY;
    protected int wheelCount = 0;
    public final List<class_2561> label = new ArrayList<class_2561>();
    protected final AutomobileStats stats = new AutomobileStats();

    public AutomobileAssemblerBlockEntity(class_2338 pos, class_2680 state) {
        super(AutomobilityBlocks.AUTOMOBILE_ASSEMBLER_ENTITY.require(), pos, state);
    }

    @Override
    public AutomobileFrame getFrame() {
        return this.frame;
    }

    @Override
    public AutomobileWheel getWheels() {
        return this.wheel;
    }

    @Override
    public AutomobileEngine getEngine() {
        return this.engine;
    }

    @Override
    @Nullable
    public RearAttachment getRearAttachment() {
        return null;
    }

    @Override
    @Nullable
    public FrontAttachment getFrontAttachment() {
        return null;
    }

    private void partChanged() {
        this.sync();
        this.method_5431();
        this.field_11863.method_43276(class_5712.field_28733, this.method_11016(), new class_5712.class_7397(null, this.method_11010()));
    }

    protected class_1269 handleItemInteract(class_1657 player, class_1799 stack) {
        class_1792 class_17922;
        if (stack.method_31574(AutomobilityItems.CROWBAR.require())) {
            if (!this.field_11863.method_8608()) {
                this.dropParts();
                this.partChanged();
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (this.frame.isEmpty() && (class_17922 = stack.method_7909()) instanceof AutomobileFrameItem) {
            AutomobileFrameItem frameItem = (AutomobileFrameItem)class_17922;
            if (!this.field_11863.method_8608()) {
                this.frame = (AutomobileFrame)frameItem.getComponent(stack);
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                this.partChanged();
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (!this.frame.isEmpty()) {
            if (this.engine.isEmpty() && (class_17922 = stack.method_7909()) instanceof AutomobileEngineItem) {
                AutomobileEngineItem engineItem = (AutomobileEngineItem)class_17922;
                if (!this.field_11863.method_8608()) {
                    this.engine = (AutomobileEngine)engineItem.getComponent(stack);
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    this.partChanged();
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            class_17922 = stack.method_7909();
            if (class_17922 instanceof AutomobileWheelItem) {
                AutomobileWheelItem wheelItem = (AutomobileWheelItem)class_17922;
                if (!this.field_11863.method_8608()) {
                    AutomobileWheel wheelType = (AutomobileWheel)wheelItem.getComponent(stack);
                    if (this.wheel.isEmpty()) {
                        this.wheel = wheelType;
                        this.wheelCount = 0;
                    }
                    if (this.wheel == wheelType && this.wheelCount < this.frame.model().wheelBase().wheelCount) {
                        ++this.wheelCount;
                        if (!player.method_7337()) {
                            stack.method_7934(1);
                        }
                        this.partChanged();
                        return class_1269.field_5812;
                    }
                } else {
                    return class_1269.field_5811;
                }
            }
        }
        if (!this.field_11863.method_8608() && stack.method_31574((class_1792)AutomobilityItems.FRONT_ATTACHMENT.require()) || stack.method_31574((class_1792)AutomobilityItems.REAR_ATTACHMENT.require())) {
            player.method_7353(AutomobileAssemblerBlock.INCOMPLETE_AUTOMOBILE_DIALOG, true);
        }
        return class_1269.field_5814;
    }

    public class_1269 interact(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_1269 result = this.handleItemInteract(player, stack);
        if (!this.field_11863.method_8608() && result == class_1269.field_5812) {
            if (!this.isComplete()) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_26962, class_3419.field_15245, 0.7f, 0.6f + this.field_11863.field_9229.method_43057() * 0.15f);
            }
            this.tryConstructAutomobile();
            return class_1269.field_5812;
        }
        return result;
    }

    protected class_243 centerPos() {
        return new class_243((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.75, (double)this.field_11867.method_10260() + 0.5);
    }

    public boolean isComplete() {
        return !this.frame.isEmpty() && !this.engine.isEmpty() && !this.wheel.isEmpty() && this.wheelCount >= this.frame.model().wheelBase().wheelCount;
    }

    public void tryConstructAutomobile() {
        if (this.isComplete()) {
            class_243 pos = this.centerPos();
            AutomobileEntity auto = new AutomobileEntity(this.field_11863);
            auto.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, this.getAutomobileYaw(0.0f), 0.0f);
            auto.setComponents(this.frame, this.wheel, this.engine);
            this.field_11863.method_8649((class_1297)auto);
            this.field_11863.method_18456().forEach(p -> {
                if (p instanceof class_3222) {
                    class_3222 player = (class_3222)p;
                    if (p.method_24515().method_10262((class_2382)this.field_11867) < 80000.0) {
                        player.field_13987.method_14364((class_2596)new class_2675((class_2394)class_2398.field_11236, false, pos.field_1352, pos.field_1351 + 0.47, pos.field_1350, 0.0f, 0.0f, 0.0f, 0.0f, 1));
                    }
                }
            });
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14785, class_3419.field_15245, 0.23f, 0.5f);
            this.clear();
        }
    }

    public void dropParts() {
        class_243 pos = this.centerPos();
        this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, pos.field_1352, pos.field_1351, pos.field_1350, AutomobilityItems.AUTOMOBILE_FRAME.require().createStack(this.getFrame())));
        this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, pos.field_1352, pos.field_1351, pos.field_1350, AutomobilityItems.AUTOMOBILE_ENGINE.require().createStack(this.getEngine())));
        class_1799 wheelStack = AutomobilityItems.AUTOMOBILE_WHEEL.require().createStack(this.getWheels());
        wheelStack.method_7939(this.wheelCount);
        this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, pos.field_1352, pos.field_1351, pos.field_1350, wheelStack));
        this.clear();
    }

    public void clear() {
        this.frame = AutomobileFrame.EMPTY;
        this.wheel = AutomobileWheel.EMPTY;
        this.engine = AutomobileEngine.EMPTY;
        this.wheelCount = 0;
    }

    private boolean hasAllParts() {
        return !this.frame.isEmpty() && !this.wheel.isEmpty() && !this.engine.isEmpty();
    }

    private void onComponentsUpdated() {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            this.label.clear();
            if (this.hasAllParts()) {
                this.stats.from(this.frame, this.wheel, this.engine);
                this.stats.appendTexts(this.label, this.stats);
            }
        }
    }

    private void sync() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 sWorld = (class_3218)class_19372;
            sWorld.method_14178().method_14128(this.field_11867);
        }
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.frame = AutomobileFrame.REGISTRY.getOrDefault(class_2960.method_12829((String)nbt.method_10558("frame")));
        this.engine = AutomobileEngine.REGISTRY.getOrDefault(class_2960.method_12829((String)nbt.method_10558("engine")));
        class_2487 wheelNbt = nbt.method_10562("wheels");
        this.wheel = AutomobileWheel.REGISTRY.getOrDefault(class_2960.method_12829((String)wheelNbt.method_10558("type")));
        this.wheelCount = wheelNbt.method_10550("count");
        this.onComponentsUpdated();
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10582("frame", this.frame.getId().toString());
        nbt.method_10582("engine", this.engine.getId().toString());
        class_2487 wheelNbt = new class_2487();
        wheelNbt.method_10582("type", this.wheel.getId().toString());
        wheelNbt.method_10569("count", this.wheelCount);
        nbt.method_10566("wheels", (class_2520)wheelNbt);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = new class_2487();
        this.method_11007(nbt);
        return nbt;
    }

    protected boolean powered() {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        return state.method_28498((class_2769)AutomobileAssemblerBlock.POWERED) && (Boolean)state.method_11654((class_2769)AutomobileAssemblerBlock.POWERED) != false;
    }

    @Override
    public float getAutomobileYaw(float tickDelta) {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        return state.method_28498((class_2769)AutomobileAssemblerBlock.field_11177) ? ((class_2350)state.method_11654((class_2769)AutomobileAssemblerBlock.field_11177)).method_10144() - 90.0f : 0.0f;
    }

    @Override
    public int getWheelCount() {
        return this.wheelCount;
    }

    @Override
    public float getRearAttachmentYaw(float tickDelta) {
        return 0.0f;
    }

    @Override
    public float getWheelAngle(float tickDelta) {
        return this.powered() ? ((float)this.getTime() + tickDelta) * 36.0f : 0.0f;
    }

    @Override
    public float getSteering(float tickDelta) {
        return 0.0f;
    }

    @Override
    public float getSuspensionBounce(float tickDelta) {
        return 0.0f;
    }

    @Override
    public boolean engineRunning() {
        return this.powered();
    }

    @Override
    public int getBoostTimer() {
        return this.powered() ? 1 : 0;
    }

    @Override
    public int getTurboCharge() {
        return 0;
    }

    @Override
    public long getTime() {
        return this.field_11863.method_8510();
    }

    @Override
    public boolean automobileOnGround() {
        return false;
    }

    @Override
    public boolean debris() {
        return false;
    }

    @Override
    public Vector3f debrisColor() {
        return null;
    }
}

