/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipe;
import io.github.foundationgames.automobility.screen.AutoMechanicTableScreenHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import net.minecraft.class_5481;
import net.minecraft.class_6880;

public class AutoMechanicTableScreen
extends class_465<AutoMechanicTableScreenHandler> {
    private static final class_2960 TEXTURE = Automobility.rl("textures/gui/container/auto_mechanic_table.png");
    private static final int RECIPE_BUTTON_SIZE = 17;
    private static final int RECIPE_PANEL_WIDTH = 85;
    private static final int RECIPE_PANEL_HEIGHT = 51;
    private static final int CATEGORY_BUTTON_WIDTH = 12;
    private static final int CATEGORY_BUTTON_HEIGHT = 15;
    private static final int CATEGORY_BUTTON_AREA_WIDTH = 91;
    private static final int SCROLL_BAR_WIDTH = 3;
    private static final int SCROLL_BAR_HEIGHT = 10;
    private static final int SCROLL_BAR_AREA_HEIGHT = 51;
    private long time = 0L;
    private int recipePanelX;
    private int recipePanelY;
    private int categoryButtonsX;
    private int categoryButtonsY;
    private int currentCategory = 0;
    private int recipeScroll = 0;
    private final List<class_2960> orderedCategories = AutoMechanicTableScreen.createDefaultCategories();
    private final Map<class_2960, List<RecipeEntry>> recipes = new HashMap<class_2960, List<RecipeEntry>>();
    private class_5481 categoryTitle;

    public AutoMechanicTableScreen(AutoMechanicTableScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 176;
        this.field_2779 = 209;
        this.field_25268 = 8;
        for (int id = 0; id < handler.recipes.size(); ++id) {
            AutoMechanicTableRecipe recipe = handler.recipes.get(id);
            class_2960 category = recipe.getCategory();
            this.recipes.computeIfAbsent(category, cat -> new ArrayList());
            if (!this.orderedCategories.contains(category)) {
                this.orderedCategories.add(category);
            }
            this.recipes.get(category).add(new RecipeEntry(id, recipe));
        }
        this.field_25270 = this.field_2800 + 115;
    }

    private static List<class_2960> createDefaultCategories() {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        list.add(Automobility.rl("frames"));
        list.add(Automobility.rl("engines"));
        list.add(Automobility.rl("wheels"));
        return list;
    }

    protected void method_25426() {
        super.method_25426();
        this.recipePanelX = this.field_2776 + 76;
        this.recipePanelY = this.field_2800 + 21;
        this.categoryButtonsX = this.field_2776 + 75;
        this.categoryButtonsY = this.field_2800 + 4;
        this.categoryTitle = this.createCategoryTitle(this.orderedCategories.get(0));
    }

    protected void method_37432() {
        super.method_37432();
        ++this.time;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    private void preDraw() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        this.method_25420(graphics);
        this.preDraw();
        graphics.method_25302(TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        this.drawCategoryBar(graphics, mouseX, mouseY);
        this.drawRecipes(graphics, mouseX, mouseY);
        this.drawMissingIngredients(graphics);
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        super.method_2388(graphics, mouseX, mouseY);
        int hoveredRecipe = this.getHoveredRecipe(mouseX, mouseY);
        if (hoveredRecipe >= 0) {
            graphics.method_51446(this.field_22793, ((AutoMechanicTableScreenHandler)this.field_2797).recipes.get(hoveredRecipe).getResultItem(), mouseX - this.field_2776, mouseY - this.field_2800);
        }
    }

    private void changeCategory(int by) {
        this.currentCategory = Math.floorMod(this.currentCategory + by, this.orderedCategories.size());
        this.categoryTitle = this.createCategoryTitle(this.orderedCategories.get(this.currentCategory));
        this.recipeScroll = 0;
    }

    private class_5481 createCategoryTitle(class_2960 category) {
        String translated = class_1074.method_4662((String)("part_category." + category.method_12836() + "." + category.method_12832()), (Object[])new Object[0]);
        if (this.field_22793.method_1727(translated) > 64) {
            return class_2561.method_43470((String)(this.field_22793.method_27523(translated, 57) + "...")).method_30937();
        }
        return class_2561.method_43470((String)this.field_22793.method_27523(translated, 64)).method_30937();
    }

    private void buttonClicked() {
        if (this.field_22787 != null) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int selectedCatButton = this.getHoveredCategoryButton((int)mouseX, (int)mouseY);
            if (selectedCatButton != 0) {
                this.changeCategory(selectedCatButton);
                this.buttonClicked();
                return true;
            }
            int recipe = this.getHoveredRecipe((int)mouseX, (int)mouseY);
            if (recipe >= 0) {
                this.selectRecipe(recipe);
                this.buttonClicked();
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void selectRecipe(int id) {
        ((AutoMechanicTableScreenHandler)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, id);
        this.field_22787.field_1761.method_2900(((AutoMechanicTableScreenHandler)this.field_2797).field_7763, id);
    }

    private int getMaxRecipeScroll() {
        return Math.max(0, class_3532.method_15386((float)((float)this.getRecipeList().size() / 5.0f)) - 3);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (amount != 0.0 && this.getHoveredRecipe((int)mouseX, (int)mouseY) >= -1) {
            this.recipeScroll += amount > 0.0 ? -1 : 1;
            this.recipeScroll = class_3532.method_15340((int)this.recipeScroll, (int)0, (int)this.getMaxRecipeScroll());
            return true;
        }
        return false;
    }

    protected final void drawMissingIngredient(class_332 graphics, class_1856 ing, int x, int y) {
        graphics.method_25294(x, y, x + 16, y + 16, 1174339584);
        class_1799[] stacks = ing.method_8105();
        graphics.method_51445(stacks[class_3532.method_15375((float)((float)this.time / 30.0f)) % stacks.length], x, y);
        RenderSystem.depthFunc((int)516);
        graphics.method_25294(x, y, x + 16, y + 16, 0x30FFFFFF);
        RenderSystem.depthFunc((int)515);
    }

    protected void drawMissingIngredients(class_332 graphics) {
        class_1277 inputInv = ((AutoMechanicTableScreenHandler)this.field_2797).inputInv;
        ArrayDeque<class_1856> missingIngs = new ArrayDeque<class_1856>(((AutoMechanicTableScreenHandler)this.field_2797).missingIngredients);
        for (int i = 0; i < inputInv.method_5439(); ++i) {
            if (missingIngs.size() <= 0) continue;
            int x = this.field_2776 + 8 + i * 18;
            int y = this.field_2800 + 88;
            if (!inputInv.method_5438(i).method_7960()) continue;
            this.drawMissingIngredient(graphics, missingIngs.removeFirst(), x, y);
        }
    }

    protected List<RecipeEntry> getRecipeList() {
        if (this.currentCategory < this.orderedCategories.size() && this.currentCategory >= 0) {
            return this.recipes.get(this.orderedCategories.get(this.currentCategory));
        }
        return Collections.emptyList();
    }

    protected int getHoveredCategoryButton(int mouseX, int mouseY) {
        if (mouseY > this.categoryButtonsY && mouseY < this.categoryButtonsY + 15) {
            int relX = mouseX - this.categoryButtonsX;
            if (relX < 0 || relX > 91) {
                return 0;
            }
            if (relX < 12) {
                return -1;
            }
            if (relX > 79) {
                return 1;
            }
        }
        return 0;
    }

    protected int getHoveredRecipe(int mouseX, int mouseY) {
        if (this.currentCategory < this.orderedCategories.size() && this.currentCategory >= 0 && (mouseX -= this.recipePanelX) >= 0 && mouseX < 85 && (mouseY -= this.recipePanelY) >= 0 && mouseY < 51) {
            int row = class_3532.method_15375((float)((float)mouseY / 17.0f));
            int col = class_3532.method_15375((float)((float)mouseX / 17.0f));
            if (row >= 0 && col >= 0) {
                int idx = 5 * (row + this.recipeScroll) + col;
                List<RecipeEntry> recipes = this.recipes.get(this.orderedCategories.get(this.currentCategory));
                if (idx < recipes.size()) {
                    return recipes.get(idx).id();
                }
                return -1;
            }
        }
        return -2;
    }

    protected void drawCategoryBar(class_332 graphics, int mouseX, int mouseY) {
        int hoveredCatButton = this.getHoveredCategoryButton(mouseX, mouseY);
        this.preDraw();
        graphics.method_25302(TEXTURE, this.categoryButtonsX, this.categoryButtonsY, 176, 17 + (hoveredCatButton < 0 ? 15 : 0), 12, 15);
        graphics.method_25302(TEXTURE, this.categoryButtonsX + 79, this.categoryButtonsY, 188, 17 + (hoveredCatButton > 0 ? 15 : 0), 12, 15);
        if (this.categoryTitle != null) {
            graphics.method_35719(this.field_22793, this.categoryTitle, this.field_2776 + 120, this.field_2800 + 8, 0xFFFFFF);
        }
    }

    protected void drawRecipes(class_332 graphics, int mouseX, int mouseY) {
        if (this.orderedCategories.size() > 0) {
            List<RecipeEntry> recipes = this.recipes.get(this.orderedCategories.get(this.currentCategory));
            for (int row = 0; row < 3; ++row) {
                int idx;
                for (int col = 0; col < 5 && (idx = 5 * this.recipeScroll + 5 * row + col) < recipes.size(); ++col) {
                    int x = col * 17 + this.recipePanelX;
                    int y = row * 17 + this.recipePanelY;
                    RecipeEntry entry = recipes.get(idx);
                    RecipeButtonState state = RecipeButtonState.DEFAULT;
                    if (((AutoMechanicTableScreenHandler)this.field_2797).getSelectedRecipe().isPresent() && ((AutoMechanicTableScreenHandler)this.field_2797).getSelectedRecipeId() == entry.id()) {
                        state = RecipeButtonState.SELECTED;
                    } else if (this.getHoveredRecipe(mouseX, mouseY) == entry.id()) {
                        state = RecipeButtonState.HOVERED;
                    }
                    this.drawRecipeEntry(entry, graphics, x, y, state);
                }
            }
        }
        this.preDraw();
        int maxScroll = this.getMaxRecipeScroll();
        int scrollBarX = this.field_2776 + 162;
        int scrollBarY = this.field_2800 + 21;
        if (maxScroll > 0) {
            scrollBarY += (int)(41.0f * ((float)this.recipeScroll / (float)maxScroll));
        }
        graphics.method_25302(TEXTURE, scrollBarX, scrollBarY, 227, 0, 3, 10);
    }

    protected void drawRecipeEntry(RecipeEntry entry, class_332 graphics, int x, int y, RecipeButtonState state) {
        this.preDraw();
        graphics.method_25302(TEXTURE, x, y, 176 + state.ordinal() * 17, 0, 17, 17);
        class_1799 stack = entry.recipe.getResultItem();
        graphics.method_51445(stack, x, y);
    }

    public record RecipeEntry(int id, AutoMechanicTableRecipe recipe) {
    }

    public static enum RecipeButtonState {
        DEFAULT,
        HOVERED,
        SELECTED;

    }
}

