/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.screen;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3914;
import net.minecraft.class_3915;

public class AutoMechanicTableScreenHandler
extends class_1703 {
    private final class_1937 world;
    private final class_3914 context;
    private final class_3915 selectedRecipe = class_3915.method_17403();
    public List<AutoMechanicTableRecipe> recipes;
    public final List<class_1856> missingIngredients = new ArrayList<class_1856>();
    public final class_1277 inputInv;
    public final class_1735 outputSlot;
    private final int playerInvSlot;

    public AutoMechanicTableScreenHandler(int syncId, class_1661 playerInv) {
        this(syncId, playerInv, class_3914.field_17304);
    }

    public AutoMechanicTableScreenHandler(int syncId, class_1661 playerInv, class_3914 ctx) {
        super(Automobility.AUTO_MECHANIC_SCREEN.require("Auto mechanic screen not registered!"), syncId);
        this.world = playerInv.field_7546.method_37908();
        this.context = ctx;
        this.inputInv = new class_1277(9){

            public void method_5431() {
                AutoMechanicTableScreenHandler.this.onInputUpdated();
            }
        };
        for (int s = 0; s < 9; ++s) {
            this.method_7621(new InputSlot((class_1263)this.inputInv, s, 8 + s * 18, 88));
        }
        this.outputSlot = this.method_7621(new OutputSlot((class_1263)new class_1277(1), 0, 26, 38));
        this.playerInvSlot = this.field_7761.size();
        int playerInvY = 127;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInv, col + row * 9 + 9, 8 + col * 18, playerInvY + row * 18));
            }
        }
        for (int s = 0; s < 9; ++s) {
            this.method_7621(new class_1735((class_1263)playerInv, s, 8 + s * 18, playerInvY + 58));
        }
        this.recipes = new ArrayList<AutoMechanicTableRecipe>(this.world.method_8433().method_30027(AutoMechanicTableRecipe.TYPE));
        Collections.sort(this.recipes);
        this.selectedRecipe.method_17404(-1);
        this.method_17362(this.selectedRecipe);
    }

    public Optional<AutoMechanicTableRecipe> getSelectedRecipe() {
        int id = this.selectedRecipe.method_17407();
        return id >= 0 && this.recipes.size() > 0 && id < this.recipes.size() ? Optional.of(this.recipes.get(id)) : Optional.empty();
    }

    public int getSelectedRecipeId() {
        return this.selectedRecipe.method_17407();
    }

    private void updateMissingIngredients() {
        this.missingIngredients.clear();
        this.getSelectedRecipe().ifPresent(recipe -> recipe.forMissingIngredients((class_1263)this.inputInv, this.missingIngredients::add));
    }

    private void updateRecipeState() {
        this.updateMissingIngredients();
        this.getSelectedRecipe().ifPresent(recipe -> {
            if (recipe.matches(this.inputInv, this.world)) {
                this.outputSlot.method_7673(recipe.getResultItem().method_7972());
            } else {
                this.outputSlot.method_7673(class_1799.field_8037);
            }
        });
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id >= 0 && id < this.recipes.size()) {
            this.selectRecipe(id);
            return true;
        }
        return super.method_7604(player, id);
    }

    private void onInputUpdated() {
        this.updateRecipeState();
    }

    private void selectRecipe(int id) {
        this.selectedRecipe.method_17404(id);
        this.updateRecipeState();
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.outputSlot.method_7673(class_1799.field_8037);
        this.context.method_17393((world, pos) -> this.method_7607(player, (class_1263)this.inputInv));
    }

    public boolean method_7597(class_1657 player) {
        return AutoMechanicTableScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)AutomobilityBlocks.AUTO_MECHANIC_TABLE.require());
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.outputSlot && super.method_7613(stack, slot);
    }

    public class_1799 method_7601(class_1657 player, int fromSlotId) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 fromSlot = (class_1735)this.field_7761.get(fromSlotId);
        if (fromSlot.method_7681()) {
            class_1799 fromStack = fromSlot.method_7677();
            class_1792 fromItem = fromStack.method_7909();
            newStack = fromStack.method_7972();
            if (fromSlotId == this.outputSlot.field_7874) {
                fromItem.method_7843(fromStack, player.method_37908(), player);
                if (!this.method_7616(fromStack, this.playerInvSlot, this.playerInvSlot + 36, true)) {
                    return class_1799.field_8037;
                }
                fromSlot.method_7670(fromStack, newStack);
            } else if (this.field_7761.stream().anyMatch(s -> s.field_7871 == this.inputInv && s.field_7874 == fromSlotId) ? !this.method_7616(fromStack, this.playerInvSlot, this.playerInvSlot + 36, false) : (this.missingIngredients.stream().anyMatch(ing -> ing.method_8093(fromStack)) ? !this.method_7616(fromStack, 0, 8, false) : (fromSlotId >= this.playerInvSlot && fromSlotId < this.playerInvSlot + 27 ? !this.method_7616(fromStack, this.playerInvSlot + 27, this.playerInvSlot + 36, false) : fromSlotId >= this.playerInvSlot + 27 && fromSlotId < this.playerInvSlot + 36 && !this.method_7616(fromStack, this.playerInvSlot, this.playerInvSlot + 27, false)))) {
                return class_1799.field_8037;
            }
            if (fromStack.method_7960()) {
                fromSlot.method_7673(class_1799.field_8037);
            }
            fromSlot.method_7668();
            if (fromStack.method_7947() == newStack.method_7947()) {
                return class_1799.field_8037;
            }
            fromSlot.method_7667(player, fromStack);
            this.method_7623();
        }
        return newStack;
    }

    public static class InputSlot
    extends class_1735 {
        public InputSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }
    }

    public class OutputSlot
    extends class_1735 {
        public OutputSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return false;
        }

        public void method_7667(class_1657 player, class_1799 stack) {
            super.method_7667(player, stack);
            AutoMechanicTableScreenHandler.this.getSelectedRecipe().ifPresent(recipe -> {
                recipe.assemble(AutoMechanicTableScreenHandler.this.inputInv);
                stack.method_7909().method_7843(stack, player.method_37908(), player);
                AutoMechanicTableScreenHandler.this.updateRecipeState();
            });
        }
    }
}

