/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.railwayteam.railways.registry.CRBogeyStyles;
import com.railwayteam.railways.registry.CRSounds;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.CarriageSounds;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.class_1101;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CarriageSounds.class})
public class MixinCarriageSounds {
    @Shadow(remap=false)
    LerpedFloat seatCrossfade;
    @Unique
    private boolean railways$skip;
    @Unique
    private boolean railways$isHandcar;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void skipIfInvisible(CarriageContraptionEntity entity, CallbackInfo ci) {
        this.railways$skip = entity.getCarriage().bogeys.both(b -> b == null || b.getStyle() == CRBogeyStyles.INVISIBLE || b.getStyle() == CRBogeyStyles.INVISIBLE_MONOBOGEY);
        this.railways$isHandcar = entity.getCarriage().bogeys.both(b -> b == null || b.getStyle() == CRBogeyStyles.HANDCAR);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void actuallySkip(Carriage.DimensionalCarriageEntity dce, CallbackInfo ci) {
        if (this.railways$skip) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"tick", "submitSharedSoundVolume"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/AllSoundEvents$SoundEntry;getMainEvent()Lnet/minecraft/sounds/SoundEvent;")})
    private class_3414 useCogRumble(AllSoundEvents.SoundEntry instance, Operation<class_3414> original) {
        if (this.railways$isHandcar && instance == AllSoundEvents.TRAIN) {
            return (class_3414)CRSounds.HANDCAR_COGS.get();
        }
        return (class_3414)original.call(new Object[]{instance});
    }

    @WrapWithCondition(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/AllSoundEvents$SoundEntry;playAt(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;FFZ)V", ordinal=0), @At(value="INVOKE", target="Lcom/simibubi/create/AllSoundEvents$SoundEntry;playAt(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;FFZ)V", ordinal=1)}, remap=true)
    private boolean shouldPlaySteamSound(AllSoundEvents.SoundEntry instance, class_1937 world, class_243 pos, float volume, float pitch, boolean fade) {
        return instance != AllSoundEvents.STEAM || !this.railways$isHandcar;
    }

    @WrapWithCondition(method={"tick"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/AllSoundEvents$SoundEntry;playAt(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;FFZ)V", ordinal=2)}, remap=true)
    private boolean shouldPlaySteamReleaseSound(AllSoundEvents.SoundEntry instance, class_1937 world, class_243 pos, float volume, float pitch, boolean fade) {
        return instance != AllSoundEvents.STEAM || !this.railways$isHandcar;
    }

    @WrapWithCondition(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playLocalSound(DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZ)V")}, remap=true)
    private boolean shouldPlaySteamReleaseSound3(class_1937 instance, double x, double y, double z, class_3414 sound, class_3419 category, float volume, float pitch, boolean distanceDelay) {
        return !this.railways$isHandcar;
    }

    @WrapOperation(method={"finalizeSharedVolume"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/CarriageSounds$LoopingSound;setVolume(F)V", ordinal=0)})
    private void handcarNoCrossfade(@Coerce class_1101 instance, float volume, Operation<Void> original) {
        if (this.railways$isHandcar) {
            float crossfade = this.seatCrossfade.getValue();
            volume = (1.0f - crossfade * 0.125f) * volume * 1024.0f;
        }
        original.call(new Object[]{instance, Float.valueOf(volume)});
    }
}

