/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.common.systems;

import mirsario.cameraoverhaul.common.CameraOverhaul;
import mirsario.cameraoverhaul.common.configuration.ConfigData;
import mirsario.cameraoverhaul.core.callbacks.CameraUpdateCallback;
import mirsario.cameraoverhaul.core.callbacks.ModifyCameraTransformCallback;
import mirsario.cameraoverhaul.core.structures.Transform;
import mirsario.cameraoverhaul.core.utils.MathUtils;
import mirsario.cameraoverhaul.core.utils.Vec2fUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_4184;

public final class CameraSystem
implements CameraUpdateCallback,
ModifyCameraTransformCallback {
    private static double prevForwardVelocityPitchOffset;
    private static double prevVerticalVelocityPitchOffset;
    private static double prevStrafingRollOffset;
    private static double prevCameraYaw;
    private static double yawDeltaRollOffset;
    private static double yawDeltaRollTargetOffset;
    private static Transform offsetTransform;

    public CameraSystem() {
        CameraUpdateCallback.EVENT.Register(this);
        ModifyCameraTransformCallback.EVENT.Register(this);
        CameraOverhaul.Logger.info("CameraOverhaul: CameraSystem is ready.");
    }

    @Override
    public void OnCameraUpdate(class_1297 focusedEntity, class_4184 camera, Transform cameraTransform, float deltaTime) {
        boolean isFlying = false;
        boolean isSwimming = false;
        if (focusedEntity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)focusedEntity;
            isFlying = playerEntity.method_6128();
            isSwimming = playerEntity.method_5681();
        }
        CameraSystem.offsetTransform.position = new class_243(0.0, 0.0, 0.0);
        CameraSystem.offsetTransform.eulerRot = new class_243(0.0, 0.0, 0.0);
        ConfigData config = CameraOverhaul.instance.config;
        if (!config.enabled) {
            return;
        }
        float strafingRollFactorToUse = config.strafingRollFactor;
        if (isFlying) {
            strafingRollFactorToUse = config.strafingRollFactorWhenFlying;
        } else if (isSwimming) {
            strafingRollFactorToUse = config.strafingRollFactorWhenSwimming;
        }
        class_243 velocity = camera.method_19331().method_18798();
        class_241 relativeXZVelocity = Vec2fUtils.Rotate(new class_241((float)velocity.field_1352, (float)velocity.field_1350), 360.0f - (float)cameraTransform.eulerRot.field_1351);
        this.VerticalVelocityPitchOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.verticalVelocityPitchFactor, config.verticalVelocitySmoothingFactor);
        this.ForwardVelocityPitchOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.forwardVelocityPitchFactor, config.horizontalVelocitySmoothingFactor);
        this.YawDeltaRollOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, config.yawDeltaRollFactor * 1.25f, config.yawDeltaSmoothingFactor, config.yawDeltaDecayFactor);
        this.StrafingRollOffset(cameraTransform, offsetTransform, velocity, relativeXZVelocity, deltaTime, strafingRollFactorToUse, config.horizontalVelocitySmoothingFactor);
        prevCameraYaw = cameraTransform.eulerRot.field_1351;
    }

    @Override
    public Transform ModifyCameraTransform(class_4184 camera, Transform transform) {
        return new Transform(transform.position.method_1019(CameraSystem.offsetTransform.position), transform.eulerRot.method_1019(CameraSystem.offsetTransform.eulerRot));
    }

    private void VerticalVelocityPitchOffset(Transform inputTransform, Transform outputTransform, class_243 velocity, class_241 relativeXZVelocity, double deltaTime, float intensity, float smoothing) {
        double verticalVelocityPitchOffset = velocity.field_1351 * 2.75;
        if (velocity.field_1351 < 0.0) {
            verticalVelocityPitchOffset *= 2.25;
        }
        prevVerticalVelocityPitchOffset = verticalVelocityPitchOffset = MathUtils.Damp(prevVerticalVelocityPitchOffset, verticalVelocityPitchOffset, (double)smoothing, deltaTime);
        outputTransform.eulerRot = outputTransform.eulerRot.method_1031(verticalVelocityPitchOffset * (double)intensity, 0.0, 0.0);
    }

    private void ForwardVelocityPitchOffset(Transform inputTransform, Transform outputTransform, class_243 velocity, class_241 relativeXZVelocity, double deltaTime, float intensity, float smoothing) {
        double forwardVelocityPitchOffset = (double)relativeXZVelocity.field_1342 * 5.0;
        prevForwardVelocityPitchOffset = forwardVelocityPitchOffset = MathUtils.Damp(prevForwardVelocityPitchOffset, forwardVelocityPitchOffset, (double)smoothing, deltaTime);
        outputTransform.eulerRot = outputTransform.eulerRot.method_1031(forwardVelocityPitchOffset * (double)intensity, 0.0, 0.0);
    }

    private void YawDeltaRollOffset(Transform inputTransform, Transform outputTransform, class_243 velocity, class_241 relativeXZVelocity, double deltaTime, float intensity, float offsetSmoothing, float decaySmoothing) {
        double yawDelta = prevCameraYaw - inputTransform.eulerRot.field_1351;
        if (yawDelta > 180.0) {
            yawDelta = 360.0 - yawDelta;
        } else if (yawDelta < -180.0) {
            yawDelta = -360.0 - yawDelta;
        }
        yawDeltaRollOffset = MathUtils.Damp(yawDeltaRollOffset, yawDeltaRollTargetOffset += yawDelta * 0.07, (double)offsetSmoothing, deltaTime);
        outputTransform.eulerRot = outputTransform.eulerRot.method_1031(0.0, 0.0, yawDeltaRollOffset * (double)intensity);
        yawDeltaRollTargetOffset = MathUtils.Damp(yawDeltaRollTargetOffset, 0.0, (double)decaySmoothing, deltaTime);
    }

    private void StrafingRollOffset(Transform inputTransform, Transform outputTransform, class_243 velocity, class_241 relativeXZVelocity, double deltaTime, float intensity, float smoothing) {
        double strafingRollOffset = (double)(-relativeXZVelocity.field_1343) * 15.0;
        prevStrafingRollOffset = strafingRollOffset = MathUtils.Damp(prevStrafingRollOffset, strafingRollOffset, (double)smoothing, deltaTime);
        outputTransform.eulerRot = outputTransform.eulerRot.method_1031(0.0, 0.0, strafingRollOffset * (double)intensity);
    }

    static {
        offsetTransform = new Transform();
    }
}

