/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.entity.DieselGeneratorValueBox;
import com.jesz.createdieselgenerators.compat.computercraft.CCProxy;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.jesz.createdieselgenerators.other.FuelTypeManager;
import com.jesz.createdieselgenerators.sounds.SoundRegistry;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class DieselGeneratorBlockEntity
extends GeneratingKineticBlockEntity
implements SidedStorageBlockEntity {
    public SmartFluidTankBehaviour tank;
    int partialSecond;
    class_2680 state;
    public boolean validFuel;
    public AbstractComputerBehaviour computerBehaviour;
    public ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    int t = 0;

    public DieselGeneratorBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.state = state;
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        if (this.state.method_11654((class_2769)DieselGeneratorBlock.FACING) == class_2350.field_11033) {
            if (face == class_2350.field_11039) {
                return this.tank.getCapability();
            }
            if (face == class_2350.field_11034) {
                return this.tank.getCapability();
            }
        } else if (this.state.method_11654((class_2769)DieselGeneratorBlock.FACING) == class_2350.field_11036) {
            if (face == class_2350.field_11043) {
                return this.tank.getCapability();
            }
            if (face == class_2350.field_11035) {
                return this.tank.getCapability();
            }
        } else if (face == class_2350.field_11033) {
            return this.tank.getCapability();
        }
        if (face != class_2350.field_11033) {
            return this.tank.getCapability();
        }
        return null;
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("PartialSecond", this.partialSecond);
        this.tank.write(compound, false);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.partialSecond = compound.method_10550("PartialSecond");
        this.tank.read(compound, false);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.computerBehaviour = CCProxy.behaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.computerBehaviour);
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (class_2561)Lang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new DieselGeneratorValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (long)1000L);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void onDirectionChanged() {
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float calculateAddedStressCapacity() {
        if (this.getGeneratedSpeed() == 0.0f || ((Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.POWERED)).booleanValue()) {
            return 0.0f;
        }
        return FuelTypeManager.getGeneratedStress((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()) / Math.abs(this.getGeneratedSpeed());
    }

    public float getGeneratedSpeed() {
        if (((Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.POWERED)).booleanValue()) {
            return 0.0f;
        }
        return DieselGeneratorBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * FuelTypeManager.getGeneratedSpeed((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid())), (class_2350)((class_2350)this.method_11010().method_11654((class_2769)DieselGeneratorBlock.FACING))) * ((Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.TURBOCHARGED) != false ? ((Double)ConfigRegistry.TURBOCHARGED_ENGINE_MULTIPLIER.get()).floatValue() : 1.0f);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!IRotate.StressImpact.isEnabled()) {
            return added;
        }
        float stressBase = this.calculateAddedStressCapacity();
        if (class_3532.method_15347((float)stressBase, (float)0.0f)) {
            return added;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability());
    }

    public void tick() {
        super.tick();
        this.state = this.method_11010();
        this.reActivateSource = true;
        if (this.field_11863.field_9236 && !((Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.SILENCED)).booleanValue()) {
            if ((Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.TURBOCHARGED) != false ? this.t > FuelTypeManager.getSoundSpeed(this.tank.getPrimaryHandler().getFluid().getFluid()) / 2 : this.t > FuelTypeManager.getSoundSpeed(this.tank.getPrimaryHandler().getFluid().getFluid())) {
                if (this.validFuel) {
                    this.t = 0;
                    this.field_11863.method_8486((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), SoundRegistry.DIESEL_ENGINE_SOUND.getMainEvent(), class_3419.field_15245, (Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.TURBOCHARGED) != false ? 0.5f : 0.3f, (Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.TURBOCHARGED) != false ? 1.1f : 1.0f, false);
                }
            } else {
                ++this.t;
            }
        }
        this.validFuel = (Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.POWERED) != false ? false : FuelTypeManager.getGeneratedSpeed((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()) != 0.0f;
        ++this.partialSecond;
        if (this.partialSecond >= 20) {
            this.partialSecond = 0;
            if (this.validFuel) {
                float f = this.tank.getPrimaryHandler().getFluid().getAmount();
                float f2 = FuelTypeManager.getBurnRate((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid());
                float f3 = (Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.TURBOCHARGED) == false ? 1.0f : ((Double)ConfigRegistry.TURBOCHARGED_ENGINE_BURN_RATE_MULTIPLIER.get()).floatValue();
                if (f >= f2 * f3) {
                    this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)this.tank.getPrimaryHandler().getFluid(), (long)((int)((float)this.tank.getPrimaryHandler().getFluid().getAmount() - (float)FuelTypeManager.getBurnRate((class_2586)this, this.tank.getPrimaryHandler().getFluid().getFluid()) * ((Boolean)this.state.method_11654((class_2769)DieselGeneratorBlock.TURBOCHARGED) == false ? 1.0f : ((Double)ConfigRegistry.TURBOCHARGED_ENGINE_BURN_RATE_MULTIPLIER.get()).floatValue())))));
                } else {
                    this.tank.getPrimaryHandler().setFluid(FluidStack.EMPTY);
                }
            }
        }
    }
}

