/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.renderer;

import com.jesz.createdieselgenerators.PartialModels;
import com.jesz.createdieselgenerators.blocks.entity.PumpjackBearingBlockEntity;
import com.jesz.createdieselgenerators.blocks.entity.PumpjackCrankBlockEntity;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class PumpjackCrankRenderer
extends ShaftRenderer<PumpjackCrankBlockEntity> {
    public PumpjackCrankRenderer(class_5614.class_5615 context) {
        super(context);
    }

    protected void renderSafe(PumpjackCrankBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (Backend.canUseInstancing((class_1937)be.method_10997())) {
            return;
        }
        class_2680 blockState = be.method_11010();
        class_2338 pos = be.method_11016();
        float angle = AngleHelper.angleLerp((double)partialTicks, (double)be.prevAngle, (double)be.angle);
        boolean isXAxis = ((class_2350)blockState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_10166() == class_2350.class_2351.field_11048;
        double v = (double)(((isXAxis ? angle : -angle) + 90.0f) / 180.0f) * Math.PI;
        double sin = Math.sin(v) * (be.crankSize.getValue() == 0 ? 0.8125 : 1.125);
        double cos = Math.cos(v) * (be.crankSize.getValue() == 0 ? 0.8125 : 1.125);
        SuperByteBuffer crank = CachedBufferer.partial((PartialModel)(be.crankSize.getValue() == 0 ? PartialModels.PUMPJACK_CRANK_SMALL : PartialModels.PUMPJACK_CRANK_LARGE), (class_2680)blockState);
        SuperByteBuffer rod = CachedBufferer.partial((PartialModel)(be.crankSize.getValue() == 0 ? PartialModels.PUMPJACK_CRANK_ROD_SMALL : PartialModels.PUMPJACK_CRANK_ROD_LARGE), (class_2680)blockState);
        if (be.bearingPos == null) {
            if (isXAxis) {
                crank.translate(0.5, 1.25, 0.0).rotateZ((double)angle);
            } else {
                ((SuperByteBuffer)crank.translate(0.0, 1.25, 0.5).rotateY(90.0)).rotateZ((double)angle);
            }
            double dstY = -1000.0 - sin - 1.25 - (double)pos.method_10264();
            double dstX = (double)pos.method_10263() - cos - 0.5 - (double)pos.method_10263();
            double dstZ = (double)pos.method_10260() - cos - 0.5 - (double)pos.method_10260();
            if (isXAxis) {
                rod.translate(0.5, 1.25, 0.0).translate(cos, sin, 0.0).rotateZ(Math.atan2(dstY, dstX) * 180.0 / Math.PI - 90.0);
            } else {
                ((SuperByteBuffer)rod.translate(0.0, 1.25, 0.5).translate(0.0, sin, cos).rotateY(90.0)).rotateZ(Math.atan2(dstZ, dstY) * 180.0 / Math.PI);
            }
            rod.renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
            crank.renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
            super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
            return;
        }
        PumpjackBearingBlockEntity bearing = (PumpjackBearingBlockEntity)((Object)be.bearing.get());
        float interpolatedAngle = 0.0f;
        if (bearing != null) {
            interpolatedAngle = bearing.getInterpolatedAngle(partialTicks);
        }
        if (!isXAxis) {
            interpolatedAngle *= -1.0f;
        }
        class_241 crankBearingLocation = new class_241((float)(be.crankBearingLocation.field_1352 * Math.cos((double)(interpolatedAngle / 180.0f) * Math.PI) - be.crankBearingLocation.field_1351 * Math.sin((double)(interpolatedAngle / 180.0f) * Math.PI)) + 0.5f, (float)(be.crankBearingLocation.field_1352 * Math.sin((double)(interpolatedAngle / 180.0f) * Math.PI) + be.crankBearingLocation.field_1351 * Math.cos((double)(interpolatedAngle / 180.0f) * Math.PI)) + 0.5f);
        crankBearingLocation = isXAxis ? crankBearingLocation.method_35586(new class_241((float)be.bearingPos.method_10263(), (float)be.bearingPos.method_10264())) : crankBearingLocation.method_35586(new class_241((float)be.bearingPos.method_10260(), (float)be.bearingPos.method_10264()));
        if (isXAxis) {
            crank.translate(0.5, 1.25, 0.0).rotateZ((double)angle);
        } else {
            ((SuperByteBuffer)crank.translate(0.0, 1.25, 0.5).rotateY(90.0)).rotateZ((double)angle);
        }
        double dstY = (double)crankBearingLocation.field_1342 - sin - 1.25 - (double)pos.method_10264();
        double dstX = (double)crankBearingLocation.field_1343 - cos - 0.5 - (double)pos.method_10263();
        double dstZ = (double)crankBearingLocation.field_1343 - cos - 0.5 - (double)pos.method_10260();
        if (isXAxis) {
            rod.translate(0.5, 1.25, 0.0).translate(cos, sin, 0.0).rotateZ(Math.atan2(dstY, dstX) * 180.0 / Math.PI - 90.0);
        } else {
            ((SuperByteBuffer)rod.translate(0.0, 1.25, 0.5).translate(0.0, sin, cos).rotateY(90.0)).rotateZ(Math.atan2(dstZ, dstY) * 180.0 / Math.PI);
        }
        rod.light(light);
        crank.light(light);
        rod.renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
        crank.renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
    }
}

