/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import juuxel.adorn.block.entity.TradingStationBlockEntity;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.ColorsKt;
import juuxel.adorn.util.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_824;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJW\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001f\u001a\n \u001b*\u0004\u0018\u00010\u001e0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 \u00a8\u0006&"}, d2={"Ljuuxel/adorn/client/renderer/TradingStationRenderer;", "Lnet/minecraft/class_827;", "Ljuuxel/adorn/block/entity/TradingStationBlockEntity;", "be", "", "tickDelta", "Lnet/minecraft/class_4587;", "matrices", "Lnet/minecraft/class_4597;", "vertexConsumers", "", "light", "overlay", "", "render", "(Ljuuxel/adorn/block/entity/TradingStationBlockEntity;FLnet/minecraft/class_4587;Lnet/minecraft/class_4597;II)V", "Lnet/minecraft/class_2586;", "Lnet/minecraft/class_2561;", "label", "", "x", "y", "z", "maxDistance", "renderLabel", "(Lnet/minecraft/class_2586;Lnet/minecraft/class_2561;DDDILnet/minecraft/class_4587;Lnet/minecraft/class_4597;I)V", "Lnet/minecraft/class_824;", "kotlin.jvm.PlatformType", "dispatcher", "Lnet/minecraft/class_824;", "Lnet/minecraft/class_327;", "textRenderer", "Lnet/minecraft/class_327;", "Lnet/minecraft/class_5614$class_5615;", "context", "<init>", "(Lnet/minecraft/class_5614$class_5615;)V", "Companion", "Adorn"})
@Environment(value=EnvType.CLIENT)
public final class TradingStationRenderer
implements class_827<TradingStationBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final class_824 dispatcher;
    private final class_327 textRenderer;
    private static final float SELLING_ROTATION_MULTIPLIER = 1.2f;
    @NotNull
    private static final String OWNER_LABEL = "block.adorn.trading_station.label.owner";
    @NotNull
    private static final String SELLING_LABEL = "block.adorn.trading_station.label.selling";
    @NotNull
    private static final String PRICE_LABEL = "block.adorn.trading_station.label.price";

    public TradingStationRenderer(@NotNull class_5614.class_5615 context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.dispatcher = context2.method_32139();
        this.textRenderer = context2.method_32143();
    }

    public void render(@NotNull TradingStationBlockEntity be, float tickDelta, @NotNull class_4587 matrices, @NotNull class_4597 vertexConsumers, int light, int overlay) {
        Object[] itemRenderer;
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        class_239 hitResult = this.dispatcher.field_4350;
        boolean lookingAtBlock = hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332 && Intrinsics.areEqual((Object)be.method_11016(), (Object)((class_3965)hitResult).method_17777());
        Trade trade = be.getTrade();
        if (!trade.isEmpty()) {
            matrices.method_22903();
            matrices.method_22904(0.5, 1.2, 0.5);
            class_746 class_7462 = class_310.method_1551().field_1724;
            Intrinsics.checkNotNull((Object)class_7462);
            int playerAge = class_7462.field_6012;
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(((float)playerAge + tickDelta) * 1.2f));
            matrices.method_22905(0.6f, 0.6f, 0.6f);
            matrices.method_22904(0.0, 0.3, 0.0);
            itemRenderer = class_310.method_1551().method_1480();
            itemRenderer.method_23178(trade.getSelling(), class_811.field_4319, light, overlay, matrices, vertexConsumers, be.method_10997(), 0);
            matrices.method_22909();
            matrices.method_22909();
        }
        if (lookingAtBlock && ConfigManager.Companion.config().client.showTradingStationTooltips) {
            itemRenderer = new Object[]{be.getOwnerName().method_27661().method_27692(class_124.field_1065)};
            class_5250 label1 = class_2561.method_43469((String)OWNER_LABEL, (Object[])itemRenderer);
            class_2586 class_25862 = be;
            Intrinsics.checkNotNullExpressionValue((Object)label1, (String)"label1");
            this.renderLabel(class_25862, (class_2561)label1, 0.0, 0.9, 0.0, 12, matrices, vertexConsumers, light);
            if (!be.getTrade().isEmpty()) {
                Object[] objectArray = new Object[]{ExtensionsKt.toTextWithCount(be.getTrade().getSelling())};
                class_5250 label2 = class_2561.method_43469((String)SELLING_LABEL, (Object[])objectArray);
                Object[] objectArray2 = new Object[]{ExtensionsKt.toTextWithCount(be.getTrade().getPrice())};
                class_5250 label3 = class_2561.method_43469((String)PRICE_LABEL, (Object[])objectArray2);
                class_2586 class_25863 = be;
                Intrinsics.checkNotNullExpressionValue((Object)label2, (String)"label2");
                this.renderLabel(class_25863, (class_2561)label2, 0.0, 0.65, 0.0, 12, matrices, vertexConsumers, light);
                class_2586 class_25864 = be;
                Intrinsics.checkNotNullExpressionValue((Object)label3, (String)"label3");
                this.renderLabel(class_25864, (class_2561)label3, 0.0, 0.4, 0.0, 12, matrices, vertexConsumers, light);
            }
        }
    }

    private final void renderLabel(class_2586 be, class_2561 label, double x, double y, double z, int maxDistance, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_4184 camera = this.dispatcher.field_4344;
        double dist = ExtensionsKt.getSquaredDistance(be, camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350);
        if (dist < (double)(maxDistance * maxDistance)) {
            matrices.method_22903();
            matrices.method_22904(x + 0.5, y + 1.5, z + 0.5);
            matrices.method_22907(camera.method_23767());
            matrices.method_22905(-0.025f, -0.025f, 0.025f);
            Matrix4f positionMatrix = matrices.method_23760().method_23761();
            float opacity = class_310.method_1551().field_1690.method_19343(0.25f);
            int backgroundColor = ColorsKt.color(0, opacity);
            float textX = (float)(-this.textRenderer.method_27525((class_5348)label)) * 0.5f;
            this.textRenderer.method_30882(label, textX, 0.0f, Colors.INSTANCE.getWHITE(), false, positionMatrix, vertexConsumers, class_327.class_6415.field_33993, backgroundColor, light);
            matrices.method_22909();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Ljuuxel/adorn/client/renderer/TradingStationRenderer$Companion;", "", "", "OWNER_LABEL", "Ljava/lang/String;", "PRICE_LABEL", "SELLING_LABEL", "", "SELLING_ROTATION_MULTIPLIER", "F", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

