/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataEntry;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class DataHolder {
    Map<SyncedDataKey<?, ?>, DataEntry<?, ?>> dataMap = new HashMap();
    private boolean dirty = false;

    <E extends class_1297, T> boolean set(E entity, SyncedDataKey<?, ?> key, T value) {
        DataEntry entry = this.dataMap.computeIfAbsent(key, DataEntry::new);
        if (!entry.getValue().equals(value)) {
            boolean dirty = !entity.method_37908().method_8608() && entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE;
            entry.setValue(value, dirty);
            this.dirty = dirty;
            return true;
        }
        return false;
    }

    @Nullable
    <E extends class_1297, T> T get(SyncedDataKey<E, T> key) {
        return this.dataMap.computeIfAbsent(key, DataEntry::new).getValue();
    }

    boolean isDirty() {
        return this.dirty;
    }

    void clean() {
        this.dirty = false;
        this.dataMap.forEach((key, entry) -> entry.clean());
    }

    List<DataEntry<?, ?>> gatherDirty() {
        return this.dataMap.values().stream().filter(DataEntry::isDirty).filter(entry -> entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE).collect(Collectors.toList());
    }

    List<DataEntry<?, ?>> gatherAll() {
        return this.dataMap.values().stream().filter(entry -> entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE).collect(Collectors.toList());
    }

    public class_2499 serialize() {
        class_2499 list = new class_2499();
        this.dataMap.forEach((key, entry) -> {
            if (key.save()) {
                class_2487 keyTag = new class_2487();
                keyTag.method_10582("ClassKey", key.classKey().id().toString());
                keyTag.method_10582("DataKey", key.id().toString());
                keyTag.method_10566("Value", entry.writeValue());
                list.add((Object)keyTag);
            }
        });
        return list;
    }

    public void deserialize(class_2499 listTag) {
        this.dataMap.clear();
        listTag.forEach(entryTag -> {
            class_2487 keyTag = (class_2487)entryTag;
            class_2960 classKey = class_2960.method_12829((String)keyTag.method_10558("ClassKey"));
            class_2960 dataKey = class_2960.method_12829((String)keyTag.method_10558("DataKey"));
            class_2520 value = keyTag.method_10580("Value");
            SyncedClassKey<?> syncedClassKey = SyncedEntityData.instance().getClassKey(classKey);
            if (syncedClassKey == null) {
                return;
            }
            Map<class_2960, SyncedDataKey<?, ?>> keys = SyncedEntityData.instance().getDataKeys(syncedClassKey);
            if (keys == null) {
                return;
            }
            SyncedDataKey<?, ?> syncedDataKey = keys.get(dataKey);
            if (syncedDataKey == null || !syncedDataKey.save()) {
                return;
            }
            DataEntry entry = new DataEntry(syncedDataKey);
            entry.readValue(value);
            this.dataMap.put(syncedDataKey, entry);
        });
    }
}

