/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.handshake;

import com.mrcrayfish.framework.api.data.login.ILoginData;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.HandshakeMessage;
import com.mrcrayfish.framework.network.LoginDataManager;
import com.mrcrayfish.framework.platform.Services;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.CountDownLatch;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class S2CLoginData
extends HandshakeMessage<S2CLoginData> {
    private class_2960 id;
    private class_2540 data;

    public S2CLoginData() {
    }

    public S2CLoginData(class_2960 id, class_2540 data) {
        this.id = id;
        this.data = data;
    }

    @Override
    public void encode(S2CLoginData message, class_2540 buffer) {
        buffer.method_10812(message.id);
        buffer.method_10804(message.data.readableBytes());
        buffer.writeBytes((ByteBuf)message.data);
    }

    @Override
    public S2CLoginData decode(class_2540 buffer) {
        class_2960 id = buffer.method_10810();
        int readableBytes = buffer.method_10816();
        class_2540 data = new class_2540(Unpooled.wrappedBuffer((ByteBuf)buffer.readBytes(readableBytes)));
        return new S2CLoginData(id, data);
    }

    @Override
    public void handle(S2CLoginData message, MessageContext context) {
        String[] response = new String[1];
        CountDownLatch block = new CountDownLatch(1);
        context.execute(() -> {
            ILoginData data = LoginDataManager.getLoginDataSupplier(message.id).get();
            data.readData(message.data).ifPresent(s -> {
                response[0] = s;
            });
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (response[0] != null) {
            String modName = Services.PLATFORM.getModName(message.id.method_12836());
            context.getNetworkManager().method_10747((class_2561)class_2561.method_43470((String)("Connection closed - [" + modName + "] " + response[0])));
            return;
        }
        context.setHandled(true);
        context.reply(new HandshakeMessage.Acknowledge());
    }
}

