/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity.inventory;

import com.google.common.collect.Iterators;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerSlot;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import io.github.fabricators_of_create.porting_lib.util.DualSortedSetIterator;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class CookingPotItemHandler
implements SlottedStackStorage {
    private static final int SLOTS_INPUT = 6;
    private static final int SLOT_CONTAINER_INPUT = 7;
    private static final int SLOT_MEAL_OUTPUT = 8;
    private final ItemStackHandlerContainer itemHandler;
    private final class_2350 side;

    public CookingPotItemHandler(ItemStackHandlerContainer itemHandler, @Nullable class_2350 side) {
        this.itemHandler = itemHandler;
        this.side = side;
    }

    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return this.isItemValid(slot, ItemVariant.of((class_1799)stack), 1);
    }

    public int getSlotCount() {
        return this.itemHandler.getSlotCount();
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return this.itemHandler.getSlot(slot);
    }

    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return slot < 6 ? ItemUtils.insertItem(this.itemHandler, slot, stack, simulate) : stack;
        }
        return slot == 7 ? ItemUtils.insertItem(this.itemHandler, slot, stack, simulate) : stack;
    }

    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return slot < 6 ? this.itemHandler.method_5434(slot, amount) : class_1799.field_8037;
        }
        return slot == 8 ? this.itemHandler.method_5434(slot, amount) : class_1799.field_8037;
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    @NotNull
    public class_1799 getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        ItemStackHandlerSlot slot;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long inserted = 0L;
        Iterator<ItemStackHandlerSlot> itr = this.getInsertableSlotsFor(resource);
        while (itr.hasNext() && (inserted += (slot = itr.next()).insert(resource, maxAmount - inserted, transaction)) < maxAmount) {
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        ItemStackHandlerSlot slot;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long extracted = 0L;
        Iterator iterator = this.getSlotsContaining(resource.getItem(), true).iterator();
        while (iterator.hasNext() && (extracted += (slot = (ItemStackHandlerSlot)iterator.next()).extract(resource, maxAmount - extracted, transaction)) < maxAmount) {
        }
        return extracted;
    }

    private Iterator<ItemStackHandlerSlot> getInsertableSlotsFor(ItemVariant resource) {
        SortedSet<ItemStackHandlerSlot> slots = this.getSlotsContaining(resource.getItem(), false);
        SortedSet<ItemStackHandlerSlot> emptySlots = this.getSlotsContaining(class_1802.field_8162, false);
        if (slots.isEmpty()) {
            return emptySlots.isEmpty() ? Collections.emptyIterator() : emptySlots.iterator();
        }
        return emptySlots.isEmpty() ? slots.iterator() : new DualSortedSetIterator(slots, emptySlots);
    }

    private SortedSet<ItemStackHandlerSlot> getSlotsContaining(class_1792 item, boolean output) {
        return (SortedSet)this.itemHandler.getSlotsContaining(item).stream().filter(storageViews -> this.isValidInputSlot(storageViews.getIndex(), output)).collect(Collectors.toCollection(() -> new ObjectAVLTreeSet(Comparator.comparingInt(ItemStackHandlerSlot::getIndex))));
    }

    private boolean isValidInputSlot(int slot, boolean output) {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return slot < 6;
        }
        return output ? slot == 8 : slot == 7;
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return slot < 6 ? this.itemHandler.insertSlot(slot, resource, maxAmount, transaction) : 0L;
        }
        return slot == 7 ? this.itemHandler.insertSlot(slot, resource, maxAmount, transaction) : 0L;
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return slot < 6 ? this.itemHandler.extractSlot(slot, resource, maxAmount, transaction) : 0L;
        }
        return slot == 8 ? this.itemHandler.extractSlot(slot, resource, maxAmount, transaction) : 0L;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return Iterators.filter((Iterator)this.itemHandler.iterator(), input -> {
            if (!(input instanceof ItemStackHandlerSlot)) {
                return false;
            }
            ItemStackHandlerSlot slot = (ItemStackHandlerSlot)input;
            if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
                return slot.getIndex() < 6;
            }
            return slot.getIndex() == 8;
        });
    }
}

