/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import net.minecraft.class_2540;
import net.minecraft.class_4093;
import xaero.pac.common.packet.PacketHandlerFabric;
import xaero.pac.common.packet.PacketType;

public abstract class PacketReceiver<C> {
    private final PacketHandlerFabric packetHandlerFabric;

    public PacketReceiver(PacketHandlerFabric packetHandlerFabric) {
        this.packetHandlerFabric = packetHandlerFabric;
    }

    private PacketType<?> getPacketType(class_2540 buf) {
        if (buf.readableBytes() > 0) {
            byte index = buf.readByte();
            return this.packetHandlerFabric.getPacketTypeByIndex(index);
        }
        return null;
    }

    protected void receive(class_4093<?> executor, class_2540 buf, C context) {
        this.receive(executor, this.getPacketType(buf), buf, context);
    }

    private <T> void receive(class_4093<?> executor, PacketType<T> packetType, class_2540 buf, C context) {
        if (packetType != null) {
            T packet = packetType.getDecoder().apply(buf);
            if (this.isCorrectSide(packetType)) {
                executor.execute(this.getTask(packetType, packet, context));
            }
        }
    }

    protected abstract <T> boolean isCorrectSide(PacketType<T> var1);

    protected abstract <T> Runnable getTask(PacketType<T> var1, T var2, C var3);
}

