/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection;

import com.mojang.datafixers.util.Either;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.server.claims.protection.ExceptionElementType;

public final class ChunkProtectionExceptionSet<T> {
    private final Set<T> exceptions;
    private final Set<T> tagBasedExceptions;
    private final Set<class_6862<T>> exceptionTags;
    private final ExceptionElementType<T> elementType;

    private ChunkProtectionExceptionSet(Set<T> exceptions, Set<T> tagBasedExceptions, Set<class_6862<T>> exceptionTags, ExceptionElementType<T> elementType) {
        this.exceptions = exceptions;
        this.tagBasedExceptions = tagBasedExceptions;
        this.exceptionTags = exceptionTags;
        this.elementType = elementType;
    }

    public boolean contains(T object) {
        return this.exceptions.contains(object) || this.tagBasedExceptions.contains(object);
    }

    public void updateTagExceptions(MinecraftServer server) {
        this.tagBasedExceptions.clear();
        class_2378 elementRegistry = this.elementType.getRegistry(server);
        this.exceptionTags.stream().flatMap(tag -> elementRegistry.method_40266(tag).stream().flatMap(class_6885.class_6887::method_40239).map(class_6880::comp_349)).forEach(this.tagBasedExceptions::add);
    }

    public Stream<Either<T, class_6862<T>>> stream() {
        return Stream.concat(this.exceptions.stream().map(Either::left), this.exceptionTags.stream().map(Either::right));
    }

    public ExceptionElementType<T> getElementType() {
        return this.elementType;
    }

    public static class Builder<T> {
        private final Set<T> exceptions = new HashSet<T>();
        private final Set<class_6862<T>> exceptionTags = new HashSet<class_6862<T>>();
        private final ExceptionElementType<T> elementType;

        private Builder(ExceptionElementType<T> elementType) {
            this.elementType = elementType;
        }

        public Builder<T> setDefault() {
            this.exceptions.clear();
            this.exceptionTags.clear();
            return this;
        }

        public Builder<T> add(T exception) {
            this.exceptions.add(exception);
            return this;
        }

        public Builder<T> addTag(class_6862<T> exceptionTag) {
            this.exceptionTags.add(exceptionTag);
            return this;
        }

        public Builder<T> addEither(Either<T, class_6862<T>> eitherException) {
            eitherException.left().ifPresent(this.exceptions::add);
            eitherException.right().ifPresent(this.exceptionTags::add);
            return this;
        }

        public ChunkProtectionExceptionSet<T> build() {
            return new ChunkProtectionExceptionSet<T>(this.exceptions, new HashSet(), this.exceptionTags, this.elementType);
        }

        public static <T> Builder<T> begin(ExceptionElementType<T> elementType) {
            return new Builder<T>(elementType).setDefault();
        }
    }
}

