/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILootClient;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.ClientGameplayLootTable;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class GameplayLootRecipe
implements EmiRecipe {
    private final ClientGameplayLootTable loot;
    private final List<EmiStack> outputStacks;
    private final class_2561 name;
    private final List<WidgetRowBuilder> rowBuilderList = new LinkedList<WidgetRowBuilder>();

    public GameplayLootRecipe(ClientGameplayLootTable loot) {
        this.loot = loot;
        loot.build((class_1937)class_310.method_1551().field_1687, class_2246.field_10124);
        LinkedList<EmiStack> list = new LinkedList<EmiStack>();
        loot.builtItems.forEach(builtPool -> {
            builtPool.stackMap().forEach((weight, stacks) -> list.addAll(stacks.getEmiStacks()));
            this.addWidgetBuilders((ClientBuiltPool)builtPool, false);
        });
        this.outputStacks = list;
        String key = "emi_loot.gameplay." + loot.id.toString();
        class_5250 text = LText.translatable(key);
        if (Objects.equals(text.getString(), key)) {
            Optional modNameOpt = FabricLoader.getInstance().getModContainer(loot.id.method_12836());
            if (modNameOpt.isPresent()) {
                ModContainer modContainer = (ModContainer)modNameOpt.get();
                String modName = modContainer.getMetadata().getName();
                this.name = LText.translatable("emi_loot.gameplay.unknown_gameplay", modName);
            } else {
                class_5250 unknown = LText.translatable("emi_loot.gameplay.unknown");
                this.name = LText.translatable("emi_loot.gameplay.unknown_gameplay", unknown.getString());
            }
        } else {
            this.name = text;
        }
    }

    private void addWidgetBuilders(ClientBuiltPool newPool, boolean recursive) {
        if (recursive || this.rowBuilderList.isEmpty()) {
            this.rowBuilderList.add(new WidgetRowBuilder(154));
        }
        boolean added = false;
        for (WidgetRowBuilder builder : this.rowBuilderList) {
            if (!builder.canAddPool(newPool)) continue;
            builder.addAndTrim(newPool);
            added = true;
            break;
        }
        if (!added) {
            Optional<ClientBuiltPool> opt = this.rowBuilderList.get(this.rowBuilderList.size() - 1).addAndTrim(newPool);
            opt.ifPresent(clientMobBuiltPool -> this.addWidgetBuilders((ClientBuiltPool)clientMobBuiltPool, true));
        }
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.GAMEPLAY_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return new class_2960(EMILootClient.MOD_ID, "/" + this.getCategory().id.method_12832() + "/" + this.loot.id.method_12836() + "/" + this.loot.id.method_12832());
    }

    public List<EmiIngredient> getInputs() {
        return new LinkedList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks;
    }

    public int getDisplayWidth() {
        return 154;
    }

    public int getDisplayHeight() {
        return this.rowBuilderList.size() * 29 + 11;
    }

    public void addWidgets(WidgetHolder widgets) {
        int x = 0;
        int y = 0;
        widgets.addText(this.name.method_30937(), 0, 0, 0x404040, false);
        y += 11;
        for (WidgetRowBuilder builder : this.rowBuilderList) {
            for (ClientBuiltPool pool : builder.getPoolList()) {
                IconGroupEmiWidget widget = new IconGroupEmiWidget(x, y, pool);
                widgets.add((Widget)widget);
                x += widget.getWidth() + 6;
            }
            y += 29;
            x = 0;
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

