/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootClient;
import fzzyhmstrs.emi_loot.client.ClientBuiltPool;
import fzzyhmstrs.emi_loot.client.ClientMobLootTable;
import fzzyhmstrs.emi_loot.client.ClientResourceData;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.EntityEmiStack;
import fzzyhmstrs.emi_loot.util.IconGroupEmiWidget;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.WidgetRowBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1472;
import net.minecraft.class_1621;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MobLootRecipe
implements EmiRecipe {
    private static final class_2960 ARROW_ID = new class_2960(EMILoot.MOD_ID, "textures/gui/downturn_arrow.png");
    private final ClientMobLootTable loot;
    private final EmiStack inputStack;
    private final List<EmiStack> outputStacks;
    private final class_2561 name;
    private final class_1299<?> type;
    private final List<WidgetRowBuilder> rowBuilderList = new LinkedList<WidgetRowBuilder>();

    public MobLootRecipe(ClientMobLootTable loot) {
        class_1299 type;
        this.loot = loot;
        loot.build((class_1937)class_310.method_1551().field_1687, class_2246.field_10124);
        class_2960 mobId = loot.mobId;
        this.type = type = (class_1299)class_7923.field_41177.method_10223(mobId);
        class_310 client = class_310.method_1551();
        class_1297 entity = type.method_5883((class_1937)client.field_1687);
        if (entity != null) {
            class_238 box = entity.method_5829();
            double len = box.method_995();
            if (len > 1.05) {
                len = (len + Math.sqrt(len)) / 2.0;
            }
            if (entity instanceof class_1621) {
                ((class_1621)entity).method_7161(5, false);
            }
            if (entity instanceof class_1472 && !Objects.equals(loot.color, "")) {
                class_1767 color = class_1767.method_7793((String)loot.color, (class_1767)class_1767.field_7952);
                class_5250 colorName = LText.translatable("color.minecraft." + color.method_7792());
                this.name = LText.translatable("emi_loot.color_name", colorName.getString(), entity.method_5477().getString());
                ((class_1472)entity).method_6631(color);
            } else {
                this.name = entity.method_5477();
            }
            double scale = 1.05 / len * 8.0;
            if (ClientResourceData.MOB_SCALES.containsKey((Object)type)) {
                scale *= (double)ClientResourceData.MOB_SCALES.getOrDefault((Object)type, 1.0f);
            }
            this.inputStack = EntityEmiStack.ofScaled(entity, scale);
        } else {
            this.inputStack = EmiStack.EMPTY;
            this.name = LText.translatable("emi_loot.missing_entity");
        }
        LinkedList<EmiStack> list = new LinkedList<EmiStack>();
        loot.builtItems.forEach(builtPool -> {
            builtPool.stackMap().forEach((weight, stacks) -> list.addAll(stacks.getEmiStacks()));
            this.addWidgetBuilders((ClientBuiltPool)builtPool, false);
        });
        this.outputStacks = list;
    }

    private void addWidgetBuilders(ClientBuiltPool newPool, boolean recursive) {
        if (recursive || this.rowBuilderList.isEmpty()) {
            this.rowBuilderList.add(new WidgetRowBuilder(154));
        }
        boolean added = false;
        for (WidgetRowBuilder builder : this.rowBuilderList) {
            if (!builder.canAddPool(newPool)) continue;
            builder.addAndTrim(newPool);
            added = true;
            break;
        }
        if (!added) {
            Optional<ClientBuiltPool> opt = this.rowBuilderList.get(this.rowBuilderList.size() - 1).addAndTrim(newPool);
            opt.ifPresent(clientMobBuiltPool -> this.addWidgetBuilders((ClientBuiltPool)clientMobBuiltPool, true));
        }
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.MOB_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return new class_2960(EMILootClient.MOD_ID, "/" + this.getCategory().id.method_12832() + "/" + this.loot.id.method_12836() + "/" + this.loot.id.method_12832());
    }

    public List<EmiIngredient> getInputs() {
        return new LinkedList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputStacks;
    }

    public int getDisplayWidth() {
        return 154;
    }

    public int getDisplayHeight() {
        if (this.rowBuilderList.size() > 1 || this.rowBuilderList.get(0).getWidth() > 94) {
            return 51 + 29 * (this.rowBuilderList.size() - 1);
        }
        return 34;
    }

    public void addWidgets(WidgetHolder widgets) {
        int rowOffset = 29;
        int x = 0;
        int y = 0;
        if (!ClientResourceData.MOB_OFFSETS.containsKey(this.type)) {
            widgets.addSlot((EmiIngredient)this.inputStack, x, y).large(true);
        } else {
            int offset = ClientResourceData.MOB_OFFSETS.getOrDefault(this.type, 0);
            widgets.addTexture(EmiTexture.LARGE_SLOT, x, y);
            widgets.addDrawable(x, y, 16, 16, (matrices, mx, my, delta) -> this.inputStack.render(matrices, 5, 6 + offset, delta));
        }
        widgets.addText(this.name.method_30937(), 30, 0, 0x404040, false);
        if (this.rowBuilderList.size() == 1 && this.rowBuilderList.get(0).getWidth() <= 94) {
            widgets.addTexture(new EmiTexture(ARROW_ID, 0, 16, 39, 15, 39, 15, 64, 32), 30, 10);
            x = 60;
            y = 11;
            WidgetRowBuilder builder = this.rowBuilderList.get(0);
            for (ClientBuiltPool pool : builder.getPoolList()) {
                IconGroupEmiWidget widget = new IconGroupEmiWidget(x, y, pool);
                widgets.add((Widget)widget);
                x += widget.getWidth() + 6;
            }
        } else {
            widgets.addTexture(new EmiTexture(ARROW_ID, 0, 0, 39, 15, 39, 15, 64, 32), 30, 10);
            y += 28;
            for (WidgetRowBuilder builder : this.rowBuilderList) {
                for (ClientBuiltPool pool : builder.getPoolList()) {
                    IconGroupEmiWidget widget = new IconGroupEmiWidget(x, y, pool);
                    widgets.add((Widget)widget);
                    x += widget.getWidth() + 6;
                }
                y += 29;
                x = 0;
            }
        }
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

