/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.client.screens.BlackBoardScreen;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5253;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_6880;

public class BlackBoardButton
implements class_364,
class_4068,
class_6379 {
    private final BlackBoardScreen parent;
    public final int u;
    public final int v;
    public final int x;
    public final int y;
    public static final int SIZE = 6;
    protected boolean isHovered;
    protected byte color = 0;
    protected boolean focused;

    public BlackBoardButton(int centerX, int centerY, int u, int v, BlackBoardScreen screen, byte color) {
        this.x = centerX - (8 - u) * 6;
        this.y = centerY - -v * 6;
        this.u = u;
        this.v = v;
        this.parent = screen;
        this.color = color;
    }

    public void setColor(byte color) {
        this.parent.addHistory(this.u, this.v, this.color);
        this.color = color;
        this.parent.updateBlackboard(this.u, this.v, color);
    }

    public byte getColor() {
        return this.color;
    }

    public void method_25394(class_332 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.isHovered = this.method_25405(mouseX, mouseY);
        this.renderButton(poseStack);
    }

    public void renderButton(class_332 graphics) {
        int offset = this.color > 0 ? 16 : 0;
        int rgb = BlackboardBlock.colorFromByte(this.color);
        float b = (float)class_5253.class_5254.method_27767((int)rgb) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)rgb) / 255.0f;
        float r = (float)class_5253.class_5254.method_27765((int)rgb) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        graphics.method_25290(ModTextures.BLACKBOARD_GUI_TEXTURE, this.x, this.y, (float)(this.u + offset) * 6.0f, (float)this.v * 6.0f, 6, 6, 192, 96);
    }

    public void renderTooltip(class_332 poseStack) {
        poseStack.method_51448().method_46416(0.0f, 0.0f, 90.0f);
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        poseStack.method_25290(ModTextures.BLACKBOARD_GUI_TEXTURE, this.x - 1, this.y - 1, 96.0f, 0.0f, 8, 8, 192, 96);
        this.renderButton(poseStack);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.isValidClickButton(button) && (flag = this.method_25405(mouseX, mouseY))) {
            this.playDownSound(class_310.method_1551().method_1483());
            this.setColor((byte)(this.color == 0 ? 1 : 0));
            return true;
        }
        return false;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClickButton(button)) {
            this.parent.onButtonDragged(mouseX, mouseY, this.color);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isValidClickButton(button)) {
            this.parent.saveHistoryStep();
            return true;
        }
        return false;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + 6) && mouseY < (double)(this.y + 6);
    }

    public void playDownSound(class_1144 handler) {
        handler.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public static interface IDraggable {
        public void onDragged(double var1, double var3, byte var5);
    }

    public static interface IPressable {
        public void onPress(int var1, int var2, byte var3);
    }
}

