/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.EnumSet;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2565;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3619;
import net.minecraft.class_4538;
import net.minecraft.class_5547;
import net.minecraft.class_5558;
import net.minecraft.class_5819;

public class BellowsBlockTile
extends class_2586 {
    private static final float MAX_COMPRESSION = 0.125f;
    private float height = 0.0f;
    private float prevHeight = 0.0f;
    private int manualPress = 0;
    private long startTime = 0L;
    private boolean isPressed = false;
    private boolean lastBlowing = false;

    public BellowsBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.BELLOWS_TILE.get(), pos, state);
    }

    public float getHeight() {
        return this.height;
    }

    public float getHeight(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevHeight, (float)this.height);
    }

    public void setManualPress() {
        this.manualPress = 10;
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.field_11867);
    }

    private class_238 getHalfBoundingBox(class_2350 dir) {
        return new class_238(this.field_11867).method_1002(-0.5 * (double)dir.method_10148(), -0.5 * (double)dir.method_10164(), -0.5 * (double)dir.method_10165());
    }

    private void moveCollidedEntities(class_1937 level) {
        class_2350 dir = this.getDirection().method_10166() == class_2350.class_2351.field_11052 ? class_2350.field_11035 : class_2350.field_11036;
        for (int j = 0; j < 2; ++j) {
            class_238 halfBoundingBox = this.getHalfBoundingBox(dir);
            List list = level.method_8335(null, halfBoundingBox);
            if (!list.isEmpty()) {
                block6: for (class_1297 entity : list) {
                    if (entity.method_5657() == class_3619.field_15975) continue;
                    class_238 entityBB = entity.method_5829();
                    double dy = 0.0;
                    double dz = 0.0;
                    float f = this.height + 0.01f;
                    switch (dir) {
                        case field_11035: {
                            dz = halfBoundingBox.field_1324 + (double)f - entityBB.field_1321;
                            if (!(dz < 0.0)) break;
                            continue block6;
                        }
                        default: {
                            dz = halfBoundingBox.field_1321 - (double)f - entityBB.field_1324;
                            if (!(dz > 0.0)) break;
                            continue block6;
                        }
                        case field_11036: {
                            dy = halfBoundingBox.field_1325 + (double)f - entityBB.field_1322;
                            if (!(dy < 0.0)) break;
                            continue block6;
                        }
                        case field_11033: {
                            dy = halfBoundingBox.field_1322 - (double)f - entityBB.field_1325;
                            if (dy > 0.0) continue block6;
                        }
                    }
                    entity.method_5784(class_1313.field_6306, new class_243(0.0, dy, dz));
                }
            }
            dir = dir.method_10153();
        }
    }

    private void pushEntities(class_2350 facing, float period, float range, class_1937 level) {
        double velocity = CommonConfigs.Redstone.BELLOWS_BASE_VEL_SCALING.get() / (double)period;
        double maxVelocity = CommonConfigs.Redstone.BELLOWS_MAX_VEL.get();
        class_238 facingBox = MiscUtils.getDirectionBB(this.field_11867, facing, (int)range);
        List list = level.method_18467(class_1297.class, facingBox);
        block7: for (class_1297 entity : list) {
            if (!this.inLineOfSight(entity, facing, level)) continue;
            if (facing == class_2350.field_11036) {
                maxVelocity *= 0.5;
            }
            class_238 entityBB = entity.method_5829();
            velocity *= ((double)range - (switch (facing) {
                default -> {
                    double b = (double)this.field_11867.method_10260() + 1.0;
                    if (entityBB.field_1321 < b) continue block7;
                    yield entity.method_23321() - b;
                }
                case class_2350.field_11043 -> {
                    double b = this.field_11867.method_10260();
                    if (entityBB.field_1324 > b) continue block7;
                    yield b - entity.method_23321();
                }
                case class_2350.field_11034 -> {
                    double b = (double)this.field_11867.method_10263() + 1.0;
                    if (entityBB.field_1323 < b) continue block7;
                    yield entity.method_23317() - b;
                }
                case class_2350.field_11039 -> {
                    double b = this.field_11867.method_10263();
                    if (entityBB.field_1320 > b) continue block7;
                    yield b - entity.method_23317();
                }
                case class_2350.field_11036 -> {
                    double b = (double)this.field_11867.method_10264() + 1.0;
                    if (entityBB.field_1322 < b) continue block7;
                    yield entity.method_23318() - b;
                }
                case class_2350.field_11033 -> {
                    double b = this.field_11867.method_10264();
                    if (entityBB.field_1325 > b) continue block7;
                    yield b - entity.method_23318();
                }
            })) / (double)range;
            if (!(Math.abs(entity.method_18798().method_18043(facing.method_10166())) < maxVelocity)) continue;
            entity.method_18799(entity.method_18798().method_1031((double)facing.method_10148() * velocity, (double)facing.method_10164() * velocity, (double)facing.method_10165() * velocity));
            if (!CommonConfigs.Redstone.BELLOWS_FLAG.get().booleanValue()) continue;
            entity.field_6037 = true;
        }
    }

    private void blowParticles(float air, class_2350 facing, class_1937 level, boolean waterInFront) {
        if (level.field_9229.method_43057() < air) {
            class_2338 facingPos;
            AirType type = AirType.BUBBLE;
            class_2338 frontPos = facingPos = this.field_11867.method_10093(facing);
            boolean hasSponge = false;
            if (!waterInFront) {
                class_2680 frontState = level.method_8320(facingPos);
                if (frontState.method_26204() instanceof class_2565) {
                    hasSponge = true;
                    frontPos = frontPos.method_10093(facing);
                }
                type = AirType.AIR;
            }
            if (!class_2248.method_20044((class_4538)level, (class_2338)frontPos, (class_2350)facing.method_10153())) {
                class_2338 p = this.field_11867;
                if (hasSponge) {
                    EnumSet<class_2350> directions = EnumSet.allOf(class_2350.class);
                    directions.remove(facing.method_10153());
                    directions.remove(facing);
                    for (class_2350 d : directions) {
                        if (!level.method_8320(facingPos.method_10093(d)).method_27852(ModRegistry.SOAP_BLOCK.get())) continue;
                        type = AirType.SOAP;
                        p = facingPos;
                        break;
                    }
                    if (type != AirType.SOAP) {
                        return;
                    }
                }
                this.spawnParticle(level, p, facing, type);
            }
        }
    }

    private <T extends class_2586> void tickFurnaces(class_2338 frontPos, class_2680 frontState, class_1937 level, T tile) {
        class_5558 ticker;
        if (tile != null && (ticker = frontState.method_31708(level, tile.method_11017())) != null) {
            ticker.tick(level, frontPos, frontState, tile);
        }
    }

    private void tickFurnaces(class_2338 pos, class_1937 level) {
        class_2680 state = level.method_8320(pos);
        if (state.method_26164(ModTags.BELLOWS_TICKABLE_TAG)) {
            class_2586 te = level.method_8321(pos);
            this.tickFurnaces(pos, state, level, te);
        } else if (state.method_26204() instanceof class_5547 && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            state.method_26199(serverLevel, pos, level.field_9229);
        }
    }

    private void refreshFire(int n, class_2350 facing, class_2338 frontPos, class_1937 level) {
        for (int i = 0; i < n; ++i) {
            int age;
            class_2680 fb = level.method_8320(frontPos);
            if (fb.method_26204() instanceof class_2358 && (age = ((Integer)fb.method_11654((class_2769)class_2358.field_11092)).intValue()) != 0) {
                level.method_8652(frontPos, (class_2680)fb.method_11657((class_2769)class_2358.field_11092, (Comparable)Integer.valueOf(class_3532.method_15340((int)(age - 7), (int)0, (int)15))), 4);
            }
            frontPos = frontPos.method_10093(facing);
        }
    }

    private float getPeriodForPower(int power) {
        return (float)CommonConfigs.Redstone.BELLOWS_PERIOD.get().intValue() - (float)(power - 1) * (float)CommonConfigs.Redstone.BELLOWS_POWER_SCALING.get().intValue();
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, BellowsBlockTile tile) {
        int power = (Integer)state.method_11654((class_2769)BellowsBlock.POWER);
        tile.prevHeight = tile.height;
        if (power != 0 && (tile.startTime != 0L || tile.height == 0.0f)) {
            boolean blowing;
            long time = level.method_8510();
            if (tile.startTime == 0L) {
                tile.startTime = time;
            }
            float period = tile.getPeriodForPower(power);
            float arg = (float)Math.PI * 2 * ((float)(time - tile.startTime) / period % 1.0f);
            float sin = class_3532.method_15374((float)arg);
            float cos = class_3532.method_15362((float)arg);
            float half = 0.0625f;
            tile.height = half * cos - half;
            tile.pushAir(level, pos, state, power, time, period, sin);
            boolean bl = blowing = class_3532.method_15374((float)(arg - 0.8f)) > 0.0f;
            if (tile.lastBlowing != blowing) {
                level.method_8396(null, pos, blowing ? ModSounds.BELLOWS_BLOW.get() : ModSounds.BELLOWS_RETRACT.get(), class_3419.field_15245, 0.1f, MthUtils.nextWeighted((class_5819)level.field_9229, (float)0.1f) + 0.85f + 0.6f * (float)power / 15.0f);
            }
            tile.lastBlowing = blowing;
        } else if (tile.isPressed) {
            float minH = -0.125f;
            tile.height = Math.max(tile.height - 0.01f, minH);
            if (tile.height > minH) {
                long time = level.method_8510();
                int p = 7;
                float period = tile.getPeriodForPower(p);
                tile.pushAir(level, pos, state, p, time, period, 0.8f);
            }
        } else {
            tile.startTime = 0L;
            if (tile.height < 0.0f) {
                tile.height = Math.min(tile.height + 0.01f, 0.0f);
            }
        }
        if (tile.prevHeight != 0.0f && tile.height != 0.0f) {
            tile.moveCollidedEntities(level);
        }
        if (tile.manualPress > 0) {
            --tile.manualPress;
            tile.isPressed = true;
        } else {
            tile.isPressed = false;
        }
    }

    private void pushAir(class_1937 level, class_2338 pos, class_2680 state, int power, long time, float period, float airIntensity) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)BellowsBlock.FACING);
        class_2338 frontPos = pos.method_10093(facing);
        class_3610 fluid = level.method_8316(frontPos);
        if (level.field_9236) {
            this.blowParticles(airIntensity, facing, level, fluid.method_15772().method_15791(class_3486.field_15517));
        } else if (fluid.method_15769()) {
            float range = CommonConfigs.Redstone.BELLOWS_RANGE.get().intValue();
            if (airIntensity > 0.0f) {
                this.pushEntities(facing, period, range, level);
            }
            if (time % (long)(10 - power / 2) == 0L) {
                this.tickFurnaces(frontPos, level);
            }
            int n = 0;
            int a = 0;
            while ((float)a <= range) {
                if (time % (15L * (long)(a + 1)) != 0L) {
                    n = a;
                    break;
                }
                ++a;
            }
            this.refreshFire(n, facing, frontPos, level);
        }
    }

    public boolean inLineOfSight(class_1297 entity, class_2350 facing, class_1937 level) {
        int x = facing.method_10148() * (class_3532.method_15357((double)entity.method_23317()) - this.field_11867.method_10263());
        int y = facing.method_10164() * (class_3532.method_15357((double)entity.method_23318()) - this.field_11867.method_10264());
        int z = facing.method_10165() * (class_3532.method_15357((double)entity.method_23321()) - this.field_11867.method_10260());
        boolean flag = true;
        for (int i = 1; i < Math.abs(x + y + z); ++i) {
            if (!class_2248.method_20044((class_4538)level, (class_2338)this.field_11867.method_10079(facing, i), (class_2350)facing.method_10153())) continue;
            flag = false;
        }
        return flag;
    }

    public void spawnParticle(class_1937 world, class_2338 pos, class_2350 dir, AirType airType) {
        if (airType == AirType.SOAP) {
            for (int m = 0; m < 1 + world.field_9229.method_43048(3); ++m) {
                ParticleUtil.spawnParticleOnFace((class_1937)world, (class_2338)pos, (class_2350)dir, (class_2394)((class_2394)ModParticles.SUDS_PARTICLE.get()), (float)0.3f, (float)0.5f, (boolean)true);
            }
        } else {
            double xo = dir.method_10148();
            double yo = dir.method_10164();
            double zo = dir.method_10165();
            double x = xo * 0.5 + (double)pos.method_10263() + 0.5 + ((double)world.field_9229.method_43057() - 0.5) / 3.0;
            double y = yo * 0.5 + (double)pos.method_10264() + 0.5 + ((double)world.field_9229.method_43057() - 0.5) / 3.0;
            double z = zo * 0.5 + (double)pos.method_10260() + 0.5 + ((double)world.field_9229.method_43057() - 0.5) / 3.0;
            double vel = 0.125f + world.field_9229.method_43057() * 0.2f;
            double velX = xo * vel;
            double velY = yo * vel;
            double velZ = zo * vel;
            if (airType == AirType.BUBBLE) {
                world.method_8406((class_2394)class_2398.field_11247, x, y, z, velX * 0.8, velY * 0.8, velZ * 0.8);
            } else {
                world.method_8406((class_2394)class_2398.field_11251, x, y, z, velX, velY, velZ);
            }
        }
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)BellowsBlock.FACING);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.startTime = compound.method_10537("Offset");
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10544("Offset", this.startTime);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void onSteppedOn(class_1297 entityIn) {
        if (this.isPressed) {
            return;
        }
        double b = entityIn.method_5829().method_995();
        if (b > 0.8 && ((class_2350)this.method_11010().method_11654((class_2769)BellowsBlock.FACING)).method_10166() != class_2350.class_2351.field_11052) {
            this.isPressed = true;
        }
    }

    private static enum AirType {
        AIR,
        BUBBLE,
        SOAP;

    }
}

