/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.base.BERText;
import de.mrjulsen.crn.client.ber.variants.IBERRenderSubtype;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.event.listeners.JourneyListener;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;

public class BERPassengerInfoSimple
implements IBERRenderSubtype<AdvancedDisplayBlockEntity, AdvancedDisplayRenderInstance, Boolean> {
    private JourneyListener.State state = JourneyListener.State.WHILE_TRAVELING;
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";

    @Override
    public boolean isSingleLined() {
        return true;
    }

    @Override
    public void tick(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity pBlockEntity, AdvancedDisplayRenderInstance parent) {
        if (pBlockEntity.getTrainData() == null) {
            return;
        }
        boolean dirty = false;
        if (pBlockEntity.getTrainData().getNextStop().isPresent()) {
            if (this.state != JourneyListener.State.WHILE_NEXT_STOP && pBlockEntity.getTrainData().getNextStop().get().departureTicks() <= 0) {
                this.state = JourneyListener.State.WHILE_NEXT_STOP;
                dirty = true;
            } else if (this.state != JourneyListener.State.BEFORE_NEXT_STOP && pBlockEntity.getTrainData().getNextStop().get().departureTicks() <= (Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get() && pBlockEntity.getTrainData().getNextStop().get().departureTicks() > 0) {
                this.state = JourneyListener.State.BEFORE_NEXT_STOP;
                dirty = true;
            } else if (this.state != JourneyListener.State.WHILE_TRAVELING && pBlockEntity.getTrainData().getNextStop().get().departureTicks() > (Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()) {
                this.state = JourneyListener.State.WHILE_TRAVELING;
                dirty = true;
            }
        }
        if (dirty) {
            this.update(level, pos, state, pBlockEntity, parent, IBlockEntityRendererInstance.EUpdateReason.DATA_CHANGED);
        }
    }

    @Override
    public void update(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, IBlockEntityRendererInstance.EUpdateReason reason) {
        if (blockEntity.getTrainData() == null) {
            return;
        }
        parent.labels.clear();
        switch (this.state) {
            case BEFORE_NEXT_STOP: {
                this.updateAnnounceNextStop(level, pos, state, blockEntity, parent);
                break;
            }
            case WHILE_NEXT_STOP: {
                this.updateWhileNextStop(level, pos, state, blockEntity, parent);
                break;
            }
            default: {
                this.updateDefault(level, pos, state, blockEntity, parent);
            }
        }
    }

    @Override
    public void renderAdditional(IBlockEntityRendererInstance.BlockEntityRendererContext context, AdvancedDisplayBlockEntity pBlockEntity, AdvancedDisplayRenderInstance parent, float pPartialTicks, class_4587 pPoseStack, class_4597 pBufferSource, int pPackedLight, int pOverlay, Boolean backSide) {
        if (this.state == JourneyListener.State.WHILE_NEXT_STOP || this.state == JourneyListener.State.BEFORE_NEXT_STOP) {
            context.renderUtils().initRenderEngine();
            DeparturePrediction.TrainExitSide side = (DeparturePrediction.TrainExitSide)((Object)pBlockEntity.relativeExitDirection.get());
            float uv = 0.00390625f;
            if (backSide.booleanValue()) {
                side = side.getOpposite();
            }
            switch (side) {
                case RIGHT: {
                    context.renderUtils().renderTexture(ModGuiIcons.ICON_LOCATION, pBufferSource, (class_2586)pBlockEntity, pPoseStack, false, (float)(pBlockEntity.getXSizeScaled() * 16 - 3 - 8), 4.0f, 0.0f, 8.0f, 8.0f, uv * (float)ModGuiIcons.ARROW_RIGHT.getU(), uv * (float)ModGuiIcons.ARROW_RIGHT.getV(), uv * (float)(ModGuiIcons.ARROW_RIGHT.getU() + 16), uv * (float)(ModGuiIcons.ARROW_RIGHT.getV() + 16), (class_2350)pBlockEntity.method_11010().method_11654((class_2769)class_2383.field_11177), 0xFF000000 | pBlockEntity.getColor(), pPackedLight);
                    break;
                }
                case LEFT: {
                    context.renderUtils().renderTexture(ModGuiIcons.ICON_LOCATION, pBufferSource, (class_2586)pBlockEntity, pPoseStack, false, 3.0f, 4.0f, 0.0f, 8.0f, 8.0f, uv * (float)ModGuiIcons.ARROW_LEFT.getU(), uv * (float)ModGuiIcons.ARROW_LEFT.getV(), uv * (float)(ModGuiIcons.ARROW_LEFT.getU() + 16), uv * (float)(ModGuiIcons.ARROW_LEFT.getV() + 16), (class_2350)pBlockEntity.method_11010().method_11654((class_2769)class_2383.field_11177), 0xFF000000 | pBlockEntity.getColor(), pPackedLight);
                    break;
                }
            }
        }
    }

    private void updateDefault(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        byte displayWidth = blockEntity.getXSizeScaled();
        class_5250 line = TextUtils.text((String)blockEntity.getTrainData().trainName()).method_27693(" ").method_10852((class_2561)TextUtils.text((String)(blockEntity.getTrainData().getNextStop().isPresent() ? blockEntity.getTrainData().getNextStop().get().scheduleTitle() : "")));
        float maxWidth = displayWidth * 16 - 6;
        parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(true).withMaxWidth(maxWidth, true).withStretchScale(0.75f, 0.75f).withStencil(0.0f, maxWidth).withCanScroll(true, 1.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3.0f, 5.5f, 0.0f, 1.0f, 0.75f)).build());
    }

    private void updateAnnounceNextStop(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        byte displayWidth = blockEntity.getXSizeScaled();
        DeparturePrediction.TrainExitSide side = (DeparturePrediction.TrainExitSide)((Object)blockEntity.relativeExitDirection.get());
        class_5250 line = ELanguage.translate(keyNextStop, GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(blockEntity.getTrainData().getNextStop().isPresent() ? blockEntity.getTrainData().getNextStop().get().stationTagName() : "").getAliasName().get());
        float maxWidth = displayWidth * 16 - 6 - (side != DeparturePrediction.TrainExitSide.UNKNOWN ? 10 : 0);
        parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(true).withMaxWidth(maxWidth, true).withStretchScale(0.75f, 0.75f).withStencil(0.0f, maxWidth).withCanScroll(true, 1.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3 + (side == DeparturePrediction.TrainExitSide.LEFT ? 10 : 0), 5.5f, 0.0f, 1.0f, 0.75f)).build());
    }

    private void updateWhileNextStop(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        byte displayWidth = blockEntity.getXSizeScaled();
        DeparturePrediction.TrainExitSide side = (DeparturePrediction.TrainExitSide)((Object)blockEntity.relativeExitDirection.get());
        class_5250 line = TextUtils.text((String)GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(blockEntity.getTrainData().getNextStop().isPresent() ? blockEntity.getTrainData().getNextStop().get().stationTagName() : "").getAliasName().get());
        float maxWidth = displayWidth * 16 - 6 - (side != DeparturePrediction.TrainExitSide.UNKNOWN ? 10 : 0);
        parent.labels.add(new BERText(parent.getFontUtils(), (class_2561)line, 0.0f).withIsCentered(true).withMaxWidth(maxWidth, true).withStretchScale(0.75f, 0.75f).withStencil(0.0f, maxWidth).withCanScroll(true, 1.0f).withColor(0xFF000000 | blockEntity.getColor()).withPredefinedTextTransformation(new BERText.TextTransformation(3 + (side == DeparturePrediction.TrainExitSide.LEFT ? 10 : 0), 5.5f, 0.0f, 1.0f, 0.75f)).build());
    }
}

