/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.RouteDetailsOverlayScreen;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ExpandButton;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.event.listeners.IJourneyListenerClient;
import de.mrjulsen.crn.event.listeners.JourneyListener;
import de.mrjulsen.crn.event.listeners.JourneyListenerManager;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.mcdragonlib.client.OverlayManager;
import de.mrjulsen.mcdragonlib.client.gui.DLOverlayScreen;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class RouteDetailsScreen
extends DLScreen
implements IJourneyListenerClient {
    private static final class_2960 GUI = new class_2960("createrailwaysnavigator", "textures/gui/route_details.png");
    private static final int GUI_WIDTH = 255;
    private static final int GUI_HEIGHT = 247;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final int ENTRIES_START_Y_OFFSET = 18;
    private static final int ENTRY_WIDTH = 220;
    private static final int ENTRY_TIME_X = 28;
    private static final int ENTRY_DEST_X = 66;
    private final int AREA_X = 16;
    private final int AREA_Y = 53;
    private final int AREA_W = 220;
    private final int AREA_H = 157;
    private int guiLeft;
    private int guiTop;
    private int scrollMax = 0;
    private DLCreateIconButton backButton;
    private DLCreateIconButton saveButton;
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private final ExpandButton[] expandButtons;
    private final WidgetsCollection expandButtonCollection = new WidgetsCollection();
    private final SimpleRoute route;
    private final class_437 lastScreen;
    private final class_327 font;
    private final class_327 shadowlessFont;
    private final class_1937 level;
    private final class_5250 textDeparture = ELanguage.translate("gui.createrailwaysnavigator.route_details.departure");
    private final class_5250 textTransferIn = ELanguage.translate("gui.createrailwaysnavigator.route_details.next_transfer_time");
    private final class_5250 transferText = ELanguage.translate("gui.createrailwaysnavigator.route_details.transfer");
    private final class_5250 textJourneyCompleted = ELanguage.translate("gui.createrailwaysnavigator.route_overview.journey_completed");
    private final class_5250 timeNowText = ELanguage.translate("gui.createrailwaysnavigator.time.now");
    private final class_5250 textConnectionEndangered = ELanguage.translate("gui.createrailwaysnavigator.route_overview.connection_endangered").method_27692(class_124.field_1065).method_27692(class_124.field_1067);
    private final class_5250 textConnectionMissed = ELanguage.translate("gui.createrailwaysnavigator.route_overview.connection_missed").method_27692(class_124.field_1061).method_27692(class_124.field_1067);
    private final class_5250 textTrainCanceled = ELanguage.translate("gui.createrailwaysnavigator.route_overview.train_canceled").method_27692(class_124.field_1061).method_27692(class_124.field_1067);
    private final class_5250 textSaveRoute = TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.save_route");
    private final String keyTrainCancellationReason = "gui.createrailwaysnavigator.route_overview.train_cancellation_info";
    private final UUID clientId = UUID.randomUUID();

    public RouteDetailsScreen(class_437 lastScreen, class_1937 level, SimpleRoute route, UUID listenerId) {
        super((class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.title"));
        this.lastScreen = lastScreen;
        this.route = route;
        this.font = class_310.method_1551().field_1772;
        this.shadowlessFont = new NoShadowFontWrapper(this.font);
        this.level = level;
        JourneyListenerManager.getInstance().get(listenerId, this);
        int count = route.getParts().size();
        this.expandButtons = new ExpandButton[count];
        for (int i = 0; i < count; ++i) {
            this.expandButtons[i] = new ExpandButton(0, 0, false, btn -> {});
            this.expandButtonCollection.components.add(this.expandButtons[i]);
        }
    }

    @Override
    public UUID getJourneyListenerClientId() {
        return this.clientId;
    }

    public int getCurrentTime() {
        return (int)(this.level.method_8532() % 24000L);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.lastScreen);
        JourneyListenerManager.getInstance().removeClientListenerForAll(this);
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = this.field_22789 / 2 - 127;
        this.guiTop = this.field_22790 / 2 - 123;
        final int fWidth = this.field_22789;
        final int fHeight = this.field_22790;
        this.backButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 21, this.guiTop + 222, 18, 18, (ScreenElement)AllIcons.I_CONFIG_BACK){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                RouteDetailsScreen.this.method_25419();
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)Constants.TOOLTIP_GO_BACK).assignedTo((class_339)this.backButton));
        this.saveButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 21 + 18 + 4, this.guiTop + 222, 18, 18, (ScreenElement)ModGuiIcons.BOOKMARK.getAsCreateIcon()){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                if (JourneyListenerManager.getInstance().exists(RouteDetailsScreen.this.route.getListenerId())) {
                    InstanceManager.setRouteOverlay(OverlayManager.add((DLOverlayScreen)new RouteDetailsOverlayScreen(RouteDetailsScreen.this.level, RouteDetailsScreen.this.route, fWidth, fHeight)));
                }
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)this.textSaveRoute).assignedTo((class_339)this.saveButton));
    }

    public void method_25393() {
        super.method_25393();
        this.scroll.tickChaser();
        this.saveButton.field_22764 = JourneyListenerManager.getInstance().exists(this.route.getListenerId());
    }

    private Pair<class_5250, class_5250> getStationInfo(SimpleRoute.StationEntry station) {
        boolean reachable = station.reachable(false);
        class_5250 timeText = TextUtils.text((String)TimeUtils.parseTime((long)((int)((this.route.getRefreshTime() + 6000L) % 24000L + (long)station.getTicks())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())));
        class_5250 stationText = TextUtils.text((String)station.getStationName());
        if (!reachable) {
            timeText = timeText.method_27692(class_124.field_1061).method_27692(class_124.field_1055);
            stationText = stationText.method_27692(class_124.field_1061).method_27692(class_124.field_1055);
        }
        return Pair.of((Object)timeText, (Object)stationText);
    }

    private int renderRouteStart(Graphics graphics, int x, int y, SimpleRoute.StationEntry stop) {
        int HEIGHT = 30;
        int V = 48;
        GuiUtils.drawTexture((class_2960)Constants.GUI_WIDGETS, (Graphics)graphics, (int)x, (int)y, (int)0, (int)48, (int)220, (int)30);
        Pair<class_5250, class_5250> text = this.getStationInfo(stop);
        float scale = this.shadowlessFont.method_27525((class_5348)text.getFirst()) > 30 ? 0.75f : 1.0f;
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(scale, 1.0f, 1.0f);
        int pY = y + 15;
        if (stop.shouldRenderRealtime() && stop.reachable(false)) {
            GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)((pY -= stop.shouldRenderRealtime() ? 5 : 0) + 10), (class_5348)TextUtils.text((String)TimeUtils.parseTime((long)((int)(stop.getEstimatedTimeWithThreshold() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(stop.getDifferenceTime() > (long)((Integer)ModClientConfig.DEVIATION_THRESHOLD.get()).intValue() ? 0xFF4242 : 1763935), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)pY, (class_5348)((class_5348)text.getFirst()), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().method_22909();
        class_5250 platformText = TextUtils.text((String)stop.getUpdatedInfo().platform());
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(x + 66 + 129 - this.shadowlessFont.method_27525((class_5348)platformText)), (int)(y + 15), (class_5348)platformText, (int)(stop.stationInfoChanged() ? 0xFF4242 : 0xFFFFFF), (EAlignment)EAlignment.LEFT, (boolean)false);
        class_5250 name = (class_5250)text.getSecond();
        int maxTextWidth = 123 - this.shadowlessFont.method_27525((class_5348)platformText);
        if (this.shadowlessFont.method_27525((class_5348)name) > maxTextWidth) {
            name = TextUtils.text((String)this.shadowlessFont.method_1714((class_5348)name, maxTextWidth - 3).getString()).method_10852(Constants.ELLIPSIS_STRING);
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(x + 66), (int)(y + 15), (class_5348)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        return 30;
    }

    private int renderTrainDetails(Graphics graphics, int x, int y, SimpleRoute.SimpleRoutePart part) {
        int HEIGHT = 43;
        int V = 99;
        float scale = 0.75f;
        float mul = 1.3333334f;
        GuiUtils.drawTexture((class_2960)Constants.GUI_WIDGETS, (Graphics)graphics, (int)x, (int)y, (int)0, (int)99, (int)220, (int)43);
        part.getTrainIcon().render(-1, graphics.graphics(), x + 66, y + 7);
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(0.75f, 0.75f, 0.75f);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)((int)((float)(x + 66 + 24) / 0.75f)), (int)((int)((float)(y + 7) / 0.75f)), (class_5348)TextUtils.text((String)String.format("%s (%s)", part.getTrainName(), part.getTrainID().toString().split("-")[0])), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)((int)((float)(x + 66 + 24) / 0.75f)), (int)((int)((float)(y + 17) / 0.75f)), (class_5348)TextUtils.text((String)String.format("\u2192 %s", part.getScheduleTitle())), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().method_22905(1.3333334f, 1.3333334f, 1.3333334f);
        graphics.poseStack().method_22909();
        return 43;
    }

    private int renderStop(Graphics graphics, int x, int y, SimpleRoute.StationEntry stop) {
        int HEIGHT = 21;
        int V = 78;
        GuiUtils.drawTexture((class_2960)Constants.GUI_WIDGETS, (Graphics)graphics, (int)x, (int)y, (int)0, (int)78, (int)220, (int)21);
        Pair<class_5250, class_5250> text = this.getStationInfo(stop);
        float scale = this.shadowlessFont.method_27525((class_5348)text.getFirst()) > 30 ? 0.75f : 1.0f;
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(scale, 1.0f, 1.0f);
        int pY = y + 6;
        if (stop.shouldRenderRealtime() && stop.reachable(false)) {
            GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)((pY -= stop.shouldRenderRealtime() ? 5 : 0) + 10), (class_5348)TextUtils.text((String)TimeUtils.parseTime((long)((int)(stop.getEstimatedTimeWithThreshold() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(stop.getDifferenceTime() > (long)((Integer)ModClientConfig.DEVIATION_THRESHOLD.get()).intValue() ? 0xFF4242 : 1763935), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)pY, (class_5348)((class_5348)text.getFirst()), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().method_22909();
        class_5250 platformText = TextUtils.text((String)stop.getUpdatedInfo().platform());
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(x + 66 + 129 - this.shadowlessFont.method_27525((class_5348)platformText)), (int)(y + 6), (class_5348)platformText, (int)(stop.stationInfoChanged() ? 0xFF4242 : 0xFFFFFF), (EAlignment)EAlignment.LEFT, (boolean)false);
        class_5250 name = (class_5250)text.getSecond();
        int maxTextWidth = 123 - this.shadowlessFont.method_27525((class_5348)platformText);
        if (this.shadowlessFont.method_27525((class_5348)name) > maxTextWidth) {
            name = TextUtils.text((String)this.shadowlessFont.method_1714((class_5348)name, maxTextWidth - 3).getString()).method_10852(Constants.ELLIPSIS_STRING);
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(x + 66), (int)(y + 6), (class_5348)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        return 21;
    }

    private int renderRouteEnd(Graphics graphics, int x, int y, SimpleRoute.StationEntry stop) {
        int HEIGHT = 44;
        int V = 142;
        GuiUtils.drawTexture((class_2960)Constants.GUI_WIDGETS, (Graphics)graphics, (int)x, (int)y, (int)0, (int)142, (int)220, (int)44);
        Pair<class_5250, class_5250> text = this.getStationInfo(stop);
        float scale = this.shadowlessFont.method_27525((class_5348)text.getFirst()) > 30 ? 0.75f : 1.0f;
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(scale, 1.0f, 1.0f);
        int pY = y + 21;
        if (stop.shouldRenderRealtime() && stop.reachable(false)) {
            GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)((pY -= stop.shouldRenderRealtime() ? 5 : 0) + 10), (class_5348)TextUtils.text((String)TimeUtils.parseTime((long)((int)(stop.getEstimatedTimeWithThreshold() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(stop.getDifferenceTime() > (long)((Integer)ModClientConfig.DEVIATION_THRESHOLD.get()).intValue() ? 0xFF4242 : 1763935), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)pY, (class_5348)((class_5348)text.getFirst()), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().method_22909();
        class_5250 platformText = TextUtils.text((String)stop.getUpdatedInfo().platform());
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(x + 66 + 129 - this.shadowlessFont.method_27525((class_5348)platformText)), (int)(y + 21), (class_5348)platformText, (int)(stop.stationInfoChanged() ? 0xFF4242 : 0xFFFFFF), (EAlignment)EAlignment.LEFT, (boolean)false);
        class_5250 name = (class_5250)text.getSecond();
        int maxTextWidth = 123 - this.shadowlessFont.method_27525((class_5348)platformText);
        if (this.shadowlessFont.method_27525((class_5348)name) > maxTextWidth) {
            name = TextUtils.text((String)this.shadowlessFont.method_1714((class_5348)name, maxTextWidth - 3).getString()).method_10852(Constants.ELLIPSIS_STRING);
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(x + 66), (int)(y + 21), (class_5348)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        return 44;
    }

    private void renderHeadline(Graphics graphics, int pMouseX, int pMouseY) {
        class_5250 titleInfo = TextUtils.empty();
        class_5250 headline = TextUtils.empty();
        JourneyListener listener = JourneyListenerManager.getInstance().get(this.route.getListenerId(), null);
        if (!this.route.isValid()) {
            titleInfo = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.train_cancellation_info", (Object[])new Object[]{this.route.getInvalidationTrainName()}).method_27692(class_124.field_1061);
            headline = this.textTrainCanceled;
        } else if (listener != null && listener.getIndex() > 0) {
            titleInfo = this.textTransferIn;
            long arrivalTime = listener.currentStation().getParent().getEndStation().getEstimatedTimeWithThreshold();
            int time = (int)(arrivalTime % 24000L - (long)this.getCurrentTime());
            headline = time < 0 || listener.currentStation().getTag() == SimpleRoute.StationTag.PART_START ? this.timeNowText : TextUtils.text((String)TimeUtils.parseTime((long)time, (TimeUtils.TimeFormat)TimeUtils.TimeFormat.HOURS_24));
        } else if (listener == null) {
            titleInfo = TextUtils.empty();
            headline = this.textJourneyCompleted.method_27692(class_124.field_1060);
        } else {
            titleInfo = this.textDeparture;
            int departureTicks = this.route.getStartStation().getTicks();
            int departureTime = (int)(this.route.getRefreshTime() % 24000L + (long)departureTicks);
            headline = departureTime - this.getCurrentTime() < 0 ? this.timeNowText : TextUtils.text((String)TimeUtils.parseTime((long)(departureTime - this.getCurrentTime()), (TimeUtils.TimeFormat)TimeUtils.TimeFormat.HOURS_24));
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(this.guiLeft + 127), (int)(this.guiTop + 19), (class_5348)titleInfo, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(2.0f, 2.0f, 2.0f);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)((this.guiLeft + 127) / 2), (int)((this.guiTop + 31) / 2), (class_5348)headline, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
        graphics.poseStack().method_22909();
    }

    private int renderTransfer(Graphics graphics, int x, int y, long a, long b, SimpleRoute.StationEntry nextStation) {
        int HEIGHT = 24;
        int V = 186;
        GuiUtils.drawTexture((class_2960)Constants.GUI_WIDGETS, (Graphics)graphics, (int)x, (int)y, (int)0, (int)186, (int)220, (int)24);
        long time = -1L;
        time = a < 0L || b < 0L ? -1L : b - a;
        if (nextStation != null && !nextStation.reachable(true)) {
            if (nextStation.isTrainCanceled()) {
                ModGuiIcons.CROSS.render(graphics, x + 28, y + 13 - 8);
                GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(x + 28 + 16 + 4), (int)(y + 8), (class_5348)this.textTrainCanceled, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
            } else if (nextStation.isDeparted()) {
                ModGuiIcons.CROSS.render(graphics, x + 28, y + 13 - 8);
                GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(x + 28 + 16 + 4), (int)(y + 8), (class_5348)this.textConnectionMissed, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
            } else {
                ModGuiIcons.WARN.render(graphics, x + 28, y + 13 - 8);
                GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(x + 28 + 16 + 4), (int)(y + 8), (class_5348)this.textConnectionEndangered, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
            }
        } else {
            GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(x + 28), (int)(y + 8), (class_5348)TextUtils.text((String)(this.transferText.getString() + " " + (String)(time < 0L ? "" : "(" + TimeUtils.parseDuration((long)time) + ")"))), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        return 24;
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = class_310.method_1551().method_1488();
        float scrollOffset = -this.scroll.getValue(pPartialTick);
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((class_2960)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)255, (int)247);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(this.guiLeft + 19), (int)(this.guiTop + 4), (class_5348)this.field_22785, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        String timeString = TimeUtils.parseTime((long)((int)((this.level.method_8532() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        GuiUtils.drawString((Graphics)graphics, (class_327)this.shadowlessFont, (int)(this.guiLeft + 255 - 22 - this.shadowlessFont.method_1727(timeString)), (int)(this.guiTop + 4), (class_5348)TextUtils.text((String)timeString), (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        this.renderHeadline(graphics, pMouseX, pMouseY);
        GuiUtils.enableScissor((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 53), (int)220, (int)157);
        graphics.poseStack().method_46416(0.0f, scrollOffset, 0.0f);
        int yOffs = this.guiTop + 45;
        GuiUtils.drawTexture((class_2960)Constants.GUI_WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16), (int)yOffs, (int)22, (int)18, (int)0, (int)48, (int)22, (int)1, (int)256, (int)256);
        yOffs += 18;
        SimpleRoute.SimpleRoutePart[] partsArray = (SimpleRoute.SimpleRoutePart[])this.route.getParts().toArray(SimpleRoute.SimpleRoutePart[]::new);
        for (int i = 0; i < partsArray.length; ++i) {
            SimpleRoute.SimpleRoutePart part = partsArray[i];
            yOffs += this.renderRouteStart(graphics, this.guiLeft + 16, yOffs, part.getStartStation());
            yOffs += this.renderTrainDetails(graphics, this.guiLeft + 16, yOffs, part);
            ExpandButton btn = this.expandButtons[i];
            boolean bl = btn.field_22763 = part.getStopovers().size() > 0;
            if (btn.field_22763) {
                btn.method_46421(this.guiLeft + 78);
                btn.method_46419(yOffs - 14);
                btn.method_25394(graphics.graphics(), pMouseX, (int)((float)pMouseY - scrollOffset), pPartialTick);
            }
            if (btn.isExpanded()) {
                for (SimpleRoute.StationEntry stop : part.getStopovers()) {
                    yOffs += this.renderStop(graphics, this.guiLeft + 16, yOffs, stop);
                }
            }
            yOffs += this.renderRouteEnd(graphics, this.guiLeft + 16, yOffs, part.getEndStation());
            if (i >= partsArray.length - 1) continue;
            SimpleRoute.StationEntry currentStation = part.getEndStation();
            SimpleRoute.StationEntry nextStation = partsArray[i + 1].getStartStation();
            long a = currentStation.shouldRenderRealtime() ? currentStation.getCurrentTime() : currentStation.getScheduleTime();
            long b = nextStation.shouldRenderRealtime() ? nextStation.getCurrentTime() : nextStation.getScheduleTime();
            yOffs += this.renderTransfer(graphics, this.guiLeft + 16, yOffs, a, b, nextStation);
        }
        this.scrollMax = yOffs - this.guiTop - 45;
        GuiUtils.drawTexture((class_2960)Constants.GUI_WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16), (int)yOffs, (int)22, (int)157, (int)0, (int)48, (int)22, (int)1, (int)256, (int)256);
        GuiUtils.disableScissor((Graphics)graphics);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 53), (int)0, (int)220, (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 53 + 157 - 10), (int)0, (int)220, (int)10, (int)0, (int)0x77000000);
        double maxHeight = this.scrollMax;
        double aH = 158.0;
        if (aH / maxHeight < 1.0) {
            int scrollerHeight = Math.max(10, (int)(aH * (aH / maxHeight)));
            int startY = this.guiTop + 53 + (int)(157.0 * ((double)Math.abs(scrollOffset) / maxHeight));
            GuiUtils.fill((Graphics)graphics, (int)(this.guiLeft + 16 + 220 - 3), (int)startY, (int)3, (int)scrollerHeight, (int)Integer.MAX_VALUE);
        }
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        float chaseTarget = this.scroll.getChaseTarget();
        float max = -157.0f;
        if ((max += (float)this.scrollMax) > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pDelta * 12.0);
            chaseTarget = MathUtils.clamp((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.method_25401(pMouseX, pMouseY, pDelta);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        float scrollOffset = this.scroll.getValue();
        if (pMouseX > (double)(this.guiLeft + 16) && pMouseX < (double)(this.guiLeft + 16 + 220) && pMouseY > (double)(this.guiTop + 53) && pMouseY < (double)(this.guiTop + 53 + 157)) {
            this.expandButtonCollection.performForEach(x -> x.field_22763, x -> x.method_25402(pMouseX, pMouseY + (double)scrollOffset, pButton));
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }
}

