/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import de.mrjulsen.crn.client.gui.screen.AbstractBlacklistScreen;
import de.mrjulsen.crn.data.ClientTrainStationSnapshot;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Collection;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class StationBlacklistScreen
extends AbstractBlacklistScreen {
    public StationBlacklistScreen(class_1937 level, class_437 lastScreen) {
        super(level, lastScreen, (class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.blacklist.title"));
    }

    @Override
    protected Collection<String> getSuggestions() {
        return ClientTrainStationSnapshot.getInstance().getAllTrainStations();
    }

    @Override
    protected boolean checkIsBlacklisted(String entry) {
        return GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted(entry);
    }

    @Override
    protected String[] getBlacklistedNames(String searchText) {
        return (String[])GlobalSettingsManager.getInstance().getSettingsData().getBlacklist().stream().filter(x -> x.toLowerCase().contains(searchText.toLowerCase())).toArray(String[]::new);
    }

    @Override
    protected void addToBlacklist(String name, Runnable andThen) {
        if (GlobalSettingsManager.getInstance().getSettingsData().isBlacklisted(name) || ClientTrainStationSnapshot.getInstance().getAllTrainStations().stream().noneMatch(x -> x.toLowerCase().equals(name.toLowerCase()))) {
            return;
        }
        GlobalSettingsManager.getInstance().getSettingsData().addToBlacklist(name, andThen);
    }

    @Override
    protected void removeFromBlacklist(String name, Runnable andThen) {
        GlobalSettingsManager.getInstance().getSettingsData().removeFromBlacklist(name, andThen);
    }
}

