/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.lang;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.mrjulsen.crn.client.ClientWrapper;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2590;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;

public class ModTranslatableComponent
implements class_7417 {
    public static final Object[] NO_ARGS = new Object[0];
    private static final class_5348 TEXT_PERCENT = class_5348.method_29430((String)"%");
    private static final class_5348 TEXT_NULL = class_5348.method_29430((String)"null");
    private final String key;
    @Nullable
    private final String fallback;
    private final Object[] args;
    @Nullable
    private class_2477 decomposedWith;
    private List<class_5348> decomposedParts = ImmutableList.of();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public ModTranslatableComponent(String key, @Nullable String fallback, Object[] args) {
        this.key = key;
        this.fallback = fallback;
        this.args = args;
    }

    private void decompose() {
        class_2477 language = ClientWrapper.getCurrentClientLanguage();
        if (language != this.decomposedWith) {
            this.decomposedWith = language;
            String string = this.fallback != null ? language.method_4679(this.key, this.fallback) : language.method_48307(this.key);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                Objects.requireNonNull(builder);
                this.decomposeTemplate(string, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.decomposedParts = builder.build();
            }
            catch (class_2590 var4) {
                this.decomposedParts = ImmutableList.of((Object)class_5348.method_29430((String)string));
            }
        }
    }

    private void decomposeTemplate(String formatTemplate, Consumer<class_5348> consumer) {
        Matcher matcher = FORMAT_PATTERN.matcher(formatTemplate);
        int i = 0;
        int j = 0;
        while (matcher.find(j)) {
            String string;
            int k = matcher.start();
            int l = matcher.end();
            if (k > j) {
                string = formatTemplate.substring(j, k);
                if (string.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                consumer.accept(class_5348.method_29430((String)string));
            }
            string = matcher.group(2);
            String string2 = formatTemplate.substring(k, l);
            if ("%".equals(string) && "%%".equals(string2)) {
                consumer.accept(TEXT_PERCENT);
            } else {
                if (!"s".equals(string)) {
                    throw new IllegalArgumentException("Unsupported format: '" + string2 + "'");
                }
                String string3 = matcher.group(1);
                int m = string3 != null ? Integer.parseInt(string3) - 1 : i++;
                consumer.accept(this.getArgument(m));
            }
            j = l;
        }
        if (j < formatTemplate.length()) {
            String string4 = formatTemplate.substring(j);
            if (string4.indexOf(37) != -1) {
                throw new IllegalArgumentException();
            }
            consumer.accept(class_5348.method_29430((String)string4));
        }
    }

    public final class_5348 getArgument(int index) {
        if (index >= 0 && index < this.args.length) {
            Object object = this.args[index];
            if (object instanceof class_2561) {
                return (class_2561)object;
            }
            return object == null ? TEXT_NULL : class_5348.method_29430((String)object.toString());
        }
        throw new IllegalArgumentException(this.toString());
    }

    public <T> Optional<T> method_27660(class_5348.class_5246<T> styledContentConsumer, class_2583 style) {
        class_5348 formattedText;
        Optional optional;
        this.decompose();
        Iterator<class_5348> var3 = this.decomposedParts.iterator();
        do {
            if (var3.hasNext()) continue;
            return Optional.empty();
        } while (!(optional = (formattedText = var3.next()).method_27658(styledContentConsumer, style)).isPresent());
        return optional;
    }

    public <T> Optional<T> method_27659(class_5348.class_5245<T> contentConsumer) {
        class_5348 formattedText;
        Optional optional;
        this.decompose();
        Iterator<class_5348> var2 = this.decomposedParts.iterator();
        do {
            if (var2.hasNext()) continue;
            return Optional.empty();
        } while (!(optional = (formattedText = var2.next()).method_27657(contentConsumer)).isPresent());
        return optional;
    }

    public class_5250 method_10890(@Nullable class_2168 nbtPathPattern, @Nullable class_1297 entity, int recursionDepth) throws CommandSyntaxException {
        Object[] objects = new Object[this.args.length];
        for (int i = 0; i < objects.length; ++i) {
            Object object = this.args[i];
            objects[i] = object instanceof class_2561 ? class_2564.method_10881((class_2168)nbtPathPattern, (class_2561)((class_2561)object), (class_1297)entity, (int)recursionDepth) : object;
        }
        return class_5250.method_43477((class_7417)new ModTranslatableComponent(this.key, this.fallback, objects));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ModTranslatableComponent) {
            ModTranslatableComponent translatableContents = (ModTranslatableComponent)object;
            if (Objects.equals(this.key, translatableContents.key) && Objects.equals(this.fallback, translatableContents.fallback) && Arrays.equals(this.args, translatableContents.args)) {
                boolean var10000 = true;
                return var10000;
            }
        }
        boolean var10000 = false;
        return var10000;
    }

    public int hashCode() {
        int i = Objects.hashCode(this.key);
        i = 31 * i + Objects.hashCode(this.fallback);
        i = 31 * i + Arrays.hashCode(this.args);
        return i;
    }

    public String toString() {
        String var10000 = this.key;
        return "translation{key='" + var10000 + "'" + (String)(this.fallback != null ? ", fallback='" + this.fallback + "'" : "") + ", args=" + Arrays.toString(this.args) + "}";
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getFallback() {
        return this.fallback;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

