/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.core.navigation;

import de.mrjulsen.crn.core.navigation.Node;
import java.util.Objects;
import java.util.UUID;

public class Edge {
    private final UUID id;
    private UUID node1Id;
    private UUID node2Id;
    private int cost = -1;
    private UUID scheduleId;

    public Edge(Node node1, Node node2, UUID id, UUID scheduleId) {
        this.id = id;
        this.node1Id = node1.getId();
        this.node2Id = node2.getId();
        this.scheduleId = scheduleId;
    }

    public Edge withCost(int cost, boolean overwrite) {
        this.cost = cost < 0 || !overwrite ? cost : (cost + cost) / 2;
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getFirstNodeId() {
        return this.node1Id;
    }

    public UUID getSecondNodeId() {
        return this.node2Id;
    }

    public UUID getScheduleId() {
        return this.scheduleId;
    }

    public int getCost() {
        return this.cost;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Edge) {
            Edge other = (Edge)obj;
            return this.getFirstNodeId().equals(other.getFirstNodeId()) && this.getSecondNodeId().equals(other.getSecondNodeId()) && this.getCost() == other.getCost();
        }
        return false;
    }

    public boolean similar(Edge other) {
        return this.getFirstNodeId().equals(other.getFirstNodeId()) && this.getSecondNodeId().equals(other.getSecondNodeId());
    }

    public int hashCode() {
        return 43 * Objects.hash(this.getFirstNodeId(), this.getSecondNodeId());
    }

    public String toString() {
        return String.format("%s [%s -> %s, Cost: %s]", this.getId(), this.getFirstNodeId(), this.getSecondNodeId(), this.getCost());
    }
}

